/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBlockExpressionImpl
extends OCExpressionBase
implements OCBlockExpression {
    public OCBlockExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCBlockExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public OCCallableKind getKind() {
        return OCCallableKind.BLOCK;
    }

    @Override
    @Nullable
    public OCBlockStatement getBody() {
        return (OCBlockStatement)this.findChildByType(OCElementTypes.BLOCK_STATEMENTS);
    }

    @Override
    public OCTypeElement getReturnTypeElement() {
        return (OCTypeElement)this.findChildByType(OCElementTypes.TYPE_ELEMENT);
    }

    @Override
    public OCParameterList getParameterList() {
        return (OCParameterList)this.findChildByType(OCElementTypes.PARAMETER_LIST);
    }

    @Override
    public List<OCDeclarator> getParameters() {
        OCParameterList parameterList = this.getParameterList();
        return parameterList != null ? parameterList.getParameters() : null;
    }

    @Override
    @Nullable
    public OCNoexceptSpecifier getNoexceptSpecifier() {
        return null;
    }

    @Override
    public OCType calcReturnTypeByBody() {
        return OCExpectedTypeUtil.getReturnTypeOfLambda(this.getBody());
    }

    @Override
    public OCSymbol getSymbol() {
        return new OCBlockSymbol(this);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCBlockExpressionImpl", "accept"));
        }
        visitor.visitBlockExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/psi/impl/OCBlockExpressionImpl", "getType"));
        }
        OCParameterList params = this.getParameterList();
        ArrayList<OCType> paramTypes = new ArrayList<OCType>();
        ArrayList<String> paramNames = new ArrayList<String>();
        if (params != null) {
            for (OCParameterDeclaration parameterDeclaration : params.getParameterDeclarations()) {
                OCDeclarator paramDeclarator = parameterDeclaration.getDeclarator();
                if (paramDeclarator == null) continue;
                paramTypes.add(paramDeclarator.getType());
                paramNames.add(paramDeclarator.getName());
            }
        }
        OCBlockPointerType oCBlockPointerType = OCBlockPointerType.blockPtr(new OCFunctionType(this.getReturnType(), paramTypes, paramNames));
        if (oCBlockPointerType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCBlockExpressionImpl", "getType"));
        }
        return oCBlockPointerType;
    }

    @Override
    @NotNull
    public OCType getReturnType() {
        OCTypeElement returnTypeElement = this.getReturnTypeElement();
        if (returnTypeElement != null) {
            OCType oCType = returnTypeElement.getType();
            if (oCType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCBlockExpressionImpl", "getReturnType"));
            }
            return oCType;
        }
        OCType oCType = this.calcReturnTypeByBody();
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCBlockExpressionImpl", "getReturnType"));
        }
        return oCType;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/psi/impl/OCBlockExpressionImpl", "setName"));
        }
        throw new UnsupportedOperationException();
    }

    public static class OCBlockSymbol
    extends OCSymbolImpl {
        public OCBlockSymbol() {
        }

        public OCBlockSymbol(OCBlockExpression expr) {
            super(expr.getProject(), expr.getContainingFile().getVirtualFile(), expr.getTextOffset(), expr.getReturnTypeElement() != null ? "^" + expr.getReturnTypeElement().getText() + "{...}" : "^{...}", Collections.<String>emptyList());
        }

        @Override
        @NotNull
        public OCSymbolKind getKind() {
            OCSymbolKind oCSymbolKind = OCSymbolKind.BLOCK;
            if (oCSymbolKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCBlockExpressionImpl$OCBlockSymbol", "getKind"));
            }
            return oCSymbolKind;
        }
    }
}

