/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCAssignmentExpressionImpl
extends OCExpressionBase
implements OCAssignmentExpression {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.psi.impl.OCAssignmentExpressionImpl");

    public OCAssignmentExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCAssignmentExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public OCOperatorReference getReference() {
        TextRange range = OCElementUtil.getRangeInParent(this.getOperationSignNode());
        String name = this.getOperationSign().getName();
        OCExpression left = this.getReceiverExpression();
        OCExpression right = this.getSourceExpression();
        if (right != null) {
            return new OCOperatorReference((OCElement)this, name, range, left, right);
        }
        return null;
    }

    @Override
    @NotNull
    public OCExpression getReceiverExpression() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (OCTokenTypes.ASSIGNMENT_OPERATIONS.contains(tt)) {
                LOG.error("Cannot find receiver expression in assignment");
                if (null == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCAssignmentExpressionImpl", "getReceiverExpression"));
                }
                return null;
            }
            if (!OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            OCExpression oCExpression = (OCExpression)child.getPsi();
            if (oCExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCAssignmentExpressionImpl", "getReceiverExpression"));
            }
            return oCExpression;
        }
        LOG.error("Cannot find receiver expression in assignment");
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCAssignmentExpressionImpl", "getReceiverExpression"));
        }
        return null;
    }

    @Override
    public OCExpression getSourceExpression() {
        boolean passedSign = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (OCTokenTypes.ASSIGNMENT_OPERATIONS.contains(tt)) {
                passedSign = true;
                continue;
            }
            if (!passedSign || !OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            return (OCExpression)child.getPsi();
        }
        return null;
    }

    @Override
    @NotNull
    public ASTNode getOperationSignNode() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!OCTokenTypes.ASSIGNMENT_OPERATIONS.contains(tt)) continue;
            ASTNode aSTNode = child;
            if (aSTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCAssignmentExpressionImpl", "getOperationSignNode"));
            }
            return aSTNode;
        }
        throw new AssertionError((Object)"Cannot find operation sign in assignment expression");
    }

    @Override
    @NotNull
    public OCElementType getOperationSign() {
        OCElementType oCElementType = (OCElementType)this.getOperationSignNode().getElementType();
        if (oCElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCAssignmentExpressionImpl", "getOperationSign"));
        }
        return oCElementType;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCAssignmentExpressionImpl", "accept"));
        }
        visitor.visitAssignmentExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/psi/impl/OCAssignmentExpressionImpl", "getType"));
        }
        OCOperatorReference reference = this.getReference();
        if (reference != null) {
            for (OCSymbol operator : reference.resolveToSymbols()) {
                if (!(operator instanceof OCFunctionSymbol)) continue;
                OCType oCType = operator.getEffectiveType();
                if (oCType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCAssignmentExpressionImpl", "getType"));
                }
                return oCType;
            }
        }
        OCType oCType = this.getReceiverExpression().getType(context);
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCAssignmentExpressionImpl", "getType"));
        }
        return oCType;
    }
}

