/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCArraySelectionExpressionImpl
extends OCExpressionBase
implements OCArraySelectionExpression {
    public OCArraySelectionExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCArraySelectionExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public OCOperatorReference getReference() {
        OCExpression array = this.getArrayExpression();
        OCExpression index = this.getIndexExpression();
        if (index != null) {
            class OCSubscriptOperatorReference
            extends OCOperatorReference
            implements MultiRangeReference {
                public OCSubscriptOperatorReference(OCElement element, OCExpression ... params) {
                    super(element, "[]", TextRange.EMPTY_RANGE, params);
                }

                @NotNull
                public List<TextRange> getRanges() {
                    PsiElement right;
                    ArrayList<TextRange> result2 = new ArrayList<TextRange>();
                    PsiElement left = OCArraySelectionExpressionImpl.this.findChildByType(OCTokenTypes.LBRACKET);
                    if (left != null) {
                        result2.add(OCElementUtil.getRangeInParent(left));
                    }
                    if ((right = OCArraySelectionExpressionImpl.this.findChildByType(OCTokenTypes.RBRACKET)) != null) {
                        result2.add(OCElementUtil.getRangeInParent(right));
                    }
                    ArrayList<TextRange> arrayList = result2;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCArraySelectionExpressionImpl$1OCSubscriptOperatorReference", "getRanges"));
                    }
                    return arrayList;
                }

                @Override
                @NotNull
                public List<OCSymbol> resolveToSymbols() {
                    OCMethodSymbol subscriptMethod;
                    if (OCCompilerHelper.supportsSubscripting(OCArraySelectionExpressionImpl.this.getContainingOCFile()) && (subscriptMethod = OCArraySelectionExpressionImpl.this.getArraySubscriptMethod()) != null) {
                        List<OCSymbol> list = Collections.singletonList(subscriptMethod);
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCArraySelectionExpressionImpl$1OCSubscriptOperatorReference", "resolveToSymbols"));
                        }
                        return list;
                    }
                    List<OCSymbol> list = super.resolveToSymbols();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCArraySelectionExpressionImpl$1OCSubscriptOperatorReference", "resolveToSymbols"));
                    }
                    return list;
                }
            }
            return new OCSubscriptOperatorReference(this, array, index);
        }
        return null;
    }

    @Override
    @NotNull
    public OCExpression getArrayExpression() {
        IElementType tt;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null && (tt = child.getElementType()) != OCTokenTypes.LBRACKET; child = child.getTreeNext()) {
            if (!OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            OCExpression oCExpression = (OCExpression)child.getPsi();
            if (oCExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCArraySelectionExpressionImpl", "getArrayExpression"));
            }
            return oCExpression;
        }
        assert (false);
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCArraySelectionExpressionImpl", "getArrayExpression"));
        }
        return null;
    }

    @Override
    public OCExpression getIndexExpression() {
        boolean ok = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt == OCTokenTypes.LBRACKET) {
                ok = true;
                continue;
            }
            if (!ok || !OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            return (OCExpression)child.getPsi();
        }
        return null;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCArraySelectionExpressionImpl", "accept"));
        }
        visitor.visitArraySelectionExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCOperatorReference reference;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/psi/impl/OCArraySelectionExpressionImpl", "getType"));
        }
        OCType arrayType = this.getArrayExpression().getResolvedType();
        if (arrayType instanceof OCCppReferenceType) {
            arrayType = ((OCCppReferenceType)arrayType).getRefType();
        }
        if ((reference = this.getReference()) != null) {
            for (OCSymbol operator : reference.resolveToSymbols()) {
                if (operator instanceof OCFunctionSymbol) {
                    OCType oCType = operator.getEffectiveType();
                    if (oCType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCArraySelectionExpressionImpl", "getType"));
                    }
                    return oCType;
                }
                if (!(operator instanceof OCMethodSymbol)) continue;
                OCMethodSymbol method = (OCMethodSymbol)operator;
                List<OCMethodSymbol.SelectorPartSymbol> selectors = method.getSelectors();
                OCType oCType = selectors.size() == 1 ? method.getReturnType() : selectors.get(0).getParameter().getType();
                if (oCType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCArraySelectionExpressionImpl", "getType"));
                }
                return oCType;
            }
        }
        if (arrayType instanceof OCMagicType) {
            OCType oCType = ((OCMagicType)arrayType).getRefType();
            if (oCType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCArraySelectionExpressionImpl", "getType"));
            }
            return oCType;
        }
        if (arrayType.isPointerToObject() && OCCompilerHelper.supportsSubscripting(this.getContainingOCFile())) {
            OCPointerType oCPointerType = OCIdType.pointerToID(this.getProject());
            if (oCPointerType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCArraySelectionExpressionImpl", "getType"));
            }
            return oCPointerType;
        }
        if (arrayType instanceof OCPointerType) {
            OCType oCType = ((OCPointerType)arrayType).getRefType();
            if (oCType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCArraySelectionExpressionImpl", "getType"));
            }
            return oCType;
        }
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCArraySelectionExpressionImpl", "getType"));
        }
        return oCUnknownType;
    }

    @Override
    protected List<OCExpression> getDependentExpressions() {
        return Collections.singletonList(this.getArrayExpression());
    }

    @Override
    @Nullable
    public OCMethodSymbol getArraySubscriptMethod() {
        OCExpression array = this.getArrayExpression();
        OCExpression index = this.getIndexExpression();
        if (index == null) {
            return null;
        }
        PsiFile file2 = this.getContainingFile();
        OCType arrayType = array.getResolvedType();
        OCType indexType = index.getResolvedType();
        ReadWriteAccessDetector.Access accessType = new OCReadWriteAccessDetector().getExpressionAccess(this);
        String typeName = this.getDefaultTypeName(indexType);
        String accessorName = this.getArraySubscriptAccessorName(indexType, accessType);
        if (accessorName == null || typeName == null) {
            return null;
        }
        if (arrayType.isPointerToID()) {
            arrayType = OCReferenceType.resolvedFromText(typeName, file2);
        } else if (arrayType.isPointerToObject()) {
            arrayType = arrayType.getTerminalType();
        } else {
            return null;
        }
        if (arrayType instanceof OCObjectType) {
            return ((OCObjectType)arrayType).findMember(accessorName, OCMethodSymbol.class);
        }
        return null;
    }

    @Nullable
    private String getDefaultTypeName(OCType indexType) {
        if (indexType.isIntegerCompatible(this)) {
            return "NSMutableArray";
        }
        if (indexType.isPointerToObjectCompatible()) {
            return "NSMutableDictionary";
        }
        return null;
    }

    public static boolean isArraySubscriptMethod(OCMethodSymbol symbol) {
        String name = symbol.getName();
        return "objectAtIndexedSubscript:".equals(name) || "setObject:atIndexedSubscript:".equals(name) || "objectForKeyedSubscript:".equals(name) || "setObject:forKeyedSubscript:".equals(name);
    }

    @Override
    @Nullable
    public String getArraySubscriptAccessorName(OCType indexType, ReadWriteAccessDetector.Access accessType) {
        if (indexType.isIntegerCompatible(this)) {
            return accessType == ReadWriteAccessDetector.Access.Read ? "objectAtIndexedSubscript:" : "setObject:atIndexedSubscript:";
        }
        if (indexType.isPointerToObjectCompatible()) {
            return accessType == ReadWriteAccessDetector.Access.Read ? "objectForKeyedSubscript:" : "setObject:forKeyedSubscript:";
        }
        return null;
    }

    @Override
    @Nullable
    public String getArraySubscriptMethodSignature(OCType indexType, ReadWriteAccessDetector.Access accessType) {
        if (indexType.isIntegerCompatible(this)) {
            return accessType == ReadWriteAccessDetector.Access.Read ? "- (id)objectAtIndexedSubscript:(NSInteger)idx" : "- (void)setObject:(id)obj atIndexedSubscript:(NSInteger)idx";
        }
        if (indexType.isPointerToObjectCompatible()) {
            return accessType == ReadWriteAccessDetector.Access.Read ? "- (id)objectForKeyedSubscript:(id)key" : "- (void)setObject:(id)obj forKeyedSubscript:(id <NSCopying>)key";
        }
        return null;
    }
}

