/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCArgumentSelectorImpl
extends OCElementBase
implements OCArgumentSelector {
    public OCArgumentSelectorImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCArgumentSelectorImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public String getSelectorName() {
        StringBuilder builder = new StringBuilder();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt != OCTokenTypes.IDENTIFIER && tt != OCTokenTypes.COLON) continue;
            builder.append(child.getText());
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCArgumentSelectorImpl", "getSelectorName"));
        }
        return string;
    }

    @Override
    @Nullable
    public PsiElement getSelectorIdentifier() {
        return this.findChildByType(OCTokenTypes.IDENTIFIER);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCArgumentSelectorImpl", "accept"));
        }
        visitor.visitArgumentSelector(this);
    }
}

