/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.FileContentUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.IndexingDataKeys;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInitialInclusionContext;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveLanguageAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInclusionContextUtil {
    private static final Key<OCResolveConfiguration> USER_SELECTED_CONFIGURATION = Key.create((String)"USER_SELECTED_CONFIGURATION");
    private static final NotNullLazyKey<CachedValue<OCResolveConfiguration>, PsiFile> BUILD_CONFIGURATION_KEY = NotNullLazyKey.create((String)"BUILD_CONFIGURATION_KEY", (NotNullFunction)new NotNullFunction<PsiFile, CachedValue<OCResolveConfiguration>>(){

        @NotNull
        public CachedValue<OCResolveConfiguration> fun(final PsiFile file2) {
            final Project project = file2.getProject();
            CachedValue cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<OCResolveConfiguration>(){

                public CachedValueProvider.Result<OCResolveConfiguration> compute() {
                    OCWorkspaceModificationTrackers tracker = OCWorkspaceManager.getWorkspace(project).getModificationTrackers();
                    return new CachedValueProvider.Result((Object)this.inferConfiguration(), new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, tracker.getProjectsListTracker(), tracker.getProjectFilesListTracker(), tracker.getSourceFilesListTracker()});
                }

                private OCResolveConfiguration inferConfiguration() {
                    VirtualFile virtualFile;
                    if (SymbolTableProvider.isSourceFile(file2) && (virtualFile = OCInclusionContextUtil.getVirtualFile(file2.getOriginalFile())) != null) {
                        return OCInclusionContextUtil.getResolveRootAndActiveConfiguration(virtualFile, file2.getProject()).getConfiguration();
                    }
                    return null;
                }
            }, false);
            if (cachedValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil$1", "fun"));
            }
            return cachedValue;
        }
    });
    public static final NotNullLazyKey<Map<VirtualFile, OCResolveRootAndConfiguration>, Project> HEADER_ROOT_AND_CONFIGURATION_KEY = NotNullLazyKey.create((String)"HEADER_ROOT_AND_CONFIGURATION_KEY", (NotNullFunction)new NotNullFunction<Project, Map<VirtualFile, OCResolveRootAndConfiguration>>(){

        @NotNull
        public Map<VirtualFile, OCResolveRootAndConfiguration> fun(Project p) {
            ConcurrentHashMap<VirtualFile, OCResolveRootAndConfiguration> concurrentHashMap = new ConcurrentHashMap<VirtualFile, OCResolveRootAndConfiguration>();
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil$2", "fun"));
            }
            return concurrentHashMap;
        }
    });
    private static final NotNullLazyKey<Map<VirtualFile, OCImmutableInclusionContext>, Project> HEADER_CONTEXT_KEY = NotNullLazyKey.create((String)"HEADER_CONTEXT_KEY", (NotNullFunction)new NotNullFunction<Project, Map<VirtualFile, OCImmutableInclusionContext>>(){

        @NotNull
        public Map<VirtualFile, OCImmutableInclusionContext> fun(Project p) {
            ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
            if (concurrentMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil$3", "fun"));
            }
            return concurrentMap;
        }
    });
    private static final NotNullLazyKey<Map<VirtualFile, OCContextChangeSet>, Project> CONTEXT_CHANGES_KEY = NotNullLazyKey.create((String)"CONTEXT_CHANGES_KEY", (NotNullFunction)new NotNullFunction<Project, Map<VirtualFile, OCContextChangeSet>>(){

        @NotNull
        public Map<VirtualFile, OCContextChangeSet> fun(Project p) {
            ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
            if (concurrentMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil$4", "fun"));
            }
            return concurrentMap;
        }
    });

    @Deprecated
    @Nullable
    public static OCResolveConfiguration computePreselectedConfiguration(@NotNull Project project, @NotNull Collection<? extends OCResolveConfiguration> configs) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "computePreselectedConfiguration"));
        }
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "computePreselectedConfiguration"));
        }
        OCResolveConfiguration selectedConfiguration = OCInclusionContextUtil.findPreselectedConfiguration(project, configs);
        if (selectedConfiguration != null) {
            return selectedConfiguration;
        }
        return configs.isEmpty() ? null : Collections.min(configs);
    }

    @Nullable
    public static OCResolveConfiguration findPreselectedConfiguration(@NotNull Project project, @NotNull Collection<? extends OCResolveConfiguration> configs) {
        boolean havePreselectedConf;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "findPreselectedConfiguration"));
        }
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "findPreselectedConfiguration"));
        }
        OCResolveConfiguration selectedConfiguration = OCInclusionContextUtil.getUserSelectedConfiguration(project);
        boolean bl = havePreselectedConf = selectedConfiguration != null;
        if (configs.contains(selectedConfiguration)) {
            return selectedConfiguration;
        }
        selectedConfiguration = OCWorkspaceManager.getWorkspace(project).getSelectedResolveConfiguration();
        havePreselectedConf |= selectedConfiguration != null;
        if (configs.contains(selectedConfiguration)) {
            return selectedConfiguration;
        }
        return havePreselectedConf || configs.isEmpty() ? null : Collections.min(configs);
    }

    @Nullable
    @Contract(value="null -> null")
    public static VirtualFile getVirtualFile(@Nullable PsiFile file2) {
        if (file2 == null) {
            return null;
        }
        VirtualFile vFile = file2.getOriginalFile().getVirtualFile();
        return vFile != null ? vFile : (VirtualFile)file2.getUserData(IndexingDataKeys.VIRTUAL_FILE);
    }

    public static boolean isNeedToFindRoot(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "isNeedToFindRoot"));
        }
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file2);
        if (virtualFile == null) {
            return false;
        }
        return OCInclusionContextUtil.isNeedToFindRoot(virtualFile, file2.getProject());
    }

    public static boolean isNeedToFindRoot(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "isNeedToFindRoot"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "isNeedToFindRoot"));
        }
        return !OCFileImpl.isSourceCodeFile(file2.getName()) && !OCInclusionContextUtil.isPCHFile(file2, project);
    }

    private static boolean isPCHFile(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "isPCHFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "isPCHFile"));
        }
        return !OCInclusionContext.getBuildConfigurationByPchFile(file2, project).isEmpty();
    }

    @NotNull
    public static OCResolveRootAndConfiguration getResolveRootAndActiveConfiguration(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getResolveRootAndActiveConfiguration"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getResolveRootAndActiveConfiguration"));
        }
        Map cache = (Map)HEADER_ROOT_AND_CONFIGURATION_KEY.getValue((UserDataHolder)project);
        OCResolveRootAndConfiguration cached = (OCResolveRootAndConfiguration)cache.get(virtualFile);
        if (cached != null) {
            OCResolveRootAndConfiguration oCResolveRootAndConfiguration = cached;
            if (oCResolveRootAndConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getResolveRootAndActiveConfiguration"));
            }
            return oCResolveRootAndConfiguration;
        }
        OCResolveRootAndConfiguration result2 = null;
        if (OCInclusionContextUtil.isNeedToFindRoot(virtualFile, project)) {
            result2 = OCInclusionContextUtil.getResolveRootAndActiveConfigurationForHeader(virtualFile, project);
        }
        if (result2 == null) {
            result2 = new OCResolveRootAndConfiguration(OCInclusionContextUtil.doGetPreselectedConfiguration(virtualFile, project), virtualFile);
        }
        cache.put(virtualFile, result2);
        OCResolveRootAndConfiguration oCResolveRootAndConfiguration = result2;
        if (oCResolveRootAndConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getResolveRootAndActiveConfiguration"));
        }
        return oCResolveRootAndConfiguration;
    }

    @NotNull
    public static OCResolveLanguageAndConfiguration getOrCalculateParsedResolveLanguageAndConfiguration(@NotNull PsiFile file2) {
        OCResolveLanguageAndConfiguration langAndConfig;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getOrCalculateParsedResolveLanguageAndConfiguration"));
        }
        OCResolveLanguageAndConfiguration oCResolveLanguageAndConfiguration = langAndConfig = file2 instanceof OCConfigurationOwner ? ((OCConfigurationOwner)file2).getParsedResolveLanguageAndConfiguration() : null;
        if (langAndConfig != null) {
            OCResolveLanguageAndConfiguration oCResolveLanguageAndConfiguration2 = langAndConfig;
            if (oCResolveLanguageAndConfiguration2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getOrCalculateParsedResolveLanguageAndConfiguration"));
            }
            return oCResolveLanguageAndConfiguration2;
        }
        OCImmutableInclusionContext context = OCInclusionContextUtil.headerContext(file2);
        OCResolveLanguageAndConfiguration oCResolveLanguageAndConfiguration3 = new OCResolveLanguageAndConfiguration(context.getConfiguration(), context.getLanguageKind());
        if (oCResolveLanguageAndConfiguration3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getOrCalculateParsedResolveLanguageAndConfiguration"));
        }
        return oCResolveLanguageAndConfiguration3;
    }

    @Nullable
    private static OCResolveRootAndConfiguration getResolveRootAndActiveConfigurationForHeader(@NotNull VirtualFile virtualHeaderFile, @NotNull Project project) {
        if (virtualHeaderFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualHeaderFile", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getResolveRootAndActiveConfigurationForHeader"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getResolveRootAndActiveConfigurationForHeader"));
        }
        String headerNameWithoutExtension = virtualHeaderFile.getNameWithoutExtension();
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(OCImportGraph.getAllHeaderRoots(project, virtualHeaderFile));
        Collections.sort(roots, new VirtualFileComparator(project, headerNameWithoutExtension));
        OCResolveRootAndConfiguration fallBack = null;
        for (VirtualFile rootFile : roots) {
            HashSet configurations = new HashSet();
            OCImportGraph.fillHeaderConfigurationsForRoot(project, virtualHeaderFile, rootFile, (Set<OCResolveConfiguration>)configurations, null);
            if (configurations.isEmpty()) continue;
            OCResolveConfiguration config = OCInclusionContextUtil.findPreselectedConfiguration(project, (Collection<? extends OCResolveConfiguration>)configurations);
            if (config != null) {
                return new OCResolveRootAndConfiguration(config, rootFile);
            }
            if (fallBack != null) continue;
            fallBack = new OCResolveRootAndConfiguration((OCResolveConfiguration)Collections.min(configurations), rootFile);
        }
        return fallBack;
    }

    @Nullable
    private static OCResolveConfiguration doGetPreselectedConfiguration(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "doGetPreselectedConfiguration"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "doGetPreselectedConfiguration"));
        }
        return OCInclusionContextUtil.computePreselectedConfiguration(project, OCInclusionContextUtil.getAllBuildConfigurationsForIndexing(virtualFile, project));
    }

    public static void invalidateHeaderRootAndActiveConfigurationForAllExcept(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "invalidateHeaderRootAndActiveConfigurationForAllExcept"));
        }
        OCInclusionContextUtil.removeExcept((Map)HEADER_ROOT_AND_CONFIGURATION_KEY.getValue((UserDataHolder)project), virtualFile);
        OCInclusionContextUtil.invalidateHeaderContextsExcept(virtualFile, project);
    }

    public static void invalidateHeaderContextsExcept(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "invalidateHeaderContextsExcept"));
        }
        OCInclusionContextUtil.removeExcept((Map)HEADER_CONTEXT_KEY.getValue((UserDataHolder)project), virtualFile);
        OCInclusionContextUtil.invalidateContextChangeCacheExcept(virtualFile, project);
    }

    public static void invalidateContextChangeCacheExcept(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "invalidateContextChangeCacheExcept"));
        }
        OCInclusionContextUtil.removeExcept((Map)CONTEXT_CHANGES_KEY.getValue((UserDataHolder)project), virtualFile);
    }

    public static <K, V> void removeExcept(@NotNull Map<K, V> map, @Nullable K key) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "removeExcept"));
        }
        if (key == null) {
            map.clear();
        } else {
            map.keySet().retainAll(Collections.singleton(key));
        }
    }

    public static void invalidateHeaderRootAndActiveConfigurationFor(@Nullable VirtualFile virtualFileInEditor, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "invalidateHeaderRootAndActiveConfigurationFor"));
        }
        if (virtualFileInEditor == null) {
            return;
        }
        Map cached = (Map)HEADER_ROOT_AND_CONFIGURATION_KEY.getValue((UserDataHolder)project);
        cached.remove(virtualFileInEditor);
        OCInclusionContextUtil.invalidateHeaderContextsExcept(null, project);
    }

    @NotNull
    public static OCImmutableInclusionContext headerContext(@NotNull PsiFile file2) {
        OCImmutableInclusionContext cached;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "headerContext"));
        }
        PsiFile original = OCInclusionContextUtil.getOriginalFile(file2);
        if (original == null) {
            OCInclusionContext oCInclusionContext = OCInclusionContext.emptyWithBuiltinMacros(null, file2);
            if (oCInclusionContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "headerContext"));
            }
            return oCInclusionContext;
        }
        Project project = original.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(original);
        Map cache = null;
        if (virtualFile != null && (cached = (OCImmutableInclusionContext)(cache = (Map)HEADER_CONTEXT_KEY.getValue((UserDataHolder)project)).get(virtualFile)) != null) {
            OCImmutableInclusionContext oCImmutableInclusionContext = cached;
            if (oCImmutableInclusionContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "headerContext"));
            }
            return oCImmutableInclusionContext;
        }
        OCInclusionContext result2 = OCInclusionContextUtil.innerCalculateHeaderContext(original, null);
        if (virtualFile != null) {
            cache.put(virtualFile, result2);
        }
        OCInclusionContext oCInclusionContext = result2;
        if (oCInclusionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "headerContext"));
        }
        return oCInclusionContext;
    }

    public static OCInclusionContext calculateHeaderContext(@NotNull PsiFile file2, @Nullable OCLanguageKind languageKind) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "calculateHeaderContext"));
        }
        PsiFile original = OCInclusionContextUtil.getOriginalFile(file2);
        if (original == null) {
            return OCInclusionContext.emptyWithBuiltinMacros(languageKind, file2);
        }
        return OCInclusionContextUtil.innerCalculateHeaderContext(original, languageKind);
    }

    @Nullable
    private static PsiFile getOriginalFile(@Nullable PsiFile file2) {
        PsiFile psiFile;
        PsiFile physical;
        if (file2 == null) {
            return null;
        }
        PsiFile original = file2.getOriginalFile();
        if (!(original instanceof OCFile)) {
            return null;
        }
        if (original.isPhysical()) {
            return file2;
        }
        for (physical = original; physical != null && !physical.isPhysical(); physical = physical.getContext()) {
        }
        PsiFile psiFile2 = psiFile = physical != null ? physical.getContainingFile() : null;
        if (psiFile != null) {
            return psiFile;
        }
        return null;
    }

    @NotNull
    private static OCInclusionContext innerCalculateHeaderContext(@NotNull PsiFile original, @Nullable OCLanguageKind kind) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "innerCalculateHeaderContext"));
        }
        Project project = original.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(original);
        if (virtualFile != null && OCInclusionContextUtil.isNeedToFindRoot(virtualFile, project)) {
            OCResolveConfiguration config;
            OCFile importHolder;
            OCResolveRootAndConfiguration rootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(virtualFile, project);
            VirtualFile rootFile = rootAndConfiguration.getRootFile();
            OCFile oCFile = importHolder = rootFile != null && rootFile.isValid() ? (OCFile)PsiManager.getInstance((Project)project).findFile(rootFile) : null;
            if (importHolder != null && !rootFile.equals(virtualFile) && (config = rootAndConfiguration.getConfiguration()) != null) {
                OCImmutableInclusionContext precompiledContext = OCInclusionContext.tryFindInCachedPCHPrecompiledContexts(config, virtualFile, rootFile);
                if (precompiledContext == null) {
                    precompiledContext = OCInclusionContext.initialPCHContextWithoutRoot(config, importHolder.getKind(), importHolder);
                } else {
                    precompiledContext = precompiledContext.getParent();
                    assert (precompiledContext instanceof OCInitialInclusionContext);
                }
                OCInclusionContext result2 = precompiledContext.derive(importHolder);
                result2.preprocessContextOf(importHolder, virtualFile);
                OCInclusionContext oCInclusionContext = result2;
                if (oCInclusionContext == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "innerCalculateHeaderContext"));
                }
                return oCInclusionContext;
            }
        }
        OCInclusionContext oCInclusionContext = OCInclusionContextUtil.sourceFileContext((OCFile)original, kind);
        if (oCInclusionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "innerCalculateHeaderContext"));
        }
        return oCInclusionContext;
    }

    @NotNull
    private static OCInclusionContext sourceFileContext(@NotNull OCFile file2, @Nullable OCLanguageKind kindOrNullForDefault) {
        OCResolveConfiguration config;
        VirtualFile virtualFile;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "sourceFileContext"));
        }
        if (kindOrNullForDefault == null) {
            kindOrNullForDefault = file2.getKind();
        }
        if ((virtualFile = OCInclusionContextUtil.getVirtualFile(file2)) != null && (config = OCInclusionContextUtil.doGetPreselectedConfiguration(virtualFile, file2.getProject())) != null) {
            OCInclusionContext oCInclusionContext = OCInclusionContext.sourceParsingContext(config, kindOrNullForDefault, file2);
            if (oCInclusionContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "sourceFileContext"));
            }
            return oCInclusionContext;
        }
        OCInclusionContext oCInclusionContext = OCInclusionContext.emptyWithBuiltinMacros(kindOrNullForDefault, file2);
        if (oCInclusionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "sourceFileContext"));
        }
        return oCInclusionContext;
    }

    public static void setUserSelectedConfiguration(@NotNull PsiFile psiFile, @Nullable OCResolveConfiguration config) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "setUserSelectedConfiguration"));
        }
        Project project = psiFile.getProject();
        project.putUserData(USER_SELECTED_CONFIGURATION, (Object)config);
        psiFile.putCopyableUserData(BUILD_CONFIGURATION_KEY, null);
        OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationFor(OCInclusionContextUtil.getVirtualFile(psiFile), project);
        VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 != null) {
            FileContentUtil.reparseFiles((Project)project, Collections.singletonList(file2), (boolean)false);
        }
    }

    @Nullable
    private static OCResolveConfiguration getUserSelectedConfiguration(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getUserSelectedConfiguration"));
        }
        return (OCResolveConfiguration)project.getUserData(USER_SELECTED_CONFIGURATION);
    }

    @Nullable
    public static OCResolveConfiguration getActiveConfiguration(@Nullable PsiElement element) {
        return element == null ? null : (OCResolveConfiguration)((CachedValue)BUILD_CONFIGURATION_KEY.getValue((UserDataHolder)element.getContainingFile())).getValue();
    }

    @Nullable
    public static OCResolveConfiguration getActiveConfiguration(@Nullable VirtualFile file2, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getActiveConfiguration"));
        }
        return OCInclusionContextUtil.getActiveConfiguration(file2 == null ? null : PsiManager.getInstance((Project)project).findFile(file2));
    }

    @NotNull
    public static Collection<? extends OCResolveConfiguration> getAllBuildConfigurationsForFile(@NotNull PsiFile file2, @Nullable ProgressIndicator progress) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getAllBuildConfigurationsForFile"));
        }
        VirtualFile root = OCInclusionContextUtil.getVirtualFile(file2);
        if (root != null && OCInclusionContextUtil.isNeedToFindRoot(file2)) {
            assert (file2 instanceof OCFile);
            Set<OCResolveConfiguration> set = OCImportGraph.getAllHeaderConfigurations((OCFile)file2, progress);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getAllBuildConfigurationsForFile"));
            }
            return set;
        }
        Collection<? extends OCResolveConfiguration> collection = OCInclusionContextUtil.getAllBuildConfigurationsOfTargetsOfFile(root, file2.getProject());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getAllBuildConfigurationsForFile"));
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends OCResolveConfiguration> getAllBuildConfigurationsOfTargetsOfFile(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getAllBuildConfigurationsOfTargetsOfFile"));
        }
        Collection<OCResolveConfiguration> configOfPch = OCInclusionContext.getBuildConfigurationByPchFile(virtualFile, project);
        if (!configOfPch.isEmpty()) {
            Collection<OCResolveConfiguration> collection = configOfPch;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getAllBuildConfigurationsOfTargetsOfFile"));
            }
            return collection;
        }
        List<? extends OCResolveConfiguration> list = OCWorkspaceManager.getWorkspace(project).getConfigurationsForFile(virtualFile);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getAllBuildConfigurationsOfTargetsOfFile"));
        }
        return list;
    }

    @NotNull
    public static Collection<? extends OCResolveConfiguration> getAllBuildConfigurationsForIndexing(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getAllBuildConfigurationsForIndexing"));
        }
        Collection<? extends OCResolveConfiguration> result2 = OCInclusionContextUtil.getAllBuildConfigurationsOfTargetsOfFile(virtualFile, project);
        if (!result2.isEmpty()) {
            Collection<? extends OCResolveConfiguration> collection = result2;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getAllBuildConfigurationsForIndexing"));
            }
            return collection;
        }
        OCResolveConfiguration selected = OCInclusionContextUtil.getUserSelectedConfiguration(project);
        if (selected == null) {
            selected = (OCResolveConfiguration)ContainerUtil.getFirstItem(OCWorkspaceManager.getWorkspace(project).getConfigurations());
        }
        Collection<Object> collection = selected == null ? Collections.emptyList() : Collections.singleton(selected);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "getAllBuildConfigurationsForIndexing"));
        }
        return collection;
    }

    public static String pragmaOnceId(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "pragmaOnceId"));
        }
        return OCInclusionContextUtil.fileGuard(vFile, "__CIDR_pragma_once");
    }

    public static String inclusionId(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "inclusionId"));
        }
        return OCInclusionContextUtil.fileGuard(vFile, "__CIDR_included");
    }

    private static String fileGuard(VirtualFile vFile, String prefix) {
        if (vFile instanceof VirtualFileWithId) {
            return prefix + "_id_" + ((VirtualFileWithId)vFile).getId();
        }
        return prefix + "_path_" + vFile.getPath();
    }

    public static void storeCachedContextChangeSet(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull OCContextChangeSet changeSet) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "storeCachedContextChangeSet"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "storeCachedContextChangeSet"));
        }
        if (changeSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeSet", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "storeCachedContextChangeSet"));
        }
        ((Map)CONTEXT_CHANGES_KEY.get((UserDataHolder)project)).put(virtualFile, changeSet);
    }

    public static OCContextChangeSet cachedContextChangeSet(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil", "cachedContextChangeSet"));
        }
        if (virtualFile == null) {
            return null;
        }
        return (OCContextChangeSet)((Map)CONTEXT_CHANGES_KEY.getValue((UserDataHolder)project)).get(virtualFile);
    }

    public static class VirtualFileComparator
    implements Comparator<VirtualFile> {
        private final Project myProject;
        private final String myHeaderNameWithoutExtension;

        public VirtualFileComparator(Project project, String headerNameWithoutExtension) {
            this.myProject = project;
            this.myHeaderNameWithoutExtension = headerNameWithoutExtension.toUpperCase(Locale.getDefault());
        }

        @Override
        public int compare(@NotNull VirtualFile root1, @NotNull VirtualFile root2) {
            if (root1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root1", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil$VirtualFileComparator", "compare"));
            }
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root2", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil$VirtualFileComparator", "compare"));
            }
            int result2 = Comparing.compare((boolean)OCInclusionContextUtil.isPCHFile(root1, this.myProject), (boolean)OCInclusionContextUtil.isPCHFile(root2, this.myProject));
            if (result2 != 0) {
                return -result2;
            }
            result2 = Comparing.compare((boolean)OCFileTypeHelpers.isSourceFile(root1.getName()), (boolean)OCFileTypeHelpers.isSourceFile(root2.getName()));
            if (result2 != 0) {
                return -result2;
            }
            String rootName1 = root1.getNameWithoutExtension().toUpperCase(Locale.getDefault());
            String rootName2 = root2.getNameWithoutExtension().toUpperCase(Locale.getDefault());
            result2 = Comparing.compare((boolean)this.myHeaderNameWithoutExtension.equals(rootName1), (boolean)this.myHeaderNameWithoutExtension.equals(rootName2));
            if (result2 != 0) {
                return -result2;
            }
            result2 = Comparing.compare((Comparable)((Object)rootName1), (Comparable)((Object)rootName2));
            if (result2 != 0) {
                return result2;
            }
            return Comparing.compare((Comparable)((Object)root1.getPath()), (Comparable)((Object)root2.getPath()));
        }
    }
}

