/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImportGraph {
    private static final NotNullLazyKey<MultiMap<VirtualFile, VirtualFile>, Project> HEADER_TO_ALL_ROOTS_CACHE = NotNullLazyKey.create((String)"HEADER_TO_ALL_ROOTS_CACHE", (NotNullFunction)new NotNullFunction<Project, MultiMap<VirtualFile, VirtualFile>>(){

        @NotNull
        public MultiMap<VirtualFile, VirtualFile> fun(Project dom) {
            ConcurrentMultiMap concurrentMultiMap = new ConcurrentMultiMap();
            if (concurrentMultiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph$1", "fun"));
            }
            return concurrentMultiMap;
        }
    });
    private static final NotNullLazyKey<Map<VirtualFile, Set<VirtualFile>>, OCResolveConfiguration> ROOT_TO_ALL_HEADERS_CACHE = NotNullLazyKey.create((String)"ROOT_TO_ALL_HEADERS_CACHE", (NotNullFunction)new NotNullFunction<OCResolveConfiguration, Map<VirtualFile, Set<VirtualFile>>>(){

        @NotNull
        public Map<VirtualFile, Set<VirtualFile>> fun(OCResolveConfiguration dom) {
            ConcurrentHashMap<VirtualFile, Set<VirtualFile>> concurrentHashMap = new ConcurrentHashMap<VirtualFile, Set<VirtualFile>>();
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph$2", "fun"));
            }
            return concurrentHashMap;
        }
    });
    private static final NotNullLazyKey<Cache, Project> IMPORTS_GRAPH = NotNullLazyKey.create((String)"IMPORT_GRAPH", (NotNullFunction)new NotNullFunction<Project, Cache>(){

        @NotNull
        public Cache fun(Project project) {
            Cache cache = new Cache(project);
            if (cache == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph$4", "fun"));
            }
            return cache;
        }
    });

    public static void invalidateHeaderRootsCache(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "invalidateHeaderRootsCache"));
        }
        project.putUserData(HEADER_TO_ALL_ROOTS_CACHE, null);
    }

    @NotNull
    public static Collection<VirtualFile> getAllHeaderRoots(@NotNull Project project, @NotNull VirtualFile header) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "getAllHeaderRoots"));
        }
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "getAllHeaderRoots"));
        }
        MultiMap value = (MultiMap)HEADER_TO_ALL_ROOTS_CACHE.getValue((UserDataHolder)project);
        if (!value.containsKey((Object)header)) {
            Collection<VirtualFile> roots = OCImportGraph.findAllRootsThatIncludes(project, header, true);
            assert (!roots.isEmpty());
            value.put((Object)header, roots);
        }
        Collection collection = value.get((Object)header);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "getAllHeaderRoots"));
        }
        return collection;
    }

    public static void buildSymbolAndRootHeaderCache(@NotNull OCResolveConfiguration configuration, @NotNull VirtualFile rootFile, @Nullable OCLanguageKind kind, boolean toCompact, @Nullable ProgressIndicator indicator) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "buildSymbolAndRootHeaderCache"));
        }
        if (rootFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootFile", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "buildSymbolAndRootHeaderCache"));
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        if (!rootFile.isValid()) {
            return;
        }
        Project project = configuration.getProject();
        if (!OCInclusionContextUtil.isNeedToFindRoot(rootFile, project)) {
            OCImportGraph.invalidateRootHeadersCache(configuration, rootFile);
            OCImportGraph.getAllRootHeaders(configuration, rootFile, indicator);
        } else {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(rootFile);
            if (psiFile instanceof OCConfigurationOwner) {
                if (kind == null) {
                    kind = ((OCConfigurationOwner)psiFile).getKind();
                }
                FileSymbolTable.forFile(psiFile, OCInclusionContext.sourceParsingContext(configuration, kind, psiFile), toCompact);
            }
        }
    }

    public static void invalidateRootHeadersCache(OCResolveConfiguration configuration, VirtualFile file2) {
        ((Map)ROOT_TO_ALL_HEADERS_CACHE.getValue((UserDataHolder)configuration)).remove(file2);
    }

    public static void invalidateRootHeadersCache(OCResolveConfiguration configuration) {
        ((Map)ROOT_TO_ALL_HEADERS_CACHE.getValue((UserDataHolder)configuration)).clear();
    }

    @NotNull
    public static Set<VirtualFile> getAllRootHeaders(@NotNull OCResolveConfiguration configuration, @NotNull VirtualFile root, @Nullable ProgressIndicator indicator) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "getAllRootHeaders"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "getAllRootHeaders"));
        }
        Project project = configuration.getProject();
        assert (!OCInclusionContextUtil.isNeedToFindRoot(root, project)) : "Not a root file";
        Map value = (Map)ROOT_TO_ALL_HEADERS_CACHE.getValue((UserDataHolder)configuration);
        Set<Object> result2 = (Set)value.get(root);
        if (result2 == null) {
            PsiFile rootPsi;
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            PsiFile psiFile = rootPsi = root.isValid() ? psiManager.findFile(root) : null;
            if (rootPsi instanceof OCConfigurationOwner) {
                if (OCInclusionContext.isPrecompiledHeader(root, configuration)) {
                    result2 = OCImportGraph.getAllPCHRootHeaders(psiManager, project, configuration, root, indicator);
                } else {
                    OCInclusionContext context = OCInclusionContext.sourceParsingContext(configuration, ((OCConfigurationOwner)rootPsi).getKind(), rootPsi);
                    context.preprocessInclude(rootPsi, true);
                    result2 = context.getProcessedFiles();
                }
            } else {
                result2 = Collections.emptySet();
            }
            value.put(root, result2);
        }
        Set set = result2;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "getAllRootHeaders"));
        }
        return set;
    }

    private static Set<VirtualFile> getAllPCHRootHeaders(@NotNull PsiManager psiManager, @NotNull Project project, @NotNull OCResolveConfiguration configuration, @NotNull VirtualFile pch, @Nullable ProgressIndicator indicator) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "getAllPCHRootHeaders"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "getAllPCHRootHeaders"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "getAllPCHRootHeaders"));
        }
        if (pch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pch", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "getAllPCHRootHeaders"));
        }
        HashSet<Pair> srcs = new HashSet<Pair>();
        OCWorkspace workspace = OCWorkspaceManager.getWorkspace(project);
        for (VirtualFile vroot : OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(project)) {
            OCLanguageKind kind;
            PsiFile rootPsi;
            if (!OCFileImpl.isSourceCodeFile(vroot.getName()) || pch.equals(vroot)) continue;
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (!workspace.getConfigurationsForFile(vroot).contains(configuration) || (rootPsi = vroot.isValid() ? psiManager.findFile(vroot) : null) == null || !(rootPsi instanceof OCConfigurationOwner) || !(kind = ((OCConfigurationOwner)rootPsi).getKind()).supportsPrecompiledHeaders()) continue;
            srcs.add(Pair.create((Object)kind, (Object)rootPsi));
        }
        THashSet result2 = new THashSet();
        for (Pair src : srcs) {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            result2.addAll(OCInclusionContext.initialPCHContextWithoutRoot(configuration, (OCLanguageKind)src.first, (PsiFile)src.second).getProcessedFiles());
        }
        result2.remove((Object)pch);
        return Collections.unmodifiableSet(result2);
    }

    @NotNull
    public static Set<OCResolveConfiguration> getAllHeaderConfigurations(@NotNull OCFile header, @Nullable ProgressIndicator progress) {
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "getAllHeaderConfigurations"));
        }
        Project project = header.getProject();
        VirtualFile file2 = OCInclusionContextUtil.getVirtualFile(header);
        if (file2 == null) {
            Set<OCResolveConfiguration> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "getAllHeaderConfigurations"));
            }
            return set;
        }
        HashSet<OCResolveConfiguration> ret = new HashSet<OCResolveConfiguration>();
        for (VirtualFile root : OCImportGraph.getAllHeaderRoots(header.getProject(), file2)) {
            OCImportGraph.fillHeaderConfigurationsForRoot(project, file2, root, ret, progress);
        }
        Set<OCResolveConfiguration> set = Collections.unmodifiableSet(ret);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "getAllHeaderConfigurations"));
        }
        return set;
    }

    public static void fillHeaderConfigurationsForRoot(@NotNull Project project, @NotNull VirtualFile header, @NotNull VirtualFile root, @NotNull Set<OCResolveConfiguration> result2, @Nullable ProgressIndicator progress) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "fillHeaderConfigurationsForRoot"));
        }
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "fillHeaderConfigurationsForRoot"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "fillHeaderConfigurationsForRoot"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "fillHeaderConfigurationsForRoot"));
        }
        if (progress != null) {
            progress.checkCanceled();
        }
        Collection<? extends OCResolveConfiguration> configs = OCInclusionContextUtil.getAllBuildConfigurationsOfTargetsOfFile(root, project);
        if (!OCInclusionContextUtil.isNeedToFindRoot(root, project)) {
            for (OCResolveConfiguration oCResolveConfiguration : configs) {
                if (progress != null) {
                    progress.checkCanceled();
                }
                if (!OCImportGraph.getAllRootHeaders(oCResolveConfiguration, root, progress).contains(header)) continue;
                result2.add(oCResolveConfiguration);
            }
        } else {
            result2.addAll(configs);
        }
    }

    private static boolean processPossibleRootsThatInclude(@NotNull Project project, @NotNull VirtualFile headerFile, @NotNull Processor<VirtualFile> processor2, boolean strict) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "processPossibleRootsThatInclude"));
        }
        if (headerFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerFile", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "processPossibleRootsThatInclude"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "processPossibleRootsThatInclude"));
        }
        ArrayList<VirtualFile> importers = new ArrayList<VirtualFile>();
        HashSet<VirtualFile> processed = new HashSet<VirtualFile>();
        importers.add(headerFile);
        while (!importers.isEmpty()) {
            ArrayList<VirtualFile> upperImporters = new ArrayList<VirtualFile>();
            for (VirtualFile headerHolder : importers) {
                if (headerHolder == null || !processed.add(headerHolder)) continue;
                Collection<VirtualFile> maybeUpperImporter = ((Cache)IMPORTS_GRAPH.getValue((UserDataHolder)project)).get(headerHolder, strict);
                for (VirtualFile importHolder : maybeUpperImporter) {
                    if (!importHolder.isValid()) continue;
                    PsiFile psiImportHolder = PsiManager.getInstance((Project)project).findFile(importHolder);
                    if (psiImportHolder instanceof OCFile && !OCInclusionContextUtil.isNeedToFindRoot(psiImportHolder) && !processor2.process((Object)importHolder)) {
                        return false;
                    }
                    upperImporters.add(importHolder);
                }
            }
            importers = upperImporters;
        }
        return true;
    }

    @NotNull
    public static Collection<VirtualFile> findAllRootsThatIncludes(@NotNull Project project, @NotNull VirtualFile original, boolean strict) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "findAllRootsThatIncludes"));
        }
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "findAllRootsThatIncludes"));
        }
        if (!OCInclusionContextUtil.isNeedToFindRoot(original, project)) {
            List<VirtualFile> list = Collections.singletonList(original);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "findAllRootsThatIncludes"));
            }
            return list;
        }
        PsiFile originalFile = PsiManager.getInstance((Project)project).findFile(original);
        if (!(originalFile instanceof OCFile)) {
            List<VirtualFile> list = Collections.singletonList(original);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "findAllRootsThatIncludes"));
            }
            return list;
        }
        final THashSet result2 = new THashSet();
        OCImportGraph.processPossibleRootsThatInclude(project, original, new Processor<VirtualFile>(){

            public boolean process(VirtualFile virtualFile) {
                result2.add((Object)virtualFile);
                return true;
            }
        }, strict);
        ArrayList<VirtualFile> arrayList = result2.isEmpty() ? Collections.singletonList(original) : new ArrayList<VirtualFile>((Collection<VirtualFile>)result2);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "findAllRootsThatIncludes"));
        }
        return arrayList;
    }

    public static void addHeaderIncluder(@NotNull Project project, @NotNull VirtualFile header, @NotNull VirtualFile includer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "addHeaderIncluder"));
        }
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "addHeaderIncluder"));
        }
        if (includer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includer", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "addHeaderIncluder"));
        }
        ((Cache)IMPORTS_GRAPH.getValue((UserDataHolder)project)).add(header, includer);
    }

    public static void removeHeaderIncluder(@NotNull Project project, @NotNull VirtualFile header, @NotNull VirtualFile includer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "removeHeaderIncluder"));
        }
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "removeHeaderIncluder"));
        }
        if (includer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includer", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph", "removeHeaderIncluder"));
        }
        ((Cache)IMPORTS_GRAPH.getValue((UserDataHolder)project)).remove(header, includer);
    }

    private static class Cache {
        @NotNull
        private final Project myProject;
        @NotNull
        private final AtomicInteger isEnsuringFilesProcessed;
        @NotNull
        private final Object myLock;
        MultiMap<VirtualFile, VirtualFile> myHeaderToIncluders;
        MultiMap<VirtualFile, VirtualFile> myAddOnlyHeaderToIncluders;

        private Cache(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph$Cache", "<init>"));
            }
            this.isEnsuringFilesProcessed = new AtomicInteger();
            this.myLock = new Object();
            this.myHeaderToIncluders = MultiMap.createConcurrentSet();
            this.myAddOnlyHeaderToIncluders = MultiMap.createConcurrentSet();
            this.myProject = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        public Collection<VirtualFile> get(@NotNull VirtualFile header, boolean strict) {
            Collection<VirtualFile> rs;
            if (header == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph$Cache", "get"));
            }
            if (strict) {
                Application app = ApplicationManager.getApplication();
                app.assertReadAccessAllowed();
                boolean sync = !app.isDispatchThread() || app.isUnitTestMode();
                this.ensureFilesProcessed(sync);
            }
            Object object = this.myLock;
            // MONITORENTER : object
            if (!strict && (rs = this.getInner(header, true)) != null) {
                Collection<VirtualFile> collection = rs;
                // MONITOREXIT : object
                if (collection != null) return collection;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph$Cache", "get"));
            }
            Collection<VirtualFile> collection = this.getInner(header, false);
            // MONITOREXIT : object
            if (collection != null) return collection;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph$Cache", "get"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @Contract(value="_, false -> !null")
        private Collection<VirtualFile> getInner(@NotNull VirtualFile header, boolean fromAddOnlyCache) {
            if (header == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph$Cache", "getInner"));
            }
            Object object = this.myLock;
            synchronized (object) {
                MultiMap<VirtualFile, VirtualFile> h2is;
                MultiMap<VirtualFile, VirtualFile> multiMap = h2is = fromAddOnlyCache ? this.myAddOnlyHeaderToIncluders : this.myHeaderToIncluders;
                if (fromAddOnlyCache && !h2is.containsKey((Object)header)) {
                    return null;
                }
                Collection files = h2is.get((Object)header);
                boolean allValid = true;
                for (VirtualFile file2 : files) {
                    if (file2.isValid()) continue;
                    allValid = false;
                    break;
                }
                if (!allValid) {
                    ArrayList fs = new ArrayList(files);
                    for (VirtualFile file3 : fs) {
                        if (file3.isValid()) continue;
                        h2is.remove((Object)header, (Object)file3);
                    }
                    files = h2is.get((Object)header);
                    if (!fromAddOnlyCache) {
                        OCImportGraph.invalidateHeaderRootsCache(this.myProject);
                    }
                }
                return files;
            }
        }

        private void ensureFilesProcessed(boolean sync) {
            if (sync) {
                this.isEnsuringFilesProcessed.incrementAndGet();
                try {
                    this.ensurePendingFilesProcessed(null);
                    return;
                }
                finally {
                    this.isEnsuringFilesProcessed.decrementAndGet();
                }
            }
            if (this.isEnsuringFilesProcessed.incrementAndGet() > 1) {
                this.isEnsuringFilesProcessed.decrementAndGet();
                return;
            }
            ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ReadTask(){

                @Override
                public void computeInReadAction(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph$Cache$1", "computeInReadAction"));
                    }
                    try {
                        Cache.this.ensurePendingFilesProcessed(indicator);
                    }
                    finally {
                        Cache.this.isEnsuringFilesProcessed.decrementAndGet();
                    }
                }

                @Override
                public void onCanceled(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph$Cache$1", "onCanceled"));
                    }
                    Cache.this.ensureFilesProcessed(false);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensurePendingFilesProcessed(@Nullable ProgressIndicator indicator) {
            if (this.myProject.isDisposed() || !FileSymbolTablesCache.areSymbolsLoaded(this.myProject)) {
                return;
            }
            FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(this.myProject);
            cache.ensurePendingFilesProcessed(indicator, true);
            Object object = this.myLock;
            synchronized (object) {
                this.myAddOnlyHeaderToIncluders.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(@NotNull VirtualFile header, @NotNull VirtualFile includer) {
            if (header == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph$Cache", "add"));
            }
            if (includer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includer", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph$Cache", "add"));
            }
            Object object = this.myLock;
            synchronized (object) {
                this.myHeaderToIncluders.putValue((Object)header, (Object)includer);
                if (this.myAddOnlyHeaderToIncluders.containsKey((Object)header)) {
                    this.myAddOnlyHeaderToIncluders.putValue((Object)header, (Object)includer);
                }
                OCImportGraph.invalidateHeaderRootsCache(this.myProject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(@NotNull VirtualFile header, @NotNull VirtualFile includer) {
            if (header == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph$Cache", "remove"));
            }
            if (includer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includer", "com/jetbrains/cidr/lang/preprocessor/OCImportGraph$Cache", "remove"));
            }
            Object object = this.myLock;
            synchronized (object) {
                if (this.myHeaderToIncluders.remove((Object)header, (Object)includer)) {
                    if (!this.myAddOnlyHeaderToIncluders.containsKey((Object)header)) {
                        this.myAddOnlyHeaderToIncluders.putValues((Object)header, this.myHeaderToIncluders.get((Object)header));
                        this.myAddOnlyHeaderToIncluders.putValue((Object)header, (Object)includer);
                    }
                    OCImportGraph.invalidateHeaderRootsCache(this.myProject);
                }
            }
        }
    }
}

