/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.navigation.OCGotoAction;
import com.jetbrains.cidr.lang.navigation.OCGotoSuperHandler;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclarationList;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.search.OCClassInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCFunctionInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCStructInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLineMarkerProvider
implements LineMarkerProvider {
    private final DaemonCodeAnalyzerSettings myDaemonSettings;
    private final EditorColorsManager myColorsManager;

    public OCLineMarkerProvider(DaemonCodeAnalyzerSettings daemonSettings, EditorColorsManager colorsManager) {
        this.myDaemonSettings = daemonSettings;
        this.myColorsManager = colorsManager;
    }

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/navigation/OCLineMarkerProvider", "getLineMarkerInfo"));
        }
        if (OCElementUtil.isPartOfMacroSubstitution(element)) {
            return null;
        }
        LineMarkerInfo declDefMarker = this.getDeclDefMarker(element);
        OCLineMarkerInfo implementsMarker = OCLineMarkerProvider.getImplementsMarker(element);
        if (implementsMarker != null) {
            if (declDefMarker instanceof OCLineMarkerInfo) {
                return OCLineMarkerProvider.createMultiLineMarkerInfo(element, (OCLineMarkerInfo)declDefMarker, implementsMarker);
            }
            return implementsMarker;
        }
        return declDefMarker;
    }

    @Nullable
    private static PsiNameIdentifierOwner getElementFromNameIdentifier(PsiElement name) {
        if (OCElementUtil.getElementType(name) != OCTokenTypes.IDENTIFIER) {
            return null;
        }
        PsiElement parent = name.getParent();
        if (parent instanceof OCMethodSelectorPart ? !((parent = parent.getParent()) instanceof OCMethod) || ((OCMethod)parent).getParameters().get(0) != name.getParent() : parent instanceof OCReferenceElement && !((parent = parent.getParent()) instanceof OCStructLike)) {
            return null;
        }
        if (parent instanceof PsiNameIdentifierOwner && ((PsiNameIdentifierOwner)parent).getNameIdentifier() == name) {
            return (PsiNameIdentifierOwner)parent;
        }
        return null;
    }

    private static boolean isMemberLike(PsiElement element) {
        return element instanceof OCMethod && ((OCMethod)element).getBody() != null || element instanceof OCClassDeclaration || element instanceof OCDeclaration || element instanceof OCProperty || element instanceof OCSynthesizePropertiesList || element instanceof OCClassPredeclarationList || element instanceof OCInstanceVariablesList && !((OCInstanceVariablesList)element).getDeclarations().isEmpty();
    }

    protected static int getCategory(PsiElement element) {
        if (element instanceof OCProperty || element instanceof OCSynthesizePropertiesList || element instanceof OCClassPredeclarationList) {
            return 1;
        }
        if (element instanceof OCClassDeclaration || element instanceof OCInstanceVariablesList) {
            return 2;
        }
        if (element instanceof OCCppNamespace) {
            return 2;
        }
        if (element instanceof OCCppUsingStatement) {
            return 1;
        }
        if (element instanceof OCMethod || element instanceof OCFunctionDeclaration) {
            if (((OCCallable)element).getBody() == null) {
                return 1;
            }
            String text = element.getText();
            if (text.indexOf(10) < 0 && text.indexOf(13) < 0) {
                return 1;
            }
            return 2;
        }
        if (element instanceof OCDeclaration) {
            OCTypeElement type = ((OCDeclaration)element).getTypeElement();
            OCStructLike struct = (OCStructLike)PsiTreeUtil.findChildOfType((PsiElement)type, OCStructLike.class);
            if (struct != null && struct.isDeclaration()) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/cidr/lang/navigation/OCLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/navigation/OCLineMarkerProvider", "collectSlowLineMarkers"));
        }
        MultiMap myInheritanceCache = new MultiMap();
        for (PsiElement name : elements) {
            PsiNameIdentifierOwner element = OCLineMarkerProvider.getElementFromNameIdentifier(name);
            if (element == null || OCElementUtil.isPartOfMacroSubstitution((PsiElement)element)) continue;
            OCLineMarkerProvider.collectInheritingElements(element, result2, (MultiMap<OCQualifiedName, OCQualifiedName>)myInheritanceCache);
        }
    }

    @Nullable
    private LineMarkerInfo getDeclDefMarker(PsiElement element) {
        if (this.myDaemonSettings != null && element != null && this.myDaemonSettings.SHOW_METHOD_SEPARATORS && element.getFirstChild() == null) {
            PsiElement element1 = element;
            boolean isMember = false;
            while (element1 != null && !(element1 instanceof PsiFile) && element1.getPrevSibling() == null) {
                if (!OCLineMarkerProvider.isMemberLike(element1 = element1.getParent())) continue;
                isMember = true;
                break;
            }
            if (isMember) {
                boolean drawSeparator = false;
                int n = OCLineMarkerProvider.getCategory(element1);
                for (PsiElement child = element1.getPrevSibling(); child != null; child = child.getPrevSibling()) {
                    int category1 = OCLineMarkerProvider.getCategory(child);
                    if (category1 == 0) continue;
                    drawSeparator = n != 1 || category1 != 1;
                    break;
                }
                if (drawSeparator) {
                    LineMarkerInfo info = new LineMarkerInfo(element, element.getTextRange(), null, 4, (Function)FunctionUtil.nullConstant(), null, GutterIconRenderer.Alignment.RIGHT);
                    EditorColorsScheme scheme = this.myColorsManager.getGlobalScheme();
                    info.separatorColor = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
                    info.separatorPlacement = SeparatorPlacement.TOP;
                    return info;
                }
            }
        }
        List<OCSymbolDeclarator<OCClassSymbol>> kids = null;
        if (element instanceof OCClassPredeclarationList) {
            kids = ((OCClassPredeclarationList)element).getPredeclarations();
        } else if (element instanceof OCDeclaration) {
            kids = ((OCDeclaration)element).getDeclarators();
        } else if (element instanceof OCSynthesizePropertiesList) {
            kids = ((OCSynthesizePropertiesList)element).getProperties();
        }
        if (kids != null) {
            LinkedList<OCLineMarkerInfo> markers = new LinkedList<OCLineMarkerInfo>();
            for (PsiElement psiElement : kids) {
                OCGotoAction action = OCLineMarkerProvider.getAction(psiElement);
                if (action == null) continue;
                markers.add(new OCLineMarkerInfo(action, psiElement, 4));
            }
            return OCLineMarkerProvider.createMultiLineMarkerInfo(element, markers.toArray(new OCLineMarkerInfo[markers.size()]));
        }
        if ((element = OCLineMarkerProvider.getElementFromNameIdentifier(element)) instanceof OCClassPredeclaration || element instanceof OCSynthesizeProperty || element instanceof OCDeclarator || element instanceof OCMethodSelectorPart || element instanceof OCReferenceElement && element.getParent() instanceof OCSynthesizeProperty) {
            return null;
        }
        OCGotoAction action = OCLineMarkerProvider.getAction(element);
        if (action != null) {
            return new OCLineMarkerInfo(action, element, 4);
        }
        return null;
    }

    @Nullable
    private static OCLineMarkerInfo getImplementsMarker(PsiElement element) {
        List<PsiNameIdentifierOwner> kids = null;
        if (element instanceof OCClassPredeclarationList) {
            kids = ((OCClassPredeclarationList)element).getPredeclarations();
        } else if (element instanceof OCDeclaration) {
            kids = ((OCDeclaration)element).getDeclarators();
        }
        if (kids != null) {
            LinkedList<OCLineMarkerInfo> markers = new LinkedList<OCLineMarkerInfo>();
            for (PsiElement psiElement : kids) {
                OCGotoAction action = OCGotoSuperHandler.getAction(psiElement);
                if (action == null) continue;
                markers.add(new OCLineMarkerInfo(action, psiElement, 4));
            }
            return OCLineMarkerProvider.createMultiLineMarkerInfo(element, markers.toArray(new OCLineMarkerInfo[markers.size()]));
        }
        if ((element = OCLineMarkerProvider.getElementFromNameIdentifier(element)) instanceof OCClassPredeclaration || element instanceof OCDeclarator) {
            return null;
        }
        OCGotoAction action = OCGotoSuperHandler.getAction(element);
        if (action != null) {
            return new OCLineMarkerInfo(action, element, 4);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void collectInheritingElements(PsiNameIdentifierOwner element, Collection<LineMarkerInfo> result2, MultiMap<OCQualifiedName, OCQualifiedName> inheritanceCache) {
        void var3_9;
        String actionName;
        if (element instanceof OCClassDeclaration) {
            if (element instanceof OCClassPredeclaration || ((OCClassDeclaration)element).getCategory() != null || "NSObject".equals(element.getName())) {
                return;
            }
            Query<OCClassSymbol> query = OCClassInheritorsSearch.search((OCClassDeclaration)element);
            actionName = "Go to subclass";
        } else if (element instanceof OCMethod) {
            OCMethod method = (OCMethod)element;
            OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> searchParameters = OCMemberInheritorsSearch.getParameters(method);
            if (method.getContainingClass() instanceof OCImplementation) {
                searchParameters.setImplementationsThenInterfaces(true);
            } else {
                searchParameters.setInterfacesThenImplementations(true);
            }
            Query<OCMethodSymbol> query = OCMemberInheritorsSearch.search(searchParameters);
            actionName = "Go to overridden methods";
        } else if (element instanceof OCStruct) {
            if (!((OCStruct)element).isDeclaration()) return;
            Query<OCStructSymbol> query = OCStructInheritorsSearch.search((OCStruct)element);
            actionName = "Go to subclass";
        } else {
            if (!(element instanceof OCDeclarator)) return;
            OCSymbol symbol = ((OCDeclarator)element).getSymbol();
            if (symbol instanceof OCMemberSymbol) {
                OCMemberInheritorsSearch.SearchParameters<OCMemberSymbol> searchParameters = OCMemberInheritorsSearch.getParameters((OCMemberSymbol)symbol);
                Query<OCMemberSymbol> query = OCMemberInheritorsSearch.search(searchParameters);
                actionName = "Go to overridden " + StringUtil.pluralize((String)symbol.getKind().getNameLowercase());
            } else {
                if (((OCDeclarator)element).getParameterList() == null || !((OCDeclarator)element).isPossibleStructMember() || !(symbol instanceof OCFunctionSymbol)) return;
                OCFunctionInheritorsSearch.SearchParameters searchParameters = OCFunctionInheritorsSearch.getParameters((OCFunctionSymbol)symbol, ((OCDeclarator)element).getContainingOCFile(), true);
                if (symbol.isPredeclaration()) {
                    searchParameters.setPredeclarationsThenImplementations(true);
                } else {
                    searchParameters.setImplementationsThenPredeclarations(true);
                }
                Query<OCFunctionSymbol> query = OCFunctionInheritorsSearch.search(searchParameters, inheritanceCache);
                actionName = "Go to overridden functions";
            }
        }
        OCSymbol inheritor = (OCSymbol)var3_9.findFirst();
        void var6_17 = var3_9;
        String actionNameFinal = actionName;
        if (inheritor == null) return;
        PsiElement name = element.getNameIdentifier();
        assert (name != null);
        OCGotoAction action = new OCGotoAction((PsiElement)element, actionNameFinal, element instanceof OCProtocol ? AllIcons.Gutter.ImplementedMethod : AllIcons.Gutter.OverridenMethod, (Query)var6_17){
            final /* synthetic */ Query val$queryFinal;
            {
                this.val$queryFinal = query;
                super(source, name, icon);
            }

            protected ArrayList<OCSymbol> evaluateTargets() {
                return new ArrayList<OCSymbol>(this.val$queryFinal.findAll());
            }
        };
        result2.add(new OCLineMarkerInfo(action, name, 6));
    }

    private static boolean isMarkAppropriate(OCStruct struct) {
        boolean markerNeeded = false;
        if (struct.isDeclaration()) {
            markerNeeded = false;
        } else {
            PsiElement declaration = struct.getParent().getParent();
            if (declaration instanceof OCDeclaration && ((OCDeclaration)declaration).getDeclarators().size() == 0) {
                PsiElement context = declaration.getParent();
                markerNeeded = context instanceof OCFile || context instanceof OCStructLike || context instanceof OCCppNamespace || context instanceof OCClassDeclaration;
            }
        }
        return markerNeeded;
    }

    @Nullable
    public static OCGotoAction getAction(final PsiElement element) {
        if (!(element instanceof OCSymbolDeclarator)) {
            return null;
        }
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        if (symbol == null || symbol.getKind() == OCSymbolKind.PARAMETER) {
            return null;
        }
        if (OCSymbolImpl.locateDefinition(OCLineMarkerProvider.getRelatedSymbol(symbol)) != null) {
            if (element instanceof OCStruct && !OCLineMarkerProvider.isMarkAppropriate((OCStruct)element)) {
                return null;
            }
            return new OCGotoAction(element, "Go to definition/declaration", OCIcons.AssocFile){

                protected ArrayList<OCSymbol> evaluateTargets() {
                    Object symbol = ((OCSymbolDeclarator)element).getSymbol();
                    OCSymbol relatedSymbol = OCLineMarkerProvider.getRelatedSymbol(symbol);
                    this.myName = "Go to ";
                    if (symbol != null && relatedSymbol != null) {
                        this.myName = relatedSymbol.getKind().isClass() ? this.myName + relatedSymbol.getKind().getNameLowercase() + " of '" + relatedSymbol.getName() + "'" : (relatedSymbol instanceof OCStructSymbol && relatedSymbol.isPredeclaration() ? this.myName + "predefinition of " + relatedSymbol.getNameWithKindLowercase() : (relatedSymbol.getKind() == symbol.getKind() ? this.myName + (relatedSymbol.isDefinition() ? "definition" : "declaration") + " of " + relatedSymbol.getNameWithKindLowercase() : this.myName + " related " + (Object)((Object)relatedSymbol.getKind())));
                    }
                    return new ArrayList<OCSymbol>(Collections.singleton(relatedSymbol));
                }
            };
        }
        return null;
    }

    @Nullable
    public static OCSymbol getRelatedSymbol(OCSymbol symbol) {
        OCSymbol relatedSymbol;
        OCSymbol oCSymbol = relatedSymbol = symbol != null ? symbol.getAssociatedSymbol() : null;
        if (relatedSymbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)relatedSymbol).getGeneratedFromProperty() != null) {
            return ((OCInstanceVariableSymbol)relatedSymbol).getAssociatedProperty();
        }
        if (relatedSymbol == null && symbol instanceof OCPropertySymbol) {
            OCInstanceVariableSymbol ivar = ((OCPropertySymbol)symbol).getAssociatedIvar();
            if (ivar != null && !ivar.isClang4ImplicitIvar()) {
                return ivar;
            }
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            ((OCPropertySymbol)symbol).processAccessorMethods((Processor<? super OCMethodSymbol>)finder, false);
            return (OCSymbol)finder.getFoundValue();
        }
        return relatedSymbol;
    }

    @Nullable
    private static OCLineMarkerInfo createMultiLineMarkerInfo(PsiElement element, final OCLineMarkerInfo ... markers) {
        Icon icon = null;
        if (markers.length == 0) {
            return null;
        }
        if (markers.length == 1) {
            return markers[0];
        }
        for (OCLineMarkerInfo marker : markers) {
            icon = icon == null ? marker.getAction().getIcon() : OCIcons.GutterMultiArrows;
        }
        return new OCLineMarkerInfo(new OCGotoAction(element, "Go to...", icon){

            protected ArrayList<OCSymbol> evaluateTargets() {
                ArrayList<OCSymbol> allTargets = new ArrayList<OCSymbol>();
                this.mySpecialIcons = new ArrayList();
                this.myTooltips = new ArrayList();
                for (OCLineMarkerInfo marker : markers) {
                    List<? extends OCSymbol> curTargets = marker.getAction().getTargets();
                    if (curTargets == null) continue;
                    allTargets.addAll(curTargets);
                    for (int i = 0; i < curTargets.size(); ++i) {
                        this.mySpecialIcons.add(marker.getAction().getIcon(i));
                        this.myTooltips.add(marker.getAction().getTooltip(i));
                    }
                }
                return allTargets;
            }
        }, element, 4);
    }

    private static class OCLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private OCGotoAction myAction;

        private OCLineMarkerInfo(final @NotNull OCGotoAction action, @NotNull PsiElement element, int updatePass) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/jetbrains/cidr/lang/navigation/OCLineMarkerProvider$OCLineMarkerInfo", "<init>"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/navigation/OCLineMarkerProvider$OCLineMarkerInfo", "<init>"));
            }
            super(element, OCElementUtil.getTextRangeWithoutComments(element), action.getIcon(), updatePass, (Function)new Function<PsiElement, String>(){

                public String fun(PsiElement psiElement) {
                    return action.getName();
                }
            }, (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>(){

                public void navigate(MouseEvent e, PsiElement elt) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.class.hierarchy");
                    action.navigate(new RelativePoint(e), null);
                }
            }, GutterIconRenderer.Alignment.RIGHT);
            this.myAction = action;
        }

        public OCGotoAction getAction() {
            return this.myAction;
        }
    }
}

