/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCGotoAction {
    private PsiElement mySource;
    protected String myName;
    protected Icon myIcon;
    protected List<? extends OCSymbol> myTargets;
    private long myModificationCounter;
    protected List<Icon> mySpecialIcons;
    protected List<String> myTooltips;

    public OCGotoAction(@NotNull PsiElement source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/cidr/lang/navigation/OCGotoAction", "<init>"));
        }
        this.mySource = source;
        this.getTargets();
    }

    public OCGotoAction(@NotNull PsiElement source, @Nullable String name, @Nullable Icon icon) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/cidr/lang/navigation/OCGotoAction", "<init>"));
        }
        this(source, name, icon, null, null);
    }

    public OCGotoAction(@NotNull PsiElement source, @Nullable String name, @Nullable Icon icon, @Nullable List<Icon> specialIcons, @Nullable List<String> tooltips) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/cidr/lang/navigation/OCGotoAction", "<init>"));
        }
        this.mySource = source;
        this.myName = name;
        this.myIcon = icon;
        this.mySpecialIcons = specialIcons;
        this.myTooltips = tooltips;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public Icon getIcon(int index) {
        Icon result2 = this.mySpecialIcons != null ? this.mySpecialIcons.get(index) : null;
        return result2 != null ? result2 : this.getIcon();
    }

    public String getTooltip(int index) {
        String result2 = this.myTooltips != null ? this.myTooltips.get(index) : null;
        return result2 != null ? result2 : this.getName();
    }

    public String getName() {
        return this.myName;
    }

    @Nullable
    public List<? extends OCSymbol> getTargets() {
        long curModificationCounter = this.mySource.getManager().getModificationTracker().getOutOfCodeBlockModificationCount();
        if (this.myTargets == null || curModificationCounter != this.myModificationCounter) {
            this.myModificationCounter = curModificationCounter;
            this.myTargets = this.evaluateTargets();
        }
        return this.myTargets;
    }

    @Nullable
    protected abstract List<? extends OCSymbol> evaluateTargets();

    public void navigate(@Nullable RelativePoint point, Editor editor) {
        List<? extends OCSymbol> targets = this.getTargets();
        if (targets == null) {
            return;
        }
        if (targets.size() == 1) {
            OCSymbol target = targets.iterator().next();
            if (target != null) {
                target.navigate(true);
            }
        } else {
            List<PsiElement> targetElements = OCSymbolImpl.locateDefinitions(targets);
            PsiElement[] targetElementsArray = PsiUtilCore.toPsiElementArray(targetElements);
            final GotoTargetHandler.GotoData gotoData = new GotoTargetHandler.GotoData(this.mySource, targetElementsArray, Collections.<GotoTargetHandler.AdditionalAction>emptyList());
            JBPopup popup = NavigationUtil.getPsiElementPopup(targetElementsArray, new DefaultPsiElementCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    if (value == null) {
                        return super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
                    }
                    PsiElementListCellRenderer renderer = GotoTargetHandler.createRenderer(gotoData, (PsiElement)value);
                    return renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                }
            }, this.myName);
            if (point != null) {
                popup.show(point);
            } else {
                popup.showInBestPositionFor(editor);
            }
        }
    }
}

