/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;

public class OCFilterLexer
extends BaseFilterLexer {
    private static final TokenSet SKIP_WORDS_SCAN_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.LPAR, OCTokenTypes.RPAR, OCTokenTypes.LBRACE, OCTokenTypes.RBRACE, OCTokenTypes.LBRACKET, OCTokenTypes.RBRACKET, OCTokenTypes.SEMICOLON, OCTokenTypes.COMMA, OCTokenTypes.DOT, OCTokenTypes.ELLIPSIS, OCTokenTypes.AT}), OCTokenTypes.WHITESPACES});

    public OCFilterLexer(Lexer originalLexer, OccurrenceConsumer occurrenceConsumer) {
        super(originalLexer, occurrenceConsumer);
    }

    public void advance() {
        IElementType tokenType = this.myDelegate.getTokenType();
        if (tokenType == OCTokenTypes.STRING_LITERAL || tokenType == OCTokenTypes.RAW_STRING_LITERAL || tokenType == OCTokenTypes.WRONG_RAW_STRING_LITERAL) {
            this.scanWordsInToken(12, false, tokenType == OCTokenTypes.STRING_LITERAL);
        } else if (tokenType == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(tokenType) || OCTokenTypes.LITERALS.contains(tokenType)) {
            this.addOccurrenceInToken(1);
        } else if (OCTokenTypes.COMMENTS.contains(tokenType)) {
            this.scanWordsInToken(2, false, false);
            this.advanceTodoItemCountsInToken();
        } else if (!SKIP_WORDS_SCAN_SET.contains(tokenType)) {
            this.scanWordsInToken(16, false, false);
        }
        this.getDelegate().advance();
    }
}

