/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCWrapStringIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCWrapStringIntentionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/intentions/OCWrapStringIntentionAction", "isAvailable"));
        }
        OCLiteralExpression literal = OCWrapStringIntentionAction.getStringLiteral(editor, element.getContainingFile());
        return OCCodeInsightUtil.isValid(literal) && OCElementUtil.getStringLiteral(literal) != null;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCWrapStringIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        if ("Wrap with stringWithFormat" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCWrapStringIntentionAction", "getText"));
        }
        return "Wrap with stringWithFormat";
    }

    @Nullable
    private static OCLiteralExpression getStringLiteral(Editor editor, PsiFile file2) {
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        return OCElementUtil.getAdjacentParentOfType(element, OCLiteralExpression.class);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCWrapStringIntentionAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/intentions/OCWrapStringIntentionAction", "invoke"));
        }
        PsiFile file2 = element.getContainingFile();
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        OCLiteralExpression literal = OCWrapStringIntentionAction.getStringLiteral(editor, file2);
        if (literal == null) {
            return;
        }
        OCSendMessageExpression call = (OCSendMessageExpression)OCElementFactory.expressionFromText("[NSString stringWithFormat: 0]", (PsiElement)file2);
        call.getArguments().get(0).getArgumentExpression().replace(literal);
        call = (OCSendMessageExpression)literal.replace(call);
        if (editor != null) {
            editor.getCaretModel().moveToOffset(call.getTextRange().getEndOffset());
        }
    }
}

