/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class OCSwitchPropertyDotMethodIntentionAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        if ("Switch '.' and method notation" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCSwitchPropertyDotMethodIntentionAction", "getFamilyName"));
        }
        return "Switch '.' and method notation";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCSwitchPropertyDotMethodIntentionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/intentions/OCSwitchPropertyDotMethodIntentionAction", "isAvailable"));
        }
        OCExpression expression = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCSendMessageExpression.class, OCQualifiedExpression.class});
        if (expression instanceof OCQualifiedExpression) {
            ReadWriteAccessDetector.Access access = new OCReadWriteAccessDetector().getExpressionAccess(expression);
            if (access == ReadWriteAccessDetector.Access.Read) {
                this.setText("Switch to getter method notation");
            } else if (access == ReadWriteAccessDetector.Access.Write) {
                this.setText("Switch to setter method notation");
            } else {
                return false;
            }
            OCSymbol symbol = ((OCQualifiedExpression)expression).resolveToSymbol();
            return symbol instanceof OCPropertySymbol || symbol instanceof OCMethodSymbol;
        }
        if (expression instanceof OCSendMessageExpression) {
            this.setText("Switch to '.' notation");
            OCMethodSymbol responder = ((OCSendMessageExpression)expression).getProbableResponders().getKnownResponder();
            return responder != null && (responder.getGeneratedFromProperty() != null || responder.isGetter() || responder.isSetter() && OCNameSuggester.getObjCGetterFromSetter(responder.getName()) != null);
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCSwitchPropertyDotMethodIntentionAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/intentions/OCSwitchPropertyDotMethodIntentionAction", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        OCExpression expression = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCSendMessageExpression.class, OCQualifiedExpression.class});
        if (expression instanceof OCQualifiedExpression) {
            ReadWriteAccessDetector.Access access = new OCReadWriteAccessDetector().getExpressionAccess(expression);
            OCSymbol symbol = ((OCQualifiedExpression)expression).resolveToSymbol();
            if (access == ReadWriteAccessDetector.Access.Read) {
                String getterName;
                if (symbol instanceof OCPropertySymbol) {
                    getterName = ((OCPropertySymbol)symbol).getGetterName();
                } else if (symbol instanceof OCMethodSymbol) {
                    getterName = symbol.getName();
                } else {
                    return;
                }
                OCSendMessageExpression getter = (OCSendMessageExpression)OCElementFactory.expressionFromText("[x " + getterName + "]", element, true);
                OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(getter.getReceiverExpression(), ((OCQualifiedExpression)expression).getQualifier());
                OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(expression, getter);
            } else if (access == ReadWriteAccessDetector.Access.Write) {
                String setterName;
                PsiElement parent = OCParenthesesUtils.topmostParenthesized(expression).getParent();
                if (symbol instanceof OCPropertySymbol) {
                    setterName = ((OCPropertySymbol)symbol).getSetterName();
                } else if (symbol instanceof OCMethodSymbol) {
                    setterName = symbol.getName();
                } else {
                    return;
                }
                if (parent instanceof OCAssignmentExpression) {
                    OCSendMessageExpression setter = (OCSendMessageExpression)OCElementFactory.expressionFromText("[x " + setterName + "x]", element, true);
                    OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(setter.getReceiverExpression(), ((OCQualifiedExpression)expression).getQualifier());
                    OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(setter.getArgumentExpressions().get(0), ((OCAssignmentExpression)parent).getSourceExpression());
                    OCChangeUtil.replaceHandlingMacros(parent, setter);
                }
            }
        } else if (expression instanceof OCSendMessageExpression) {
            String propertyName;
            OCMethodSymbol responder = ((OCSendMessageExpression)expression).getProbableResponders().getKnownResponder();
            OCPropertySymbol property = responder != null ? responder.getGeneratedFromProperty() : null;
            String string = propertyName = property != null ? property.getName() : null;
            if (responder != null && responder.isGetter()) {
                if (propertyName == null) {
                    propertyName = responder.getName();
                }
                OCQualifiedExpression accessor = (OCQualifiedExpression)OCElementFactory.expressionFromText("x." + propertyName, element, true);
                OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(accessor.getQualifier(), ((OCSendMessageExpression)expression).getReceiverExpression());
                OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(expression, accessor);
            } else if (responder != null && responder.isSetter()) {
                if (propertyName == null) {
                    propertyName = OCNameSuggester.getObjCGetterFromSetter(responder.getName());
                }
                OCAssignmentExpression assignment = (OCAssignmentExpression)OCElementFactory.expressionFromText("x." + propertyName + "=x", element, true);
                OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(assignment.getSourceExpression(), ((OCSendMessageExpression)expression).getArgumentExpressions().get(0));
                OCQualifiedExpression accessor = (OCQualifiedExpression)assignment.getReceiverExpression();
                OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(accessor.getQualifier(), ((OCSendMessageExpression)expression).getReceiverExpression());
                OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(expression, assignment);
            }
        }
    }
}

