/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSplitIntoSeparateDeclarationsIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Split into separate declarations" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCSplitIntoSeparateDeclarationsIntentionAction", "getText"));
        }
        return "Split into separate declarations";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCSplitIntoSeparateDeclarationsIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        boolean isInBlock;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCSplitIntoSeparateDeclarationsIntentionAction", "isAvailable"));
        }
        PsiElement element = OCSplitIntoSeparateDeclarationsIntentionAction.getElement(editor, file2);
        if (!OCCodeInsightUtil.isValid(element)) {
            return false;
        }
        boolean bl = isInBlock = PsiTreeUtil.getParentOfType((PsiElement)element, OCBlockStatement.class) != null;
        if (element instanceof OCDeclaration) {
            return (!isInBlock || element.getParent().getParent() instanceof OCBlockStatement) && ((OCDeclaration)element).getDeclarators().size() > 1;
        }
        if (element instanceof OCDeclarator) {
            return (!isInBlock || element.getParent().getParent().getParent() instanceof OCBlockStatement) && ((OCDeclaration)element.getParent()).getDeclarators().size() > 1;
        }
        if (element instanceof OCSynthesizeProperty) {
            return ((OCSynthesizePropertiesList)element.getParent()).getProperties().size() > 1;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCSplitIntoSeparateDeclarationsIntentionAction", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement element = OCSplitIntoSeparateDeclarationsIntentionAction.getElement(editor, file2);
        if (element instanceof OCDeclaration) {
            OCNormalizeUtil.normalizeDeclaration((OCDeclaration)element);
        } else if (element instanceof OCDeclarator) {
            OCNormalizeUtil.normalizeDeclarator((OCDeclarator)element);
        } else if (element instanceof OCSynthesizeProperty) {
            OCNormalizeUtil.normalizeSynthesizeStatement((OCSynthesizeProperty)element);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    private static PsiElement getElement(Editor editor, PsiFile file2) {
        OCTypeElement typeElement;
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        OCSymbolDeclarator declarator = (OCSymbolDeclarator)OCElementUtil.getAdjacentParentOfType(element, OCDeclarator.class, OCSynthesizeProperty.class);
        if (declarator == null && (typeElement = OCElementUtil.getAdjacentParentOfType(element, OCTypeElement.class)) != null && typeElement.getParent() instanceof OCDeclaration) {
            return typeElement.getParent();
        }
        return declarator;
    }
}

