/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class OCMergeElseIfIntention
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCMergeElseIfIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/intentions/OCMergeElseIfIntention", "isAvailable"));
        }
        OCStatement statement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCStatement.class);
        if (statement == null) {
            return false;
        }
        if (this.checkStatement(statement)) {
            return OCMergeElseIfIntention.checkCursorAtElseKeyword(editor, (OCIfStatement)statement);
        }
        OCStatement parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, OCStatement.class);
        if (parentStatement instanceof OCBlockStatement) {
            while (parentStatement instanceof OCBlockStatement) {
                parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)parentStatement, OCStatement.class);
            }
            return this.checkStatement(parentStatement) && OCMergeElseIfIntention.checkCursorInAppropriatePosition(editor, statement);
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        if ("Merge If Else" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCMergeElseIfIntention", "getFamilyName"));
        }
        return "Merge If Else";
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCMergeElseIfIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/intentions/OCMergeElseIfIntention", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        OCStatement parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCStatement.class);
        if (parentStatement == null) {
            return;
        }
        if (!this.checkStatement(parentStatement)) {
            parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)parentStatement, OCIfStatement.class);
        }
        if (parentStatement == null) {
            return;
        }
        OCIfStatement parentIfStatement = (OCIfStatement)parentStatement;
        OCStatement childStatement = OCParenthesesUtils.stripBraces(parentIfStatement.getElseBranch());
        if (!(childStatement instanceof OCIfStatement)) {
            return;
        }
        parentIfStatement.getElseBranch().replace(childStatement);
    }

    public static boolean checkCursorInAppropriatePosition(@NotNull Editor editor, OCStatement statement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/intentions/OCMergeElseIfIntention", "checkCursorInAppropriatePosition"));
        }
        if (statement instanceof OCIfStatement) {
            OCIfStatement ifStatement = (OCIfStatement)statement;
            ASTNode rParenth = ifStatement.getRParenth();
            ASTNode elseKeyword = ifStatement.getElseKeyword();
            int offset = editor.getCaretModel().getOffset();
            return rParenth != null && offset <= rParenth.getStartOffset() || elseKeyword != null && offset >= elseKeyword.getStartOffset() && offset <= elseKeyword.getStartOffset() + elseKeyword.getTextLength();
        }
        return false;
    }

    public static boolean checkCursorAtElseKeyword(@NotNull Editor editor, OCIfStatement statement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/intentions/OCMergeElseIfIntention", "checkCursorAtElseKeyword"));
        }
        ASTNode elseKeyword = statement.getElseKeyword();
        int offset = editor.getCaretModel().getOffset();
        return elseKeyword != null && offset >= elseKeyword.getStartOffset() && offset <= elseKeyword.getStartOffset() + elseKeyword.getTextLength();
    }

    private boolean checkStatement(OCStatement statement) {
        if (statement instanceof OCIfStatement) {
            this.setText(this.getFamilyName());
            OCIfStatement ifStatement = (OCIfStatement)statement;
            OCStatement elseBranch = ifStatement.getElseBranch();
            elseBranch = OCParenthesesUtils.stripBraces(elseBranch);
            return elseBranch != null && elseBranch instanceof OCIfStatement;
        }
        return false;
    }
}

