/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCImplementCppFunctionInplaceIntentionAction
extends OCSymbolQuickFix<OCFunctionSymbol> {
    public OCImplementCppFunctionInplaceIntentionAction(OCFunctionSymbol symbol) {
        super(symbol);
    }

    @Override
    protected boolean isAvailable(OCFunctionSymbol symbol) {
        return OCSearchScope.isInProjectSources(symbol) && symbol.isPredeclaration();
    }

    @Override
    protected String getTextInternal(OCFunctionSymbol symbol) {
        return "Implement " + symbol.getNameWithKindLowercase() + " inplace";
    }

    @NotNull
    public String getFamilyName() {
        if ("Implement function inline" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCImplementCppFunctionInplaceIntentionAction", "getFamilyName"));
        }
        return "Implement function inline";
    }

    @Override
    protected void invoke(OCFunctionSymbol symbol) {
        Object function = symbol.locateDefinition();
        Object object = function = function instanceof OCDeclarator ? function.getParent() : null;
        if (!(function instanceof OCFunctionDeclaration)) {
            return;
        }
        PsiElement lastChild = function.getLastChild();
        if (OCElementUtil.getElementType(lastChild) == OCTokenTypes.SEMICOLON) {
            OCFunctionSymbol ancestor = OCFunctionAncestorsQuery.findFirstVirtual(symbol, false);
            OCFunctionSymbol overridingFunction = ancestor != null && !ancestor.isPureVirtual() ? ancestor : null;
            int startOffset = function.getTextRange().getStartOffset();
            String signature = function.getContainingFile().getText().substring(startOffset, lastChild.getTextOffset());
            String functionText = OCCallableUtil.functionText(symbol, signature, function, overridingFunction);
            OCChangeUtil.changeText(function.getProject(), function.getContainingFile(), startOffset, function.getTextLength(), functionText, false);
        }
    }
}

