/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.refactoring.move.handlers.OCExtractSuperClassHandler;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCExtractSuperClassIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Extract super class" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCExtractSuperClassIntentionAction", "getText"));
        }
        return "Extract super class";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCExtractSuperClassIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCExtractSuperClassIntentionAction", "isAvailable"));
        }
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        if (OCNewFileActionBase.isNewFileActionSupported() && element != null && OCCodeInsightUtil.isValid((PsiElement)file2) && (OCElementUtil.getElementType(element) == OCTokenTypes.IDENTIFIER || OCElementUtil.getElementType(element.getPrevSibling()) == OCTokenTypes.IDENTIFIER)) {
            PsiElement parent = element.getParent();
            return parent instanceof OCInterface || parent instanceof OCImplementation;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCExtractSuperClassIntentionAction", "invoke"));
        }
        new OCExtractSuperClassHandler().invoke(project, editor, file2, SimpleDataContext.getProjectContext(project));
    }

    public boolean startInWriteAction() {
        return false;
    }
}

