/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.util.OCComparisonUtils;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDemorganIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCDemorganIntentionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/intentions/OCDemorganIntentionAction", "isAvailable"));
        }
        OCBinaryExpression expression = (OCBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCBinaryExpression.class);
        if (expression != null && expression.getRight() != null) {
            if (expression.getOperationSign() == OCTokenTypes.ANDAND) {
                this.setText("Replace '&&' with '||'");
                return true;
            }
            if (expression.getOperationSign() == OCTokenTypes.OROR) {
                this.setText("Replace '||' with '&&'");
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        if ("DeMorgan Law" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCDemorganIntentionAction", "getFamilyName"));
        }
        return "DeMorgan Law";
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCDemorganIntentionAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/intentions/OCDemorganIntentionAction", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        OCBinaryExpression expression = (OCBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCBinaryExpression.class);
        if (expression != null) {
            OCElementType sign = expression.getOperationSign();
            PsiElement parent = expression.getParent();
            while (OCDemorganIntentionAction.isConjunctionExpression(parent, sign)) {
                expression = (OCBinaryExpression)parent;
                parent = expression.getParent();
            }
            String newExpression = OCDemorganIntentionAction.convertConjunctionExpression(expression, sign);
            OCDemorganIntentionAction.replaceExpressionWithNegatedExpressionString(newExpression, expression);
        }
    }

    @Nullable
    private static String convertConjunctionExpression(OCBinaryExpression exp, OCElementType sign) {
        OCExpression left = exp.getLeft();
        String leftText = OCDemorganIntentionAction.isConjunctionExpression(left, sign) ? OCDemorganIntentionAction.convertConjunctionExpression((OCBinaryExpression)left, sign) : OCDemorganIntentionAction.convertLeafExpression(left);
        if (leftText == null) {
            return null;
        }
        OCExpression right = exp.getRight();
        String rightText = OCDemorganIntentionAction.isConjunctionExpression(right, sign) ? OCDemorganIntentionAction.convertConjunctionExpression((OCBinaryExpression)right, sign) : OCDemorganIntentionAction.convertLeafExpression(right);
        if (rightText == null) {
            return null;
        }
        String inversedOperator = OCComparisonUtils.getInversedOperator(sign);
        return leftText + inversedOperator + rightText;
    }

    @Nullable
    private static String convertLeafExpression(OCExpression condition) {
        if (OCDemorganIntentionAction.isNegation(condition)) {
            OCExpression negated = OCDemorganIntentionAction.stripNegation((OCUnaryExpression)condition);
            if (negated == null) {
                return "";
            }
            if (OCParenthesesUtils.getPrecedence(negated, false) > 14) {
                return '(' + negated.getText() + ')';
            }
            return negated.getText();
        }
        if (OCComparisonUtils.isComparison(condition)) {
            OCBinaryExpression binaryExpression = (OCBinaryExpression)condition;
            OCElementType sign = binaryExpression.getOperationSign();
            String negatedComparison = OCComparisonUtils.getNegatedComparison(sign);
            OCExpression left = binaryExpression.getLeft();
            OCExpression right = binaryExpression.getRight();
            if (left != null && right != null) {
                return left.getText() + negatedComparison + right.getText();
            }
            return null;
        }
        if (OCParenthesesUtils.getPrecedence(condition, false) > 3) {
            return "!(" + condition.getText() + ')';
        }
        return '!' + condition.getText();
    }

    private static boolean isConjunctionExpression(PsiElement exp, OCElementType sign) {
        if (exp instanceof OCBinaryExpression) {
            OCBinaryExpression binExp = (OCBinaryExpression)exp;
            OCElementType tokenType = binExp.getOperationSign();
            return ((Object)((Object)tokenType)).equals((Object)sign);
        }
        return false;
    }

    protected static void replaceExpressionWithNegatedExpressionString(@NotNull String newExpression, @NotNull OCExpression expression) throws IncorrectOperationException {
        String expString;
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/jetbrains/cidr/lang/intentions/OCDemorganIntentionAction", "replaceExpressionWithNegatedExpressionString"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/cidr/lang/intentions/OCDemorganIntentionAction", "replaceExpressionWithNegatedExpressionString"));
        }
        OCExpression expressionToReplace = expression;
        OCExpression negatedParent = OCDemorganIntentionAction.findFirstNegatedParent(expression);
        if (negatedParent != null) {
            expressionToReplace = negatedParent;
            expString = newExpression;
        } else {
            expString = "!(" + newExpression + ')';
        }
        expressionToReplace.replace(OCElementFactory.expressionFromText(expString, expression));
    }

    @Nullable
    public static OCExpression findFirstNegatedParent(OCExpression expression) {
        OCUnaryExpression prefixAncestor;
        OCExpression ancestor = expression;
        while (ancestor.getParent() instanceof OCParenthesizedExpression) {
            ancestor = (OCExpression)ancestor.getParent();
        }
        if (ancestor.getParent() instanceof OCUnaryExpression && OCTokenTypes.EXCL == (prefixAncestor = (OCUnaryExpression)ancestor.getParent()).getOperationSign()) {
            return prefixAncestor;
        }
        return null;
    }

    public static boolean isNegation(OCExpression expression) {
        if (expression instanceof OCUnaryExpression) {
            OCUnaryExpression unary = (OCUnaryExpression)expression;
            return unary.getOperationSign() == OCTokenTypes.EXCL;
        }
        return false;
    }

    @Nullable
    public static OCExpression stripNegation(OCUnaryExpression exp) {
        OCExpression operand = exp.getOperand();
        if (operand != null) {
            return OCParenthesesUtils.diveIntoParentheses(operand);
        }
        return null;
    }
}

