/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.generate.handlers.OCDeclareActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCDeclareMembersHandler;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.quickfixes.OCChangePropertyAttributeIntentionAction;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclarePropertyInPrivateCategoryIntentionAction
extends OCDeclareMembersHandler
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Declare property as 'readwrite' in private category" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCDeclarePropertyInPrivateCategoryIntentionAction", "getText"));
        }
        return "Declare property as 'readwrite' in private category";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCDeclarePropertyInPrivateCategoryIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCDeclarePropertyInPrivateCategoryIntentionAction", "isAvailable"));
        }
        OCPropertySymbol property = this.locateCandidate(project, editor, file2);
        return property != null && OCSearchScope.isInProjectSources(property) && !"".equals(((OCClassSymbol)property.getParent()).getCategoryName()) && property.getAssociatedPropertyInPrivateCategory() == null;
    }

    @Override
    @NotNull
    protected OCDeclareActionContext evaluateActionContext(OCClassSymbol parent, PsiElement element) {
        OCDeclareActionContext context = super.evaluateActionContext(parent, element);
        context.setTarget(OCDeclareActionContext.Target.PRIVATE_CATEGORY);
        OCDeclareActionContext oCDeclareActionContext = context;
        if (oCDeclareActionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCDeclarePropertyInPrivateCategoryIntentionAction", "evaluateActionContext"));
        }
        return oCDeclareActionContext;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCMemberSymbol> candidates) {
        return false;
    }

    @Override
    @Nullable
    protected OCPropertySymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCDeclarePropertyInPrivateCategoryIntentionAction", "locateCandidate"));
        }
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        OCDeclarator declarator = OCElementUtil.getAdjacentParentOfType(at, OCDeclarator.class);
        if (declarator == null) {
            return null;
        }
        OCSymbol symbol = declarator.getSymbol();
        return symbol instanceof OCPropertySymbol ? (OCPropertySymbol)symbol : null;
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCDeclarePropertyInPrivateCategoryIntentionAction", "getParent"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/intentions/OCDeclarePropertyInPrivateCategoryIntentionAction", "getParent"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/intentions/OCDeclarePropertyInPrivateCategoryIntentionAction", "getParent"));
        }
        OCPropertySymbol property = this.locateCandidate(project, editor, file2);
        return property != null ? (OCClassSymbol)property.getParent() : null;
    }

    @Override
    protected PsiElement moveDeclaration(PsiElement parent, PsiElement declaration) {
        OCProperty newProperty = (OCProperty)OCChangeUtil.add(parent, declaration);
        new OCChangePropertyAttributeIntentionAction(newProperty, OCPropertySymbol.PropertyAttribute.READONLY, OCPropertySymbol.PropertyAttribute.READWRITE).invoke(declaration.getProject(), null, newProperty.getContainingFile());
        new OCChangePropertyAttributeIntentionAction((OCProperty)declaration, OCPropertySymbol.PropertyAttribute.READWRITE, OCPropertySymbol.PropertyAttribute.READONLY).invoke(declaration.getProject(), null, declaration.getContainingFile());
        return newProperty;
    }
}

