/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateConstructorContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateConstructorHandler;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.quickfixes.OCAddFieldInitializerFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddParametersToConstructorIntentionAction
extends OCClassActionHandlerBase<OCStructSymbol, OCFunctionSymbol, OCCppActionContext<OCStructSymbol, OCFunctionSymbol>>
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Add as a parameter to constructor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCAddParametersToConstructorIntentionAction", "getText"));
        }
        return "Add as a parameter to constructor";
    }

    @Override
    protected String getActionTitle() {
        return "Add Parameter to Constructor";
    }

    @Override
    protected String getMembersChooserTitle() {
        return "Select Constructor to Update";
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCStruct.class;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCAddParametersToConstructorIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCAddParametersToConstructorIntentionAction", "isAvailable"));
        }
        return file2 instanceof OCFile && ((OCFile)file2).isCpp() && this.getField(editor, file2) != null;
    }

    @Nullable
    protected OCDeclaratorSymbol getField(Editor editor, PsiFile file2) {
        OCDeclaration declaration;
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        OCDeclarator declarator = OCElementUtil.getAdjacentParentOfType(element, OCDeclarator.class);
        if (declarator == null && (declaration = (OCDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCDeclaration.class})) != null && declaration.getDeclarators().size() > 0) {
            declarator = declaration.getDeclarators().get(0);
        }
        if (declarator == null) {
            return null;
        }
        OCSymbol symbol = declarator.getSymbol();
        if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.STRUCT_FIELD) {
            return (OCDeclaratorSymbol)symbol;
        }
        return null;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCFunctionSymbol> candidates) {
        return candidates.size() > 1;
    }

    @Override
    protected boolean allowMultiSelection(OCCppActionContext<OCStructSymbol, OCFunctionSymbol> context) {
        return false;
    }

    @Override
    protected boolean allowEmptySelection(OCCppActionContext<OCStructSymbol, OCFunctionSymbol> context) {
        return true;
    }

    @Override
    @Nullable
    protected OCCppActionContext<OCStructSymbol, OCFunctionSymbol> evaluateActionContext(Project project, @Nullable Editor editor, PsiFile file2) {
        final OCStructSymbol parent = (OCStructSymbol)this.getParent(project, editor, file2);
        final OCDeclaratorSymbol field = this.getField(editor, file2);
        if (parent == null || field == null) {
            return null;
        }
        return new OCCppActionContext<OCStructSymbol, OCFunctionSymbol>(parent, field.locateDefinition()){

            @Override
            @NotNull
            public Collection<OCFunctionSymbol> getMemberCandidates() {
                CommonProcessors.CollectProcessor<OCFunctionSymbol> collector = new CommonProcessors.CollectProcessor<OCFunctionSymbol>(){

                    protected boolean accept(OCFunctionSymbol constructor) {
                        OCConstructorInitializationList initializationList;
                        if ((constructor = (OCFunctionSymbol)constructor.getDefinitionSymbol()) == null) {
                            return false;
                        }
                        OCFunctionDefinition function = (OCFunctionDefinition)constructor.locateFunctionDefinition();
                        OCConstructorInitializationList oCConstructorInitializationList = initializationList = function != null ? function.getConstructorInitializationList() : null;
                        if (initializationList != null) {
                            for (OCConstructorFieldInitializer initializer : initializationList.getInitializers()) {
                                OCReferenceElement referenceElement = initializer.getReferenceElement();
                                OCSymbol symbol = referenceElement != null ? referenceElement.resolveToSymbol() : null;
                                if (!field.equals(symbol)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                };
                parent.processConstructors((Processor<? super OCFunctionSymbol>)collector);
                Collection collection = collector.getResults();
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCAddParametersToConstructorIntentionAction$1", "getMemberCandidates"));
                }
                return collection;
            }
        };
    }

    @Override
    @Nullable
    protected OCCppActionContext<OCStructSymbol, OCFunctionSymbol> evaluateActionContext(OCStructSymbol parent, PsiElement element) {
        return null;
    }

    @Override
    protected void performAction(Project project, Editor editor, PsiFile file2, OCCppActionContext<OCStructSymbol, OCFunctionSymbol> context, List<OCFunctionSymbol> chosenCandidates) {
        OCFunctionDefinition constructor;
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        final OCDeclaratorSymbol field = this.getField(editor, file2);
        if (field == null) {
            return;
        }
        if (chosenCandidates.size() == 0) {
            new OCGenerateConstructorHandler(){

                @Override
                @NotNull
                protected OCGenerateConstructorContext evaluateActionContext(OCStructSymbol parent, PsiElement context) {
                    OCGenerateConstructorContext superContext = super.evaluateActionContext(parent, context);
                    OCGenerateConstructorContext oCGenerateConstructorContext = new OCGenerateConstructorContext(parent, context, superContext.getAllBaseConstructors()){

                        @Override
                        @NotNull
                        public Collection<OCDeclaratorSymbol> getMemberCandidates() {
                            List<OCDeclaratorSymbol> list = Collections.singletonList(field);
                            if (list == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCAddParametersToConstructorIntentionAction$2$1", "getMemberCandidates"));
                            }
                            return list;
                        }
                    };
                    if (oCGenerateConstructorContext == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCAddParametersToConstructorIntentionAction$2", "evaluateActionContext"));
                    }
                    return oCGenerateConstructorContext;
                }

                @Override
                protected boolean enableChooseDialog(Collection<OCDeclaratorSymbol> candidates) {
                    return false;
                }
            }.invoke(project, editor, file2);
            return;
        }
        assert (chosenCandidates.size() == 1);
        OCFunctionSymbol constructorSymbol = (OCFunctionSymbol)chosenCandidates.get(0).getDefinitionSymbol();
        OCFunctionDefinition oCFunctionDefinition = constructor = constructorSymbol != null ? (OCFunctionDefinition)constructorSymbol.locateFunctionDefinition() : null;
        if (constructor == null) {
            return;
        }
        OCChangeSignatureHandler handler2 = OCChangeSignatureActionHandler.getHandler((OCCallable)constructor, constructor);
        final String paramName = OCNameSuggester.suggestUniqueName(OCSymbolKind.PARAMETER, field.getName(), null, (Collection<String>)ContainerUtil.map(constructorSymbol.getParameterSymbols(), (Function)new Function<OCDeclaratorSymbol, String>(){

            public String fun(OCDeclaratorSymbol symbol) {
                return symbol.getName();
            }
        }));
        handler2.addParameter(paramName, field.getType(), -1);
        handler2.getGeneratedInfo().runOnSuccess(new Runnable(){

            @Override
            public void run() {
                OCAddFieldInitializerFix.addFieldInitializer(constructor, field, paramName);
            }
        });
        handler2.setTitle(this.getActionTitle());
        handler2.invoke();
    }
}

