/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.inspections.OCUnusedCodeInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedTemplateParameterInspection;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import org.jetbrains.annotations.NotNull;

public class OCUnusedGlobalDeclarationInspection
extends OCUnusedCodeInspection {
    @Override
    @NotNull
    public OCUnusedCodeInspection.UnusedVisitor buildVisitor() {
        OCUnusedCodeInspection.UnusedVisitor unusedVisitor = new OCUnusedCodeInspection.UnusedVisitor(){

            @Override
            public void visitDeclarator(OCDeclarator declarator) {
                final OCSymbol symbol = this.getSymbol(declarator);
                if (symbol != null && symbol.isGlobal()) {
                    if (!this.myOnTheFly && (symbol instanceof OCDeclaratorSymbol || symbol instanceof OCFunctionSymbol) && !symbol.processSameSymbols((Processor<OCSymbol>)new CommonProcessors.FindFirstProcessor<OCSymbol>(){

                        protected boolean accept(OCSymbol sameSymbol) {
                            return symbol instanceof OCFunctionSymbol && symbol.isDefinition() && sameSymbol.isPredeclaration() || symbol instanceof OCDeclaratorSymbol && symbol.isPredeclaration() && sameSymbol.isDefinition() || sameSymbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)sameSymbol).isExtern();
                        }
                    })) {
                        return;
                    }
                    if (symbol instanceof OCFunctionSymbol && OCUnusedGlobalDeclarationInspection.isFunctionUsed((OCFunctionSymbol)symbol)) {
                        return;
                    }
                    if (declarator.getParent() instanceof OCParameterDeclaration && declarator.getParent().getParent() instanceof OCTemplateParameterList && OCUnusedTemplateParameterInspection.isTraitTemplateParameter((OCTemplateParameterList)declarator.getParent().getParent())) {
                        return;
                    }
                    this.checkSymbolUsed(declarator, symbol, this.myHasWrites);
                }
            }
        };
        if (unusedVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/inspections/OCUnusedGlobalDeclarationInspection", "buildVisitor"));
        }
        return unusedVisitor;
    }

    private static boolean isFunctionUsed(OCFunctionSymbol symbol) {
        if (symbol.isMainFunction()) {
            return true;
        }
        OCFile file2 = symbol.getContainingOCFile();
        if (file2 == null || file2.isCpp()) {
            if (symbol.isCppOperator() || symbol.isCppConstructor() || symbol.isCppDestructor()) {
                return true;
            }
            if (OCFunctionAncestorsQuery.findFirstVirtual(symbol, false) != null) {
                return true;
            }
        }
        return false;
    }
}

