/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.structureVIew;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.hierarchy.structureVIew.OCStructureViewElement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OCInheritorsAndCategoriesNodeProvider
implements FileStructureNodeProvider<OCStructureViewElement> {
    @NonNls
    private static final String ID = "INHERITORS_AND_CATEGORIES";

    @NotNull
    public String getCheckBoxText() {
        if ("Other Categories and Inherited Members" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/hierarchy/structureVIew/OCInheritorsAndCategoriesNodeProvider", "getCheckBoxText"));
        }
        return "Other Categories and Inherited Members";
    }

    @NotNull
    public Shortcut[] getShortcut() {
        Shortcut[] shortcutArray = KeymapManager.getInstance().getActiveKeymap().getShortcuts("FileStructurePopup");
        if (shortcutArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/hierarchy/structureVIew/OCInheritorsAndCategoriesNodeProvider", "getShortcut"));
        }
        return shortcutArray;
    }

    @NotNull
    public Collection<OCStructureViewElement> provideNodes(@NotNull TreeElement node) {
        OCClassSymbol ownSymbol;
        PsiElement context;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/hierarchy/structureVIew/OCInheritorsAndCategoriesNodeProvider", "provideNodes"));
        }
        if (node instanceof OCStructureViewElement && ((OCStructureViewElement)node).isAllowInheritorsAndCategories() && (context = ((OCStructureViewElement)node).getValue()) instanceof OCClassDeclaration && (ownSymbol = ((OCClassDeclaration)context).getSymbol()) != null) {
            final HashSet processed = new HashSet();
            ownSymbol.processMembers(OCMemberSymbol.class, new Processor<OCMemberSymbol>(){

                public boolean process(OCMemberSymbol symbol) {
                    processed.add(symbol.getNameWithParent());
                    return true;
                }
            });
            OCObjectType type = ((OCClassDeclaration)context).getType(true);
            if (type != null) {
                final ArrayList<OCStructureViewElement> answer = new ArrayList<OCStructureViewElement>();
                final HashSet parents = new HashSet();
                type.processMembers(OCMemberSymbol.class, new Processor<OCMemberSymbol>(){

                    public boolean process(OCMemberSymbol symbol) {
                        if (symbol instanceof OCInstanceVariableSymbol) {
                            return true;
                        }
                        OCClassSymbol parent = (OCClassSymbol)symbol.getParent();
                        if (parent == null || parents.contains(parent)) {
                            return true;
                        }
                        if (!processed.add(symbol.getNameWithParent())) {
                            return true;
                        }
                        if (parents.add(parent)) {
                            String categoryName;
                            if ("NSObject".equals(parent.getName()) && !StringUtil.isEmpty((String)(categoryName = parent.getCategoryName())) && !categoryName.startsWith("NSKeyValue")) {
                                return true;
                            }
                            Object declaration = parent.locateDefinition();
                            if (declaration != null) {
                                answer.add(new OCStructureViewElement((PsiElement)declaration, false, context));
                            }
                        }
                        return true;
                    }
                });
                ArrayList<OCStructureViewElement> arrayList = answer;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/hierarchy/structureVIew/OCInheritorsAndCategoriesNodeProvider", "provideNodes"));
                }
                return arrayList;
            }
        }
        List<OCStructureViewElement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/hierarchy/structureVIew/OCInheritorsAndCategoriesNodeProvider", "provideNodes"));
        }
        return list;
    }

    @NotNull
    public ActionPresentation getPresentation() {
        ActionPresentationData actionPresentationData = new ActionPresentationData("Show Inherited", "Show inherited members and members in other categories", AllIcons.Hierarchy.Supertypes);
        if (actionPresentationData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/hierarchy/structureVIew/OCInheritorsAndCategoriesNodeProvider", "getPresentation"));
        }
        return actionPresentationData;
    }

    @NotNull
    public String getName() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/hierarchy/structureVIew/OCInheritorsAndCategoriesNodeProvider", "getName"));
        }
        return ID;
    }
}

