/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy;

import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.Content;
import com.jetbrains.cidr.lang.hierarchy.OCTypeHierarchyBrowser;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class OCTypeHierarchyProvider
implements HierarchyProvider {
    public PsiElement getTarget(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/cidr/lang/hierarchy/OCTypeHierarchyProvider", "getTarget"));
        }
        PsiElement psi = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psi instanceof OCClassPredeclaration) {
            OCClassSymbol symbol = ((OCClassPredeclaration)psi).getSymbol();
            if (symbol != null && (symbol = symbol.getDefinitionSymbol()) != null) {
                return symbol.locateDefinition();
            }
            return null;
        }
        return OCTypeHierarchyProvider.canCreateTypeHierarchy(psi) ? psi : null;
    }

    private static boolean canCreateTypeHierarchy(PsiElement psi) {
        return psi instanceof OCClassDeclaration || psi instanceof OCStruct;
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(final PsiElement target) {
        if (OCTypeHierarchyProvider.canCreateTypeHierarchy(target)) {
            OCTypeHierarchyBrowser oCTypeHierarchyBrowser = new OCTypeHierarchyBrowser(target.getProject(), (OCElement)target);
            if (oCTypeHierarchyBrowser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/hierarchy/OCTypeHierarchyProvider", "createHierarchyBrowser"));
            }
            return oCTypeHierarchyBrowser;
        }
        HierarchyBrowser hierarchyBrowser = new HierarchyBrowser(){

            public JComponent getComponent() {
                return new JLabel("Not implemented. Target: " + target);
            }

            public void setContent(Content content) {
            }
        };
        if (hierarchyBrowser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/hierarchy/OCTypeHierarchyProvider", "createHierarchyBrowser"));
        }
        return hierarchyBrowser;
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        if (hierarchyBrowser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchyBrowser", "com/jetbrains/cidr/lang/hierarchy/OCTypeHierarchyProvider", "browserActivated"));
        }
        OCTypeHierarchyBrowser browser = (OCTypeHierarchyBrowser)hierarchyBrowser;
        String typeName = browser.isImplementation() ? OCTypeHierarchyBrowser.SUPERTYPES_HIERARCHY_TYPE : (browser.isInterface() ? OCTypeHierarchyBrowser.SUBTYPES_HIERARCHY_TYPE : OCTypeHierarchyBrowser.TYPE_HIERARCHY_TYPE);
        browser.changeView(typeName);
    }
}

