/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.ui.LayeredIcon;
import javax.swing.Icon;

public class OCClassHierarchyNodeDescriptor<T extends NavigatablePsiElement>
extends HierarchyNodeDescriptor {
    public OCClassHierarchyNodeDescriptor(Project project, NodeDescriptor parentDescriptor, T element, boolean isBase) {
        super(project, parentDescriptor, (PsiElement)element, isBase);
    }

    public T getType() {
        return (T)((NavigatablePsiElement)this.getPsiElement());
    }

    @Override
    public final boolean update() {
        String location;
        boolean changes = super.update();
        PsiElement element = this.getPsiElement();
        if (element == null) {
            String invalidPrefix = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
            if (!this.myHighlightedText.getText().startsWith(invalidPrefix)) {
                this.myHighlightedText.getBeginning().addText(invalidPrefix, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
            }
            return true;
        }
        if (changes && this.myIsBase) {
            LayeredIcon icon = new LayeredIcon(2);
            icon.setIcon(this.getIcon(), 0);
            icon.setIcon(AllIcons.Hierarchy.Base, 1, -AllIcons.Hierarchy.Base.getIconWidth() / 2, 0);
            this.setIcon((Icon)icon);
        }
        NavigatablePsiElement aClass = (NavigatablePsiElement)element;
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        this.myHighlightedText.getEnding().addText(aClass.getName(), classNameAttributes);
        ItemPresentation presentation = aClass.getPresentation();
        String string = location = presentation != null ? presentation.getLocationString() : null;
        if (location != null) {
            this.myHighlightedText.getEnding().addText(" (" + location + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }
}

