/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers.implement;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementActionContext;
import com.jetbrains.cidr.lang.generate.handlers.implement.OCImplementOCMethodsHandler;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCOverrideImplementOCMethodHandler
extends OCImplementOCMethodsHandler {
    @Override
    protected String getNoMembersMessage(OCOverrideImplementActionContext context) {
        return context.getParentNameUppercase() + " has no methods to override/implement";
    }

    @Override
    protected List<Pair<OCOption, Object>> loadOptions(PsiFile file2, @Nullable OCCodeStyleSettings settings, @NotNull OCOverrideImplementActionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/generate/handlers/implement/OCOverrideImplementOCMethodHandler", "loadOptions"));
        }
        ArrayList<Pair<OCOption, Object>> result2 = new ArrayList<Pair<OCOption, Object>>();
        result2.add(new Pair((Object)SHOW_OPTIONAL, (Object)true));
        result2.add(new Pair((Object)SHOW_SYNTHESIZED_ACCESSORS, (Object)true));
        return result2;
    }

    @Override
    @NotNull
    protected OCOverrideImplementActionContext evaluateActionContext(OCClassSymbol parent, final PsiElement element) {
        OCOverrideImplementActionContext oCOverrideImplementActionContext = new OCOverrideImplementActionContext(parent, parent.getResolvedType(true), element){

            @Override
            @NotNull
            public Collection<OCMethodSymbol> getMemberCandidates() {
                final HashSet names = new HashSet();
                final ArrayList<OCMethodSymbol> candidates = new ArrayList<OCMethodSymbol>();
                OCObjectType type = this.getType();
                OCObjectType superType = type.getSuperType();
                if (superType == null || type.getClassSymbol() == null || superType.getClassSymbol() == null) {
                    List<OCMethodSymbol> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/generate/handlers/implement/OCOverrideImplementOCMethodHandler$1", "getMemberCandidates"));
                    }
                    return list;
                }
                type.processInterfaceMethods(this.getInterfaceSymbol(), null, new Processor<OCMethodSymbol>(){

                    public boolean process(OCMethodSymbol symbol) {
                        if (names.add(symbol.getSignature())) {
                            candidates.add(symbol);
                            myAbstractMethods.add(symbol);
                        }
                        return true;
                    }
                }, element, false);
                superType.processMembers(null, OCMethodSymbol.class, new Processor<OCMethodSymbol>(){

                    public boolean process(OCMethodSymbol symbol) {
                        if (names.add(symbol.getSignature())) {
                            candidates.add(symbol);
                        }
                        return true;
                    }
                }, true, false);
                ArrayList<OCMethodSymbol> arrayList = candidates;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/generate/handlers/implement/OCOverrideImplementOCMethodHandler$1", "getMemberCandidates"));
                }
                return arrayList;
            }
        };
        if (oCOverrideImplementActionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/generate/handlers/implement/OCOverrideImplementOCMethodHandler", "evaluateActionContext"));
        }
        return oCOverrideImplementActionContext;
    }

    @Override
    protected String getMembersChooserTitle() {
        return "Choose Methods to Override/Implement";
    }

    @Override
    protected boolean selectAllCandidates() {
        return false;
    }

    @Override
    protected String generateMethodText(OCMethodSymbol baseMethod, PsiElement context, OCOverrideImplementActionContext actionContext) {
        String templateName = actionContext.isAbstract(baseMethod) ? "OC Implemented Method Body.m" : "OC Overridden Method Body.m";
        HashMap<String, String> map = new HashMap<String, String>();
        OCPropertySymbol property = baseMethod.getGeneratedFromProperty();
        if (property != null) {
            map.put("IVAR_IS_AVAILABLE", actionContext.isIvarAvailable(property) ? "true" : "false");
        }
        return OCCallableUtil.methodFromTemplate(baseMethod, templateName, context, map);
    }
}

