/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers.implement;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCObjCClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCOverrideImplementMethodsHandlerBase
extends OCObjCClassTextActionHandlerBase<OCMethodSymbol, OCOverrideImplementActionContext> {
    @Override
    protected String getActionTitle() {
        return "Override/Implement Methods";
    }

    @Override
    @NotNull
    protected OCOverrideImplementActionContext evaluateActionContext(OCClassSymbol parent, PsiElement element) {
        OCOverrideImplementActionContext oCOverrideImplementActionContext = new OCOverrideImplementActionContext(parent, parent.getResolvedType(true), element);
        if (oCOverrideImplementActionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/generate/handlers/implement/OCOverrideImplementMethodsHandlerBase", "evaluateActionContext"));
        }
        return oCOverrideImplementActionContext;
    }

    @Override
    @Nullable
    protected String getInsertText(PsiElement element, PsiElement at, List<OCMethodSymbol> methods, OCOverrideImplementActionContext context) {
        assert (element instanceof OCImplementation);
        StringBuilder result2 = new StringBuilder();
        for (OCMethodSymbol baseMethod : methods) {
            result2.append(this.generateMethodText(baseMethod, element.getLastChild(), context));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        return result2.toString();
    }

    @Override
    protected Condition<OCMethodSymbol> getCandidatesFilter(OCOverrideImplementActionContext context) {
        final HashSet ownMethods = new HashSet();
        context.getImplementationSymbol().processMembers(OCMethodSymbol.class, new Processor<OCMethodSymbol>(){

            public boolean process(OCMethodSymbol symbol) {
                ownMethods.add(symbol.getSignature());
                return true;
            }
        });
        return new Condition<OCMethodSymbol>(){

            public boolean value(OCMethodSymbol method) {
                return !ownMethods.contains(method.getSignature());
            }
        };
    }

    @Override
    protected int getInsertPosition(PsiElement element, int caretOffset, PsiElement at, List<OCMethodSymbol> methods, OCOverrideImplementActionContext actionContext) {
        OCMethodSymbol firstMethod = methods.get(0);
        OCClassDeclaration declaration = (OCClassDeclaration)element;
        if ((at == null || caretOffset < declaration.getMethodsStartOffset(true)) && (at = declaration.getBestMemberPlace(firstMethod)) != null) {
            caretOffset = at.getTextRange().getStartOffset();
        }
        return declaration.getMethodsInsertPosition(methods.size() == 1 && firstMethod.getName().startsWith("init"), at, caretOffset);
    }

    protected abstract String generateMethodText(OCMethodSymbol var1, PsiElement var2, OCOverrideImplementActionContext var3);

    @Override
    protected boolean shouldSelectResult(OCBlockStatement body) {
        return true;
    }
}

