/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers.implement;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCCppClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementCppActionContext;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class OCOverrideImplementCppFunctionsHandlerBase
extends OCCppClassTextActionHandlerBase<OCMembersContainer, OCFunctionSymbol, OCOverrideImplementCppActionContext> {
    protected static final OCBooleanOption INSERT_OVERRIDE = new OCBooleanOption("Insert \"override\" attribute");

    @Override
    protected String getActionTitle() {
        return "Override/Implement Functions";
    }

    @Override
    protected void consumeParent(List<OCMembersContainer> parents, OCMembersContainer parent) {
        parents.add(parent);
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCFunctionSymbol> candidates, OCOverrideImplementCppActionContext actionContext, int moreNodesLevel) {
        final Map<OCSymbol, OCSymbol> parentsMap = actionContext.createParentsMap(candidates);
        final OCNamespaceSymbol parent = actionContext.getParent() instanceof OCNamespaceSymbol ? (OCNamespaceSymbol)actionContext.getParent() : null;
        return (OCMemberChooserObject[])ContainerUtil.map2Array(candidates, OCMemberChooserObject.class, (Function)new Function<OCFunctionSymbol, OCMemberChooserObject>(){

            public OCMemberChooserObject fun(OCFunctionSymbol m) {
                boolean isIncomplete = m.isPureVirtual() || Comparing.equal((Object)parent, (Object)m.getParent());
                return new OCMemberChooserObject((OCSymbol)m, OCIcons.getFunctionIcon(m.isStatic(), isIncomplete, !m.isVirtual(), m.getVisibility()), (Map<OCSymbol, OCSymbol>)parentsMap);
            }
        });
    }

    @Override
    protected void performAction(Project project, Editor editor, final PsiFile file2, final OCOverrideImplementCppActionContext actionContext, List<OCFunctionSymbol> chosenCandidates) {
        if (actionContext.getParent() instanceof OCStructSymbol) {
            Collections.sort(chosenCandidates, new Comparator<OCFunctionSymbol>(){

                @Override
                public int compare(@NotNull OCFunctionSymbol fun1, @NotNull OCFunctionSymbol fun2) {
                    OCVisibility visibility2;
                    if (fun1 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun1", "com/jetbrains/cidr/lang/generate/handlers/implement/OCOverrideImplementCppFunctionsHandlerBase$2", "compare"));
                    }
                    if (fun2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun2", "com/jetbrains/cidr/lang/generate/handlers/implement/OCOverrideImplementCppFunctionsHandlerBase$2", "compare"));
                    }
                    OCVisibility visibility1 = OCOverrideImplementCppFunctionsHandlerBase.getInheritorVisibility(fun1, (OCStructSymbol)actionContext.getParent(), file2);
                    if (visibility1 == (visibility2 = OCOverrideImplementCppFunctionsHandlerBase.getInheritorVisibility(fun2, (OCStructSymbol)actionContext.getParent(), file2))) {
                        int filesCmp = FileUtil.comparePaths((String)fun1.getContainingFile().getPath(), (String)fun2.getContainingFile().getPath());
                        return filesCmp != 0 ? filesCmp : fun1.getOffset() - fun2.getOffset();
                    }
                    return visibility1.compareTo(visibility2);
                }
            });
        }
        super.performAction(project, editor, file2, actionContext, chosenCandidates);
    }

    @Override
    protected String getInsertText(PsiElement element, PsiElement at, List<OCFunctionSymbol> members, OCOverrideImplementCppActionContext actionContext) {
        StringBuilder result2 = new StringBuilder();
        PsiElement context = this.getInsertContext(element, at, actionContext);
        if (context == null) {
            context = element;
        }
        OCVisibility curVisibility = OCOverrideImplementCppFunctionsHandlerBase.getVisibilityAtOffset(element, this.getInsertPosition(element, 0, at, members, actionContext));
        for (OCFunctionSymbol member : members) {
            OCFunctionSymbol ancestor;
            OCNamespaceSymbol parent = actionContext.getParent() instanceof OCNamespaceSymbol ? (OCNamespaceSymbol)actionContext.getParent() : null;
            boolean fromAncestorClass = parent != null && !parent.equals(member.getParent());
            boolean isDeclaration = false;
            boolean isDefinition = false;
            if (element instanceof OCStruct || element instanceof OCCppNamespace) {
                if (parent instanceof OCStructSymbol && fromAncestorClass) {
                    OCVisibility visibility = OCOverrideImplementCppFunctionsHandlerBase.getInheritorVisibility(member, (OCStructSymbol)parent, element.getContainingFile());
                    if (element instanceof OCStruct && curVisibility != visibility) {
                        curVisibility = visibility;
                        result2.append((Object)visibility).append(":");
                    }
                    isDeclaration = true;
                }
            } else {
                isDefinition = true;
            }
            if (!isDeclaration && !isDefinition) continue;
            boolean insertOverride = this.getOption(actionContext, INSERT_OVERRIDE) == Boolean.TRUE;
            OCFunctionSymbol function = OCCallableUtil.createOverridingFunction(member, parent, context, curVisibility, isDeclaration, insertOverride);
            String qualifier = OCCallableUtil.getFunctionParentQualifier(function, context, member.isFriendFunction());
            OCFunctionSymbol baseToCall = fromAncestorClass ? (!member.isPureVirtual() ? member : null) : ((ancestor = OCFunctionAncestorsQuery.findFirstVirtual(member, false)) != null && !ancestor.isPureVirtual() ? ancestor : null);
            result2.append(OCCallableUtil.exactFunctionText(function, baseToCall, isDefinition, qualifier, context));
        }
        return result2.toString();
    }

    private static OCVisibility getInheritorVisibility(OCFunctionSymbol symbol, OCStructSymbol inheritorClassSymbol, PsiFile file2) {
        OCVisibility declaredVisibility = symbol.getVisibility();
        declaredVisibility = declaredVisibility != null ? declaredVisibility : OCVisibility.PRIVATE;
        return OCVisibility.max(declaredVisibility, OCVisibility.getMaxInheritanceVisibility((OCStructSymbol)symbol.getParent(), inheritorClassSymbol, file2));
    }
}

