/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers.implement;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementCppActionContext;
import com.jetbrains.cidr.lang.generate.handlers.implement.OCOverrideImplementCppFunctionsHandlerBase;
import com.jetbrains.cidr.lang.quickfixes.OCMakeFunctionVirtualFix;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCOverrideImplementCppFunctionsHandler
extends OCOverrideImplementCppFunctionsHandlerBase {
    protected static final OCBooleanOption SHOW_NON_VIRTUAL_FUNCTIONS = new OCBooleanOption("Show non-virtual functions");

    @Override
    @Nullable
    public String getActionName() {
        return "Override Functions...";
    }

    @Override
    protected String getMembersChooserTitle() {
        return "Choose Functions to Override/Implement";
    }

    @Override
    protected String getNoMembersMessage(OCOverrideImplementCppActionContext context) {
        return context.getParentNameUppercase() + " has no functions to override/implement";
    }

    @Override
    protected String getNoParentsMessage() {
        return "No functions to override/implement";
    }

    @Override
    protected OCOverrideImplementCppActionContext evaluateActionContext(OCMembersContainer parent, PsiElement context) {
        return new OCOverrideImplementCppActionContext(parent, context, false);
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCFunctionSymbol> candidates, OCOverrideImplementCppActionContext actionContext, int moreNodesLevel) {
        final Boolean showNonVirtual = OCOverrideImplementCppFunctionsHandler.getOption(chooser.getOptionSelections(), SHOW_NON_VIRTUAL_FUNCTIONS);
        return super.getChooserNodes(chooser, (Collection<OCFunctionSymbol>)ContainerUtil.filter(candidates, (Condition)new Condition<OCFunctionSymbol>(){

            public boolean value(OCFunctionSymbol symbol) {
                VirtualFile file2 = symbol.getContainingFile();
                return symbol.isVirtual() || showNonVirtual != false && file2 != null && file2.isWritable();
            }
        }), actionContext, moreNodesLevel);
    }

    @Override
    protected List<Pair<OCOption, Object>> loadOptions(PsiFile file2, @Nullable OCCodeStyleSettings settings, @NotNull OCOverrideImplementCppActionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/generate/handlers/implement/OCOverrideImplementCppFunctionsHandler", "loadOptions"));
        }
        ArrayList<Pair<OCOption, Object>> result2 = new ArrayList<Pair<OCOption, Object>>();
        result2.add(new Pair((Object)SHOW_NON_VIRTUAL_FUNCTIONS, (Object)true));
        if (OCCompilerHelper.supportsOverrideControl(file2)) {
            result2.add((Pair<OCOption, Object>)new Pair((Object)INSERT_OVERRIDE, (Object)(settings == null || settings.INSERT_OVERRIDE ? 1 : 0)));
        }
        return result2;
    }

    @Override
    protected void saveOptions(PsiFile file2, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/cidr/lang/generate/handlers/implement/OCOverrideImplementCppFunctionsHandler", "saveOptions"));
        }
        if (OCCompilerHelper.supportsOverrideControl(file2)) {
            settings.INSERT_OVERRIDE = OCOverrideImplementCppFunctionsHandler.getOption(optionValues, INSERT_OVERRIDE);
        }
    }

    @Override
    protected void optionValueChanged(OCMemberChooser chooser, Collection<OCFunctionSymbol> candidates, OCOption option, OCOverrideImplementCppActionContext actionContext) {
        if (SHOW_NON_VIRTUAL_FUNCTIONS.equals(option)) {
            chooser.resetElements(this.getChooserNodes(chooser, candidates, actionContext, 0));
        }
    }

    @Override
    protected void performAction(final Project project, final Editor editor, final PsiFile file2, OCOverrideImplementCppActionContext actionContext, final List<OCFunctionSymbol> chosenCandidates) {
        final OCStructSymbol parent = actionContext.getParent() instanceof OCStructSymbol ? (OCStructSymbol)actionContext.getParent() : null;
        super.performAction(project, editor, file2, actionContext, (List<OCFunctionSymbol>)ContainerUtil.map(chosenCandidates, (Function)new Function<OCFunctionSymbol, OCFunctionSymbol>(){

            public OCFunctionSymbol fun(OCFunctionSymbol symbol) {
                if (!symbol.isVirtual() && parent != null && !parent.equals(symbol.getParent())) {
                    return new OCFunctionSymbol(symbol){

                        @Override
                        public boolean isVirtual() {
                            return true;
                        }
                    };
                }
                return symbol;
            }
        }));
        new WriteCommandAction(project, new PsiFile[]{file2}){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/generate/handlers/implement/OCOverrideImplementCppFunctionsHandler$3", "run"));
                }
                Collections.sort(chosenCandidates, new Comparator<OCFunctionSymbol>(){

                    @Override
                    public int compare(OCFunctionSymbol o1, OCFunctionSymbol o2) {
                        return o2.getOffset() - o1.getOffset();
                    }
                });
                for (OCFunctionSymbol candidate : chosenCandidates) {
                    OCMakeFunctionVirtualFix fix = new OCMakeFunctionVirtualFix(candidate, false);
                    if (candidate.isVirtual() || parent == null || parent.equals(candidate.getParent()) || !fix.isAvailable(project, editor, file2)) continue;
                    fix.invoke(project, editor, file2);
                }
            }
        }.execute();
    }
}

