/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.generate.actions.OCObjCActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCObjCClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCDeclarationKind;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class OCGenerateSharedInstanceHandler
extends OCObjCClassTextActionHandlerBase<OCMethodSymbol, OCObjCActionContext<OCMethodSymbol>> {
    private static final String SHARED_INSTANCE_HEADER_TEMPLATE_NAME = "OC Shared Instance Header.h";
    private static final String SHARED_INSTANCE_IMPLEMENTATION_TEMPLATE_NAME = "OC Shared Instance Implementation.m";
    private static final String CLASS_TYPE_TEMPLATE_PROPERTY = "CLASS_TYPE";

    @Override
    protected String getActionTitle() {
        return "Generate Shared Instance Method";
    }

    @Override
    protected String getMembersChooserTitle() {
        return "";
    }

    @Override
    @NotNull
    protected OCObjCActionContext<OCMethodSymbol> evaluateActionContext(OCClassSymbol parent, PsiElement element) {
        OCObjCActionContext<OCMethodSymbol> oCObjCActionContext = new OCObjCActionContext<OCMethodSymbol>(parent, element, parent.getResolvedType(true)){

            @Override
            protected Class<OCMethodSymbol> getMemberSymbolClass() {
                return OCMethodSymbol.class;
            }
        };
        if (oCObjCActionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/generate/handlers/OCGenerateSharedInstanceHandler", "evaluateActionContext"));
        }
        return oCObjCActionContext;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCMethodSymbol> candidates) {
        return false;
    }

    @Override
    protected boolean allowEmptySelection(OCObjCActionContext<OCMethodSymbol> context) {
        return true;
    }

    @Override
    protected int getInsertPosition(PsiElement element, int caretOffset, PsiElement at, List<OCMethodSymbol> members, OCObjCActionContext<OCMethodSymbol> actionContext) {
        if (at == null || caretOffset < ((OCClassDeclaration)element).getMethodsStartOffset(true)) {
            return OCDeclarationKind.StaticMethod.getChildrenEndOffset(element);
        }
        return ((OCClassDeclaration)element).getMethodsInsertPosition(true, at, caretOffset);
    }

    @Override
    protected String getInsertText(@NotNull PsiElement element, PsiElement at, List<OCMethodSymbol> members, OCObjCActionContext<OCMethodSymbol> context) {
        String templateName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/generate/handlers/OCGenerateSharedInstanceHandler", "getInsertText"));
        }
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance(element.getProject());
        if (element instanceof OCInterface) {
            templateName = SHARED_INSTANCE_HEADER_TEMPLATE_NAME;
        } else if (element instanceof OCImplementation) {
            templateName = SHARED_INSTANCE_IMPLEMENTATION_TEMPLATE_NAME;
        } else {
            return null;
        }
        FileTemplate template = fileTemplateManager.getCodeTemplate(templateName);
        if (template != null) {
            Properties properties = new Properties(FileTemplateManager.getInstance(element.getProject()).getDefaultProperties());
            properties.setProperty(CLASS_TYPE_TEMPLATE_PROPERTY, context.getType().getBestNameInContext(element));
            try {
                return template.getText(properties);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to load template for file template '%s'!", fileTemplateManager.internalTemplateToSubject(templateName)), e);
            }
        }
        return null;
    }
}

