/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCObjCClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCElementsMover;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCDeclarationKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCGenerateMethodHandler
extends OCObjCClassTextActionHandlerBase<OCInstanceVariableSymbol, OCGenerateMethodActionContext> {
    protected static final OCBooleanOption DECLARE_IN_INTERFACE = new OCBooleanOption("Declare in interface");

    @Override
    protected String getMembersChooserTitle() {
        return "Select Members";
    }

    @Override
    @Nullable
    protected OCGenerateMethodActionContext evaluateActionContext(final OCClassSymbol parent, PsiElement element) {
        if (!(parent.locateDefinition() instanceof OCClassDeclaration)) {
            return null;
        }
        final OCObjectType type = parent.getResolvedType(true);
        return new OCGenerateMethodActionContext(parent, ContainerUtil.map((Object[])this.getMethodNames(), (Function)new Function<String, OCMethodSymbol>(){

            public OCMethodSymbol fun(String methodName) {
                return OCGenerateMethodHandler.this.searchForMethod(methodName, type, parent.getProject());
            }
        }), type, element){

            @Override
            public List<OCClassSymbol> getSymbolsToModify() {
                if (OCGenerateMethodHandler.this.getOption(this, DECLARE_IN_INTERFACE).booleanValue()) {
                    return Arrays.asList(this.myInterfaceSymbol, this.myImplementationSymbol);
                }
                return Collections.singletonList(this.myImplementationSymbol);
            }

            @Override
            protected boolean showSymbol(OCInstanceVariableSymbol symbol) {
                return OCGenerateMethodHandler.this.showSymbolInChooser(symbol, this);
            }
        };
    }

    @Override
    @NotNull
    protected Collection<OCInstanceVariableSymbol> getSelectedCandidates(OCGenerateMethodActionContext actionContext, @Nullable Editor editor, PsiFile file2, List<OCInstanceVariableSymbol> candidates) {
        List<OCInstanceVariableSymbol> list = candidates;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/generate/handlers/OCGenerateMethodHandler", "getSelectedCandidates"));
        }
        return list;
    }

    protected boolean showSymbolInChooser(OCInstanceVariableSymbol symbol, OCGenerateMethodActionContext actionContext) {
        return true;
    }

    @Nullable
    protected String getParentProtocol() {
        return null;
    }

    private OCMethodSymbol searchForMethod(String methodName, OCObjectType type, Project project) {
        CommonProcessors.FindFirstProcessor<OCMethodSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

            protected boolean accept(OCMethodSymbol symbol) {
                return !symbol.isStatic();
            }
        };
        if (this.getParentProtocol() != null) {
            CommonProcessors.FindFirstProcessor protocolFinder = new CommonProcessors.FindFirstProcessor();
            OCCommonProcessors.TypeFilteredProcessor processor2 = new OCCommonProcessors.TypeFilteredProcessor((Processor<OCProtocolSymbol>)protocolFinder, OCProtocolSymbol.class);
            OCGlobalProjectSymbolsCache.processTopLevelSymbols(project, processor2, this.getParentProtocol());
            OCProtocolSymbol protocol = (OCProtocolSymbol)protocolFinder.getFoundValue();
            if (protocol != null) {
                protocol.processMembers(methodName, OCMethodSymbol.class, finder);
            }
        } else if (type != null) {
            type.processMembers(methodName, OCMethodSymbol.class, finder);
        }
        return (OCMethodSymbol)finder.getFoundValue();
    }

    protected abstract String[] getMethodNames();

    @Override
    protected boolean checkContext(Project project, Editor editor, OCGenerateMethodActionContext context) {
        Object existingMethod;
        if (!super.checkContext(project, editor, context)) {
            return false;
        }
        OCMethodSymbol existingSymbol = this.findExistingMethod(context);
        context.setDeleteExisting(true);
        Object v0 = existingMethod = existingSymbol != null ? existingSymbol.locateDefinition() : null;
        if (existingMethod != null) {
            int code;
            String message = existingSymbol.getNameWithKindUppercase() + " is already defined.\nDo you wish to replace the existing method?";
            int n = code = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((String)message, (String)this.getActionTitle(), (Icon)Messages.getQuestionIcon());
            if (code == 0) {
                return true;
            }
            if (code == 1) {
                context.setDeleteExisting(false);
                return true;
            }
            return false;
        }
        return true;
    }

    protected OCMethodSymbol findExistingMethod(OCGenerateMethodActionContext context) {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        for (String methodName : this.getMethodNames()) {
            if (!context.getImplementationSymbol().processMembersInAllCategories(methodName, OCMethodSymbol.class, finder, true)) break;
        }
        return (OCMethodSymbol)finder.getFoundValue();
    }

    protected boolean isExistingMethod(String selector) {
        for (String methodName : this.getMethodNames()) {
            if (!selector.equals(methodName)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void performAction(Project project, PsiElement element, int caretPos, @Nullable PsiElement at, List<OCInstanceVariableSymbol> members, OCGenerateMethodActionContext auxInfo) {
        if (this.getParentProtocol() != null && element instanceof OCImplementation) {
            OCClassDeclarationBase anInterface = (OCClassDeclarationBase)auxInfo.getInterfaceSymbol().locateDefinition();
            OCProtocolSymbol protocol = (OCProtocolSymbol)auxInfo.getBaseMethod().getParent();
            if (anInterface instanceof OCClassDeclaration && !auxInfo.getType().implementsProtocol(protocol)) {
                new OCElementsMover().addBaseProtocol((OCClassDeclaration)anInterface, protocol.getName());
            }
        }
        if (auxInfo.isDeleteExisting()) {
            for (OCMethod method : ((OCClassDeclaration)element).getMethods()) {
                if (!this.isExistingMethod(method.getSelector())) continue;
                OCChangeUtil.delete(method);
            }
        }
        if (element instanceof OCImplementation) {
            for (OCInstanceVariableSymbol member : members) {
                if (((OCClassSymbol)member.getParent()).isSameCategory(auxInfo.getInterfaceSymbol())) continue;
                new OCImportSymbolFix(element, (OCSymbol)member.getParent(), false).fixFirstItem(project, element.getContainingFile());
            }
        }
        super.performAction(project, element, caretPos, at, members, auxInfo);
    }

    @Override
    protected int getInsertPosition(PsiElement element, int caretOffset, PsiElement at, List<OCInstanceVariableSymbol> members, OCGenerateMethodActionContext actionContext) {
        if (at == null || caretOffset < ((OCClassDeclaration)element).getMethodsStartOffset(true)) {
            return OCDeclarationKind.InstanceMethod.getChildrenEndOffset(element);
        }
        return ((OCClassDeclaration)element).getMethodsInsertPosition(true, at, caretOffset);
    }

    protected static boolean processStructFields(OCType type, Processor<OCDeclaratorSymbol> processor2) {
        OCStructSymbol structSymbol;
        if (type instanceof OCStructType && !type.isScalar() && (structSymbol = ((OCStructType)type).getSymbol()).isPOD()) {
            CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
            structSymbol.processFields((Processor<OCDeclaratorSymbol>)collector);
            ArrayList fields = new ArrayList(collector.getResults());
            Collections.sort(fields, new Comparator<OCDeclaratorSymbol>(){

                @Override
                public int compare(OCDeclaratorSymbol o1, OCDeclaratorSymbol o2) {
                    return OCSymbolOffsetUtil.compare(o1.getComplexOffset(), o2.getComplexOffset());
                }
            });
            for (OCDeclaratorSymbol field : fields) {
                processor2.process((Object)field);
            }
            return true;
        }
        return false;
    }
}

