/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateMethodHandler;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateIsEqualAndHashHandler
extends OCGenerateMethodHandler {
    @Override
    protected String getActionTitle() {
        return "Generate -isEqual: and -hash";
    }

    @Override
    protected String[] getMethodNames() {
        return new String[]{"isEqual:", "hash"};
    }

    @Override
    protected boolean allowEmptySelection(OCGenerateMethodActionContext context) {
        return true;
    }

    @Override
    protected List<Pair<OCOption, Object>> loadOptions(PsiFile file2, @Nullable OCCodeStyleSettings settings, @NotNull OCGenerateMethodActionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/generate/handlers/OCGenerateIsEqualAndHashHandler", "loadOptions"));
        }
        return Collections.singletonList(new Pair((Object)DECLARE_IN_INTERFACE, (Object)(settings == null || settings.DECLARE_GENERATED_METHODS ? 1 : 0)));
    }

    @Override
    protected void saveOptions(PsiFile file2, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/cidr/lang/generate/handlers/OCGenerateIsEqualAndHashHandler", "saveOptions"));
        }
        settings.DECLARE_GENERATED_METHODS = OCGenerateIsEqualAndHashHandler.getOption(optionValues, DECLARE_IN_INTERFACE);
    }

    @Override
    protected boolean isExistingMethod(String selector) {
        return super.isExistingMethod(selector) || selector.startsWith("isEqualTo");
    }

    @Override
    @Nullable
    protected String getInsertText(PsiElement element, PsiElement at, List<OCInstanceVariableSymbol> ivars, OCGenerateMethodActionContext context) {
        StringBuilder builder = new StringBuilder();
        OCMethodSymbol isEqualMethod = context.getBaseMethods().get(0);
        OCMethodSymbol hashMethod = context.getBaseMethods().get(1);
        OCObjectType superType = context.getType().getSuperType();
        final HashSet<String> superMethodNames = new HashSet<String>();
        if (superType != null) {
            superType.processMembers(OCMethodSymbol.class, new Processor<OCMethodSymbol>(){

                public boolean process(OCMethodSymbol symbol) {
                    String name = symbol.getName();
                    if (name.endsWith(":")) {
                        superMethodNames.add(name.substring(0, name.length() - 1));
                    }
                    return true;
                }
            });
        }
        Collection<String> suggestions = OCNameSuggester.suggestForType((OCType)context.getType(), null, "");
        String customMethodName = "isEqualTo" + StringUtil.capitalize((String)(suggestions.isEmpty() ? "other" : suggestions.iterator().next()));
        customMethodName = OCNameSuggester.suggestUniqueName(null, customMethodName, null, superMethodNames);
        suggestions = OCNameSuggester.suggestForType(OCSymbolKind.PARAMETER, context.getType(), element.getLastChild(), "");
        String paramName = suggestions.isEmpty() ? "other" : suggestions.iterator().next();
        String customSignature = "-(BOOL)" + customMethodName + ":(" + context.getInterfaceSymbol().getName() + "*)" + paramName;
        if (element instanceof OCInterface) {
            builder.append(OCCallableUtil.methodSignature(isEqualMethod, element)).append(";");
            builder.append(customSignature).append(";");
            builder.append(OCCallableUtil.methodSignature(hashMethod, element)).append(";");
        } else {
            String isEqualBody = OCGenerateIsEqualAndHashHandler.getIsEqualBody(ivars, paramName, element, context);
            builder.append(OCCallableUtil.methodText(isEqualMethod, customMethodName, element));
            builder.append(OCCallableUtil.methodText(customSignature, isEqualBody, element));
            builder.append(OCGenerateIsEqualAndHashHandler.getHashMethod(ivars, element, context));
        }
        return builder.toString();
    }

    private static String getIsEqualBody(List<OCInstanceVariableSymbol> ivars, String paramName, PsiElement context, OCGenerateMethodActionContext actionContext) {
        OCImplementationSymbol classSymbol;
        StringBuilder body = new StringBuilder();
        body.append("if (self == ").append(paramName).append(")\nreturn YES;\n");
        body.append("if (").append(paramName).append(" == nil)\nreturn NO;\n");
        OCObjectType superType = actionContext.getType().getSuperType();
        OCImplementationSymbol oCImplementationSymbol = classSymbol = superType != null ? superType.getImplementation() : null;
        if (classSymbol != null && !classSymbol.processMembersInAllCategories("isEqual:", OCMethodSymbol.class, new CommonProcessors.FindFirstProcessor(), true)) {
            body.append("if (![super isEqual: ").append(paramName).append("])\nreturn NO;\n");
        }
        for (OCInstanceVariableSymbol ivar : ivars) {
            OCPropertySymbol property = ivar.getAssociatedProperty();
            OCType type = ivar.getType().resolve(context.getContainingFile(), true);
            if (property != null) {
                OCGenerateIsEqualAndHashHandler.appendIsEqualMember(body, context, "self." + property.getName(), paramName + "." + property.getName(), type);
                continue;
            }
            OCGenerateIsEqualAndHashHandler.appendIsEqualMember(body, context, ivar.getName(), paramName + "->" + ivar.getName(), type);
        }
        body.append("return YES;");
        return body.toString();
    }

    private static void appendIsEqualMember(final StringBuilder builder, final PsiElement context, final String selfName, final String otherName, final OCType type) {
        if (OCGenerateIsEqualAndHashHandler.processStructFields(type, new Processor<OCDeclaratorSymbol>(){

            public boolean process(OCDeclaratorSymbol field) {
                OCGenerateIsEqualAndHashHandler.appendIsEqualMember(builder, context, selfName + "." + field.getName(), otherName + "." + field.getName(), field.getResolvedType());
                return true;
            }
        })) {
            return;
        }
        builder.append("if (").append(selfName).append("!=").append(otherName);
        if (type.isPointerToObject()) {
            OCObjectType objType = (OCObjectType)type.getTerminalType();
            CommonProcessors.FindFirstProcessor<OCMethodSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

                protected boolean accept(OCMethodSymbol symbol) {
                    String prefix = "isEqualTo";
                    if (symbol.getName().startsWith(prefix) && symbol.getName().length() > prefix.length() + 2 && symbol.getSelectors().size() == 1) {
                        OCDeclaratorSymbol param = symbol.getSelectors().get(0).getParameter();
                        return param != null && param.getType().resolve(context.getContainingFile()).isCompatible(type, context);
                    }
                    return false;
                }
            };
            objType.processMembers((String)null, OCMethodSymbol.class, finder);
            OCMethodSymbol customMethod = (OCMethodSymbol)finder.getFoundValue();
            OCDeclaratorSymbol parameter = customMethod != null ? customMethod.getSelectors().get(0).getParameter() : null;
            String methodName = parameter != null && parameter.getResolvedType().isCompatible(type, (PsiElement)context.getContainingFile()) ? customMethod.getName() : "isEqual:";
            builder.append("&&![").append(selfName).append(" ").append(methodName).append(otherName).append("]");
        }
        builder.append(")\nreturn NO;\n");
    }

    private static String getHashMethod(List<OCInstanceVariableSymbol> ivars, PsiElement context, OCGenerateMethodActionContext actionContext) {
        OCImplementationSymbol classSymbol;
        ArrayList<String> strings = new ArrayList<String>();
        OCObjectType superType = actionContext.getType().getSuperType();
        OCImplementationSymbol oCImplementationSymbol = classSymbol = superType != null ? superType.getImplementation() : null;
        if (classSymbol != null && !classSymbol.processMembersInAllCategories("hash", OCMethodSymbol.class, new CommonProcessors.FindFirstProcessor(), true)) {
            strings.add("[super hash];\n");
        }
        for (OCInstanceVariableSymbol ivar : ivars) {
            OCPropertySymbol property = ivar.getAssociatedProperty();
            OCType type = ivar.getType().resolve(context.getContainingFile(), true);
            OCGenerateIsEqualAndHashHandler.appendHashMember(strings, property != null ? "self." + property.getName() : ivar.getName(), type, context);
        }
        StringBuilder function = new StringBuilder();
        function.append(OCCallableUtil.methodSignature(actionContext.getBaseMethods().get(1), context)).append("{\n");
        if (strings.size() > 1) {
            boolean isFirst = true;
            for (String string : strings) {
                if (isFirst) {
                    function.append("NSUInteger hash = ");
                } else {
                    function.append("hash = hash * 31u + ");
                }
                function.append(string);
                isFirst = false;
            }
            function.append("return hash;\n}\n");
        } else if (strings.size() == 1) {
            function.append("return ").append((String)strings.get(0)).append("}\n");
        } else {
            function.append("return [super hash];}\n");
        }
        return function.toString();
    }

    private static void appendHashMember(final List<String> strings, final String memberName, OCType type, final PsiElement context) {
        if (type.isPointerToObject()) {
            strings.add("[" + memberName + " hash];\n");
        } else if (type == OCRealType.FLOAT) {
            strings.add("[[NSNumber numberWithFloat:" + memberName + "] hash];\n");
        } else if (type instanceof OCRealType) {
            strings.add("[[NSNumber numberWithDouble:" + memberName + "] hash];\n");
        } else if (type instanceof OCIntType) {
            boolean convertToNSUInteger = strings.isEmpty() && (((OCIntType)type).isSigned() || ((OCIntType)type).getRank(context) > OCIntType.UINT.getRank(context));
            strings.add((convertToNSUInteger ? "(NSUInteger)" : "") + memberName + ";\n");
        } else if (type instanceof OCStructType && !type.isScalar()) {
            if (!OCGenerateIsEqualAndHashHandler.processStructFields(type, new Processor<OCDeclaratorSymbol>(){

                public boolean process(OCDeclaratorSymbol field) {
                    OCGenerateIsEqualAndHashHandler.appendHashMember(strings, memberName + "." + field.getName(), field.getResolvedType(), context);
                    return true;
                }
            })) {
                strings.add("(NSUInteger)" + memberName + ";\n");
            }
        } else {
            strings.add("(NSUInteger)" + memberName + ";\n");
        }
    }
}

