/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.generate.actions.OCActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCClassTextActionHandlerBase<P extends OCMembersContainer, M extends OCSymbolWithParent<?, ?>, C extends OCActionContext<P, M>>
extends OCClassActionHandlerBase<P, M, C> {
    protected abstract int getInsertPosition(PsiElement var1, int var2, PsiElement var3, List<M> var4, C var5);

    @Nullable
    protected abstract String getInsertText(PsiElement var1, PsiElement var2, List<M> var3, C var4);

    protected void selectResult(@NotNull PsiFile file2, RangeMarker rangeMarker) {
        Editor editor;
        OCBlockStatement body;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/generate/handlers/OCClassTextActionHandlerBase", "selectResult"));
        }
        PsiElement at = file2.findElementAt(rangeMarker.getStartOffset());
        OCCallable firstMethod = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)at, (Class[])new Class[]{OCCallable.class});
        if (firstMethod != null && (body = firstMethod.getBody()) != null && this.shouldSelectResult(body) && (editor = EditorHelper.openInEditor((PsiElement)file2)) != null) {
            OCCodeInsightUtil.selectBody(editor, body);
        }
    }

    protected boolean shouldSelectResult(OCBlockStatement body) {
        return false;
    }

    @Override
    protected void performAction(Project project, final Editor editor, final PsiFile file2, C actionContext, List<M> chosenCandidates) {
        LinkedList<PsiFile> files = new LinkedList<PsiFile>();
        for (PsiElement element : (List)this.getElementsToModify(actionContext).getFirst()) {
            files.add(element.getContainingFile());
        }
        new WriteCommandAction(project, this.getActionTitle(), PsiUtilCore.toPsiFileArray(files), (OCActionContext)actionContext, project, chosenCandidates){
            final /* synthetic */ OCActionContext val$actionContext;
            final /* synthetic */ Project val$project;
            final /* synthetic */ List val$chosenCandidates;
            {
                this.val$actionContext = oCActionContext;
                this.val$project = project;
                this.val$chosenCandidates = list;
                super(arg0, arg1, arg2);
            }

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/generate/handlers/OCClassTextActionHandlerBase$1", "run"));
                }
                FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.altInsert");
                int caretPos = editor != null ? editor.getCaretModel().getOffset() : -1;
                PsiElement at = null;
                if (editor != null && (at = file2.findElementAt(caretPos)) == null) {
                    at = file2.getLastChild();
                }
                Pair<List<PsiElement>, Integer> pair = OCClassTextActionHandlerBase.this.getElementsToModify(this.val$actionContext);
                List elements = (List)pair.getFirst();
                Integer originalElementIndex = (Integer)pair.getSecond();
                for (PsiElement element : elements) {
                    if (FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) continue;
                    return;
                }
                for (int i = 0; i < elements.size(); ++i) {
                    PsiElement element;
                    element = (PsiElement)elements.get(i);
                    if (!element.isValid()) continue;
                    VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
                    if (virtualFile != null) {
                        CommandProcessor.getInstance().addAffectedFiles(this.val$project, new VirtualFile[]{virtualFile});
                    }
                    if (i == originalElementIndex) {
                        OCClassTextActionHandlerBase.this.performAction(this.val$project, element, caretPos, at, this.val$chosenCandidates, this.val$actionContext);
                        continue;
                    }
                    OCClassTextActionHandlerBase.this.performAction(this.val$project, element, -1, null, this.val$chosenCandidates, this.val$actionContext);
                }
            }
        }.execute();
    }

    protected Pair<List<PsiElement>, Integer> getElementsToModify(C context) {
        int originalElementIndex = -1;
        ArrayList elements = new ArrayList();
        List<OCSymbol> symbols = ((OCActionContext)context).getSymbolsToModify();
        for (int i = 0; i < symbols.size(); ++i) {
            Object declaration;
            OCSymbol symbol = symbols.get(i);
            if (symbol == null || (declaration = symbol.locateDefinition()) == null) continue;
            elements.add(declaration);
            if (!symbol.equals(((OCActionContext)context).getParent())) continue;
            originalElementIndex = i;
        }
        return new Pair(elements, (Object)originalElementIndex);
    }

    protected void performAction(Project project, PsiElement element, int caretPos, @Nullable PsiElement at, List<M> members, C auxInfo) {
        PsiFile file2 = element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        if (document == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        String insertText = this.getInsertText(element, at, members, auxInfo);
        if (insertText == null || insertText.isEmpty()) {
            return;
        }
        int insertOffset = this.getInsertPosition(element, caretPos, at, members, auxInfo);
        if (insertOffset == -1) {
            return;
        }
        RangeMarker rangeMarker = document.createRangeMarker(insertOffset, insertOffset);
        rangeMarker.setGreedyToRight(true);
        document.insertString(insertOffset, (CharSequence)insertText);
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        OCChangeUtil.reformatTextIfNotInjected(file2, rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
        OCImportSymbolFix.fixAllSymbolsRecursively((PsiElement)file2, new TextRange(rangeMarker.getStartOffset(), rangeMarker.getEndOffset()));
        this.selectResult(file2, rangeMarker);
    }
}

