/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCActionContext;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCClassActionHandlerBase<P extends OCMembersContainer, M extends OCSymbolWithParent<?, ?>, C extends OCActionContext<P, M>>
implements LanguageCodeInsightActionHandler {
    public boolean isValidFor(Editor editor, PsiFile file2) {
        C context = this.evaluateActionContext(file2.getProject(), editor, file2);
        return context != null && ((OCActionContext)context).isValid();
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/generate/handlers/OCClassActionHandlerBase", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/generate/handlers/OCClassActionHandlerBase", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        C context = this.evaluateActionContext(project, editor, file2);
        if (this.checkContext(project, editor, context)) {
            this.invoke(project, editor, file2, context);
        }
    }

    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull C context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/generate/handlers/OCClassActionHandlerBase", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/generate/handlers/OCClassActionHandlerBase", "invoke"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/generate/handlers/OCClassActionHandlerBase", "invoke"));
        }
        HashMap<OCOption, Object> defaultCheckboxStates = new HashMap<OCOption, Object>();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class);
        for (Pair<OCOption, Object> pair : this.loadOptions(file2, settings, context)) {
            defaultCheckboxStates.put((OCOption)pair.getFirst(), pair.getSecond());
        }
        ((OCActionContext)context).setOptionValues(defaultCheckboxStates);
        for (OCSymbol symbol : ((OCActionContext)context).getSymbolsToModify()) {
            if (symbol == null || OCSearchScope.isInProjectSources(symbol)) continue;
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"error.out.of.project.element", (Object[])new Object[]{symbol.getNameWithKindLowercase()}), (String)this.getActionTitle(), null);
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)ContainerUtil.mapNotNull(((OCActionContext)context).getSymbolsToModify(), (Function)new Function<OCSymbol, PsiElement>(){

            public PsiElement fun(OCSymbol p) {
                return p != null ? p.getContainingOCFile() : null;
            }
        }))) {
            return;
        }
        M oneCandidate = this.locateCandidate(project, editor, file2);
        List<M> candidates = oneCandidate == null ? new ArrayList(((OCActionContext)context).getMemberCandidates()) : Collections.singletonList(oneCandidate);
        candidates = this.filterCandidates(candidates, this.getCandidatesFilter(context));
        candidates = this.sortCandidates(candidates);
        if (oneCandidate == null && !this.allowEmptySelection(context) && candidates != null && candidates.isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)this.getNoMembersMessage(context), (String)this.getActionTitle(), null);
            return;
        }
        HashSet<M> selectedCandidates = new HashSet<M>(this.getSelectedCandidates(context, editor, file2, candidates));
        selectedCandidates.retainAll(candidates);
        List<M> chosenCandidates = this.chooseCandidates(file2, candidates, selectedCandidates, context, settings);
        if (chosenCandidates != null && (this.allowEmptySelection(context) || !chosenCandidates.isEmpty())) {
            this.performAction(project, editor, file2, context, chosenCandidates);
        }
    }

    protected boolean checkContext(Project project, Editor editor, C context) {
        if (context == null || !((OCActionContext)context).isValid()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Action is invalid for the current selection", (String)this.getActionTitle(), null);
            return false;
        }
        return true;
    }

    protected abstract void performAction(Project var1, Editor var2, PsiFile var3, C var4, List<M> var5);

    @Nullable
    protected P getParent(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/generate/handlers/OCClassActionHandlerBase", "getParent"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/generate/handlers/OCClassActionHandlerBase", "getParent"));
        }
        if (editor == null) {
            return (P)((OCMembersContainer)((Object)((OCFile)file2).getSameNamedClass()));
        }
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        OCSymbolDeclarator parent = (OCSymbolDeclarator)PsiTreeUtil.getContextOfType((PsiElement)at, (Class[])new Class[]{this.getParentClass()});
        return (P)(parent != null ? (OCMembersContainer)parent.getSymbol() : null);
    }

    protected boolean enableChooseDialog(Collection<M> candidates) {
        return true;
    }

    protected List<Pair<OCOption, Object>> loadOptions(PsiFile file2, @Nullable OCCodeStyleSettings settings, @NotNull C context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/generate/handlers/OCClassActionHandlerBase", "loadOptions"));
        }
        return Collections.emptyList();
    }

    protected static <T, Comp extends JComponent> T getOption(Map<OCOption, Object> optionSelections, OCOption<T, Comp> option) {
        return (T)optionSelections.get(option);
    }

    protected <T, Comp extends JComponent> T getOption(C context, OCOption<T, Comp> option) {
        return OCClassActionHandlerBase.getOption(((OCActionContext)context).getOptionValues(), option);
    }

    protected void saveOptions(PsiFile file2, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/cidr/lang/generate/handlers/OCClassActionHandlerBase", "saveOptions"));
        }
    }

    @Nullable
    protected C evaluateActionContext(Project project, @Nullable Editor editor, PsiFile file2) {
        P parent = this.getParent(project, editor, file2);
        PsiElement at = editor != null ? file2.findElementAt(editor.getCaretModel().getOffset()) : null;
        PsiElement element = at != null ? at : file2;
        return parent != null && OCSearchScope.isInProjectSources(parent.getContainingOCFile()) ? (C)this.evaluateActionContext(parent, element) : null;
    }

    @Nullable
    protected abstract C evaluateActionContext(P var1, PsiElement var2);

    protected boolean allowEmptySelection(C context) {
        return false;
    }

    protected boolean allowMultiSelection(C context) {
        return true;
    }

    @Nullable
    public String getActionName() {
        return null;
    }

    @Nullable
    public String getActionDescription() {
        return null;
    }

    protected abstract String getActionTitle();

    protected abstract String getMembersChooserTitle();

    protected abstract Class<? extends OCSymbolDeclarator> getParentClass();

    protected String getNoMembersMessage(C context) {
        return ((OCActionContext)context).getParentNameUppercase() + " has no members to " + StringUtil.decapitalize((String)this.getActionTitle());
    }

    @Nullable
    protected Condition<M> getCandidatesFilter(C actionContext) {
        return null;
    }

    @Nullable
    protected M locateCandidate(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/generate/handlers/OCClassActionHandlerBase", "locateCandidate"));
        }
        return null;
    }

    @NotNull
    protected Collection<M> getSelectedCandidates(C actionContext, @Nullable Editor editor, PsiFile file2, List<M> candidates) {
        OCSymbol symbol;
        if (editor == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/generate/handlers/OCClassActionHandlerBase", "getSelectedCandidates"));
            }
            return list;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            final TextRange selectionRange = new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
            List list = ContainerUtil.filter(candidates, (Condition)new Condition<M>(){

                public boolean value(M m) {
                    Object element = m.locateDefinition();
                    OCSymbol associatedSymbol = m.getAssociatedSymbol();
                    Object associatedElement = associatedSymbol != null ? associatedSymbol.locateDefinition() : null;
                    return element != null && selectionRange.contains(element.getTextRange()) || associatedElement != null && selectionRange.contains(associatedElement.getTextRange());
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/generate/handlers/OCClassActionHandlerBase", "getSelectedCandidates"));
            }
            return list;
        }
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        OCSymbolDeclarator declarator = (OCSymbolDeclarator)PsiTreeUtil.getParentOfType((PsiElement)at, OCSymbolDeclarator.class);
        if (declarator instanceof OCMethodSelectorPart) {
            declarator = (OCMethod)declarator.getParent();
        }
        OCSymbol oCSymbol = symbol = declarator != null ? (OCSymbol)declarator.getSymbol() : null;
        if (symbol != null) {
            if (candidates.contains(symbol)) {
                List<OCSymbolWithParent> list = Collections.singletonList((OCSymbolWithParent)symbol);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/generate/handlers/OCClassActionHandlerBase", "getSelectedCandidates"));
                }
                return list;
            }
            if ((symbol = symbol.getAssociatedSymbol()) != null && candidates.contains(symbol)) {
                List<OCSymbolWithParent> list = Collections.singletonList((OCSymbolWithParent)symbol);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/generate/handlers/OCClassActionHandlerBase", "getSelectedCandidates"));
                }
                return list;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/generate/handlers/OCClassActionHandlerBase", "getSelectedCandidates"));
        }
        return list;
    }

    @Nullable
    private List<M> filterCandidates(List<M> candidates, Condition<M> filter) {
        if (candidates == null) {
            return candidates;
        }
        ArrayList<OCSymbolWithParent> result2 = new ArrayList<OCSymbolWithParent>(candidates.size());
        HashSet<OCSymbolWithParent> set = new HashSet<OCSymbolWithParent>();
        for (OCSymbolWithParent elem : candidates) {
            if (set.contains(elem) || filter != null && !filter.value((Object)elem)) continue;
            result2.add(elem);
            set.add(elem);
        }
        return result2;
    }

    @Nullable
    private List<M> sortCandidates(List<M> candidates) {
        if (candidates == null) {
            return candidates;
        }
        ArrayList<M> result2 = new ArrayList<M>(candidates);
        final HashMap<M, Integer> originalOrder = new HashMap<M, Integer>();
        for (int i = 0; i < candidates.size(); ++i) {
            originalOrder.put(candidates.get(i), i);
        }
        Collections.sort(result2, new Comparator<OCSymbolWithParent>(){

            @Override
            public int compare(OCSymbolWithParent symbol1, OCSymbolWithParent symbol2) {
                if (symbol1.getParent() != symbol2.getParent()) {
                    return (Integer)originalOrder.get(symbol1) - (Integer)originalOrder.get(symbol2);
                }
                if (symbol1 instanceof OCInstanceVariableSymbol && symbol1.isSynthetic()) {
                    symbol1 = ((OCInstanceVariableSymbol)symbol1).getAssociatedProperty();
                }
                if (symbol2 instanceof OCInstanceVariableSymbol && symbol2.isSynthetic()) {
                    symbol2 = ((OCInstanceVariableSymbol)symbol2).getAssociatedProperty();
                }
                if (symbol1 == null || symbol2 == null) {
                    return 0;
                }
                int result2 = symbol1.getOffset() - symbol2.getOffset();
                if (result2 == 0 && symbol1 instanceof OCMethodSymbol && symbol2 instanceof OCMethodSymbol) {
                    return (((OCMethodSymbol)symbol1).isSetter() ? 1 : 0) - (((OCMethodSymbol)symbol2).isSetter() ? 1 : 0);
                }
                return result2;
            }
        });
        return result2;
    }

    @Nullable
    private List<M> chooseCandidates(PsiFile file2, final List<M> candidates, Set<M> selectedCandidates, @NotNull C actionContext, OCCodeStyleSettings settings) {
        if (actionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionContext", "com/jetbrains/cidr/lang/generate/handlers/OCClassActionHandlerBase", "chooseCandidates"));
        }
        Project project = file2.getProject();
        if (candidates == null) {
            return null;
        }
        if (!this.enableChooseDialog(candidates) || candidates.isEmpty() && this.allowEmptySelection(actionContext)) {
            ArrayList<M> list = new ArrayList<M>(candidates);
            if (!selectedCandidates.isEmpty()) {
                list.retainAll(selectedCandidates);
            }
            return this.sortCandidates(list);
        }
        if (selectedCandidates.isEmpty() && ApplicationManager.getApplication().isUnitTestMode()) {
            selectedCandidates = new HashSet<M>(candidates);
        }
        List<Pair<OCOption, Object>> options = this.loadOptions(file2, settings, actionContext);
        final OCMemberChooser chooser = this.createMemberChooser(project, options, actionContext, candidates);
        chooser.setTitle(this.getMembersChooserTitle());
        ClassMember[] nodes = this.getChooserNodes(chooser, candidates, actionContext, 0);
        for (int i = 0; nodes.length == 0 && i < options.size(); ++i) {
            nodes = this.getChooserNodes(chooser, candidates, actionContext, i + 1);
        }
        chooser.resetElements(nodes);
        ArrayList<ClassMember> selectedList = new ArrayList<ClassMember>(selectedCandidates.size());
        for (ClassMember node : nodes) {
            if (!selectedCandidates.contains(node.getSymbol())) continue;
            selectedList.add(node);
        }
        chooser.selectElements(selectedList.toArray(new OCMemberChooserObject[selectedList.size()]));
        JComponent[] optionControls = chooser.getOptionControls();
        for (int i = 0; i < optionControls.length; ++i) {
            final OCOption option = (OCOption)options.get(i).getFirst();
            option.addItemListener(optionControls[i], new ItemListener((OCActionContext)actionContext){
                final /* synthetic */ OCActionContext val$actionContext;
                {
                    this.val$actionContext = oCActionContext;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    OCClassActionHandlerBase.this.optionValueChanged(chooser, candidates, option, this.val$actionContext);
                }
            });
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return null;
            }
        } else {
            Disposer.dispose((Disposable)chooser.getDisposable());
        }
        ArrayList<OCSymbolWithParent> selectedMembers = new ArrayList<OCSymbolWithParent>();
        List<OCMemberChooserObject> selection = chooser.getChosenElements();
        if (selection != null) {
            for (OCMemberChooserObject object : selection) {
                selectedMembers.add((OCSymbolWithParent)object.getSymbol());
            }
        } else if (!this.allowEmptySelection(actionContext)) {
            return null;
        }
        Map<OCOption, Object> checkboxSelections = chooser.getOptionSelections();
        if (settings != null) {
            this.saveOptions(file2, settings, checkboxSelections);
        }
        ((OCActionContext)actionContext).setOptionValues(checkboxSelections);
        return selectedMembers;
    }

    protected OCMemberChooser createMemberChooser(Project project, List<Pair<OCOption, Object>> options, C actionContext, List<M> candidates) {
        return new OCMemberChooser(new OCMemberChooserObject[0], this.allowEmptySelection(actionContext), this.allowMultiSelection(actionContext), options, null, project);
    }

    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<M> candidates, C actionContext, int moreNodesLevel) {
        final Map<OCSymbol, OCSymbol> parentsMap = ((OCActionContext)actionContext).createParentsMap(candidates);
        return (OCMemberChooserObject[])ContainerUtil.map2Array(candidates, OCMemberChooserObject.class, (Function)new Function<M, OCMemberChooserObject>(){

            public OCMemberChooserObject fun(M m) {
                return new OCMemberChooserObject((OCSymbol)m, parentsMap);
            }
        });
    }

    protected void optionValueChanged(OCMemberChooser chooser, Collection<M> candidates, OCOption option, C actionContext) {
    }

    public boolean startInWriteAction() {
        return false;
    }
}

