/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.treeStructure.Tree;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.handlers.OCDeclareMembersHandler;
import com.jetbrains.cidr.lang.settings.OCOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class OCCheckboxMemberChooser
extends OCMemberChooser {
    private List<OCMemberChooserObject> myChosenElements = new ArrayList<OCMemberChooserObject>();

    public OCCheckboxMemberChooser(OCMemberChooserObject[] elements, List<Pair<OCOption, Object>> options, Project project, boolean allowEmptySelection, boolean allowMultiSelection, OCDeclareMembersHandler.MemberChooserHeaderPanel headerPanel) {
        super(elements, allowEmptySelection, allowMultiSelection, options, (JComponent)headerPanel, project);
    }

    @Override
    protected Tree createTree() {
        return new CheckboxTree(this.getTreeCellRenderer(), new CheckedTreeNode(null));
    }

    @Override
    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/generate/OCCheckboxMemberChooser", "createActions"));
        }
        return actionArray;
    }

    @Override
    public List<OCMemberChooserObject> getChosenElements() {
        return new ArrayList<OCMemberChooserObject>(this.myChosenElements);
    }

    protected CheckboxTree.CheckboxTreeCellRenderer getTreeCellRenderer() {
        return new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof MemberChooser.ElementNode) {
                    boolean enabled = OCCheckboxMemberChooser.this.isMemberEnabled((OCMemberChooserObject)((MemberChooser.ElementNode)value).getDelegate());
                    if (value instanceof MyMemberNode) {
                        this.myCheckbox.setEnabled(enabled);
                    }
                    this.getTextRenderer().setEnabled(enabled);
                    ((MemberChooser.ElementNode)value).getDelegate().renderTreeNode((SimpleColoredComponent)this.getTextRenderer(), tree);
                }
            }
        };
    }

    protected boolean isMemberEnabled(OCMemberChooserObject member) {
        return true;
    }

    public void refreshChosenMembers() {
        this.myChosenElements.clear();
        ArrayList nodes = new ArrayList(this.myNodeToParentMap.keySet());
        Collections.sort(nodes, new MemberChooser.OrderComparator());
        for (MemberChooser.MemberNode node : nodes) {
            MyMemberNode memberNode = (MyMemberNode)node;
            if (!memberNode.isChecked() || !this.isMemberEnabled(memberNode.getDelegate())) continue;
            this.myChosenElements.add(memberNode.getDelegate());
        }
        this.setOKActionEnabled(this.myAllowEmptySelection || !this.myChosenElements.isEmpty());
    }

    @Override
    public void selectElements(ClassMember[] elements) {
        super.selectElements(elements);
        for (ClassMember element : elements) {
            MemberChooser.MemberNode treeNode = (MemberChooser.MemberNode)this.myElementToNodeMap.get((Object)element);
            if (!(treeNode instanceof MyMemberNode)) continue;
            ((MyMemberNode)treeNode).setChecked(true);
        }
    }

    @Override
    protected MemberChooser.MemberNode createMemberNode(Ref<Integer> count, OCMemberChooserObject object, MemberChooser.ParentNode parentNode) {
        return new MyMemberNode(count, object, parentNode);
    }

    public void resetElements(OCMemberChooserObject[] elements) {
        super.resetElements((ClassMember[])elements);
        this.setOKActionEnabled(this.myAllowEmptySelection || this.myChosenElements != null && !this.myChosenElements.isEmpty());
    }

    private class MyMemberNode
    extends CheckedTreeNode
    implements MemberChooser.MemberNode {
        private MemberChooser.MemberNodeImpl myDelegate;

        public MyMemberNode(Ref<Integer> count, OCMemberChooserObject object, MemberChooser.ParentNode parentNode) {
            super(null);
            this.myDelegate = new MemberChooser.MemberNodeImpl(null, object, count);
            super.setChecked(false);
            if (parentNode != null) {
                parentNode.add(this);
            }
        }

        public OCMemberChooserObject getDelegate() {
            return (OCMemberChooserObject)this.myDelegate.getDelegate();
        }

        @Override
        public int getOrder() {
            return this.myDelegate.getOrder();
        }

        public void setChecked(boolean checked) {
            if (OCCheckboxMemberChooser.this.isMemberEnabled((OCMemberChooserObject)this.myDelegate.getDelegate())) {
                super.setChecked(checked);
                OCCheckboxMemberChooser.this.refreshChosenMembers();
            }
        }
    }
}

