/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class OCPreprocessorFormatterData {
    public int directiveNestLevel = 0;
    public ArrayList<OCIndentInfo> directiveIndent = new ArrayList();

    @NotNull
    public OCIndentInfo getIndentAtLevel() {
        assert (this.directiveNestLevel >= 0 && this.directiveNestLevel < this.directiveIndent.size());
        OCIndentInfo oCIndentInfo = this.directiveIndent.get(this.directiveNestLevel);
        if (oCIndentInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCPreprocessorFormatterData", "getIndentAtLevel"));
        }
        return oCIndentInfo;
    }

    public void setIndentAtLevel(OCIndentInfo indents) {
        assert (this.directiveNestLevel >= 0);
        if (this.directiveNestLevel >= this.directiveIndent.size()) {
            this.directiveIndent.add(this.directiveNestLevel, indents);
        } else {
            this.directiveIndent.set(this.directiveNestLevel, indents);
        }
    }

    public Pair<OffsetType, Integer> getIndents(IElementType tokenType, OCCodeStyleSettings ocCodeStyleSettings, boolean fromFirst) {
        OCIndentInfo level;
        OffsetType baseIndent = null;
        Integer curIndent = 0;
        int ifNestLevel = 0;
        if (OCTokenTypes.END_IF_DIRECTIVES.contains(tokenType)) {
            --this.directiveNestLevel;
            if (this.directiveNestLevel < 0) {
                this.directiveNestLevel = 0;
            } else {
                level = this.getIndentAtLevel();
                baseIndent = level.baseIndent;
                curIndent = level.ifIndent;
                ifNestLevel = level.ifNestLevel;
            }
        }
        if (baseIndent == null) {
            if (ocCodeStyleSettings.KEEP_DIRECTIVE_AT_FIRST_COLUMN && fromFirst) {
                baseIndent = OffsetType.DIRECTIVE_ABSOLUTE;
                ifNestLevel = this.directiveNestLevel;
            } else if (this.directiveNestLevel == 0) {
                baseIndent = ocCodeStyleSettings.INDENT_DIRECTIVE_AS_CODE ? OffsetType.DIRECTIVE_RELATIVE_CODE : OffsetType.DIRECTIVE_ABSOLUTE;
                ifNestLevel = 0;
                curIndent = (this.directiveNestLevel - ifNestLevel) * ocCodeStyleSettings.INDENT_PREPROCESSOR_DIRECTIVE;
            } else {
                --this.directiveNestLevel;
                level = this.getIndentAtLevel();
                baseIndent = level.baseIndent;
                ifNestLevel = level.ifNestLevel;
                ++this.directiveNestLevel;
                curIndent = level.ifIndent + ocCodeStyleSettings.INDENT_PREPROCESSOR_DIRECTIVE;
            }
        }
        if (OCFormatterUtil.FORMAT_DIRECTIVES_INCREASE_INDENT.contains(tokenType)) {
            this.setIndentAtLevel(new OCIndentInfo(baseIndent, curIndent, ifNestLevel));
            ++this.directiveNestLevel;
        }
        return Pair.pair((Object)((Object)baseIndent), (Object)curIndent);
    }

    public static class OCIndentInfo {
        @NotNull
        public final OffsetType baseIndent;
        @NotNull
        public final Integer ifIndent;
        public final int ifNestLevel;

        public OCIndentInfo(@NotNull OffsetType baseIndent, @NotNull Integer ifIndent, int ifNestLevel) {
            if (baseIndent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseIndent", "com/jetbrains/cidr/lang/formatting/OCPreprocessorFormatterData$OCIndentInfo", "<init>"));
            }
            if (ifIndent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifIndent", "com/jetbrains/cidr/lang/formatting/OCPreprocessorFormatterData$OCIndentInfo", "<init>"));
            }
            this.baseIndent = baseIndent;
            this.ifIndent = ifIndent;
            this.ifNestLevel = ifNestLevel;
        }
    }

    public static enum OffsetType {
        CODE_RELATIVE_PREV,
        CODE_AS_IS,
        DIRECTIVE_RELATIVE_CODE,
        DIRECTIVE_ABSOLUTE;

    }
}

