/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCPreFormatProcessor
implements PreFormatProcessor {
    @Override
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        PsiFile file2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/formatting/OCPreFormatProcessor", "process"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/cidr/lang/formatting/OCPreFormatProcessor", "process"));
        }
        PsiElement psiElement = element.getPsi();
        if (psiElement == null) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCPreFormatProcessor", "process"));
            }
            return textRange;
        }
        if (psiElement.getLanguage() != OCLanguage.getInstance()) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCPreFormatProcessor", "process"));
            }
            return textRange;
        }
        PsiFile psiFile = file2 = psiElement.isValid() ? psiElement.getContainingFile() : null;
        if (file2 == null) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCPreFormatProcessor", "process"));
            }
            return textRange;
        }
        TextRange textRange = TextRange.create((int)OCPreFormatProcessor.expandRange(file2, range.getStartOffset(), true), (int)OCPreFormatProcessor.expandRange(file2, range.getEndOffset(), false));
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCPreFormatProcessor", "process"));
        }
        return textRange;
    }

    private static int expandRange(PsiFile file2, int offset, boolean start) {
        PsiElement curr = file2.findElementAt(start ? offset : offset - 1);
        if (curr == null) {
            return offset;
        }
        if (OCElementUtil.getElementType(curr) == OCTokenTypes.BLOCK_COMMENT) {
            offset = start ? curr.getTextOffset() : curr.getTextRange().getEndOffset();
        } else {
            if (!(curr instanceof OCMessageArgument)) {
                OCMessageArgument oCMessageArgument = curr = start ? (OCMessageArgument)PsiTreeUtil.getPrevSiblingOfType((PsiElement)curr, OCMessageArgument.class) : (OCMessageArgument)PsiTreeUtil.getNextSiblingOfType((PsiElement)curr, OCMessageArgument.class);
            }
            while (curr != null) {
                PsiElement prevNext;
                PsiElement psiElement = prevNext = start ? curr.getPrevSibling() : curr.getNextSibling();
                if (prevNext != null) {
                    offset = prevNext.getTextOffset();
                }
                curr = prevNext;
            }
        }
        return offset;
    }
}

