/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCEmptyStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class OCPostFormatVisitor
extends OCRecursiveVisitor {
    private final CommonCodeStyleSettings mySettings;
    private final PostFormatProcessorHelper myHelper;
    private boolean myReformat;

    public OCPostFormatVisitor(CodeStyleSettings settings) {
        this.mySettings = settings.getCommonSettings((Language)OCLanguage.getInstance());
        this.myHelper = new PostFormatProcessorHelper((CommonCodeStyleSettings)settings);
    }

    @Override
    public void visitElement(PsiElement element) {
        ProgressIndicatorProvider.checkCanceled();
        PsiElement child = element.getFirstChild();
        while (child != null) {
            PsiElement next = child.getNextSibling();
            if (this.myHelper.isElementPartlyInRange(child)) {
                child.accept((PsiElementVisitor)this);
            }
            child = next;
        }
    }

    public PsiElement process(PsiElement element) {
        element.accept((PsiElementVisitor)this);
        return element;
    }

    public TextRange process(PsiFile element, TextRange range) {
        this.myHelper.setResultTextRange(range);
        element.accept((PsiElementVisitor)this);
        range = this.myHelper.getResultTextRange();
        if (this.myReformat) {
            CodeStyleManager.getInstance((Project)element.getProject()).reformatRange((PsiElement)element.getContainingFile(), range.getStartOffset(), range.getEndOffset(), true);
        }
        return range;
    }

    @Override
    public void visitIfStatement(OCIfStatement stmt) {
        super.visitIfStatement(stmt);
        this.doProcess(stmt, stmt.getThenBranch(), this.mySettings.IF_BRACE_FORCE);
        OCStatement elseStmt = stmt.getElseBranch();
        if (!this.mySettings.SPECIAL_ELSE_IF_TREATMENT || !(elseStmt instanceof OCIfStatement)) {
            this.doProcess(stmt, elseStmt, this.mySettings.IF_BRACE_FORCE);
        }
    }

    @Override
    public void visitForStatement(OCForStatement stmt) {
        super.visitForStatement(stmt);
        this.doProcess(stmt, stmt.getBody(), this.mySettings.FOR_BRACE_FORCE);
    }

    @Override
    public void visitForeachStatement(OCForeachStatement stmt) {
        super.visitForeachStatement(stmt);
        this.doProcess(stmt, stmt.getBody(), this.mySettings.FOR_BRACE_FORCE);
    }

    @Override
    public void visitWhileStatement(OCWhileStatement stmt) {
        super.visitWhileStatement(stmt);
        this.doProcess(stmt, stmt.getBody(), this.mySettings.WHILE_BRACE_FORCE);
    }

    @Override
    public void visitDoWhileStatement(OCDoWhileStatement stmt) {
        super.visitDoWhileStatement(stmt);
        this.doProcess(stmt, stmt.getBody(), this.mySettings.DOWHILE_BRACE_FORCE);
    }

    private void doProcess(OCStatement parent, OCStatement statement, int option) {
        if (statement == null || statement instanceof OCBlockStatement) {
            return;
        }
        if (!this.myHelper.isElementFullyInRange(statement)) {
            return;
        }
        if (option == 3 || option == 1 && PostFormatProcessorHelper.isMultiline(parent)) {
            this.replaceWithBlock(parent, statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceWithBlock(@NotNull OCStatement parent, @NotNull PsiElement statementToWrap) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/cidr/lang/formatting/OCPostFormatVisitor", "replaceWithBlock"));
        }
        if (statementToWrap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementToWrap", "com/jetbrains/cidr/lang/formatting/OCPostFormatVisitor", "replaceWithBlock"));
        }
        LeafElement firstLeaf = TreeUtil.findFirstLeaf(statementToWrap.getNode());
        if (firstLeaf instanceof ForeignLeafPsiElement) {
            return;
        }
        String oldText = statementToWrap instanceof OCEmptyStatement ? "" : statementToWrap.getText();
        SmartList toRemove = new SmartList();
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        builder.append('{');
        OCPostFormatVisitor.collectSiblings(true, statementToWrap, (SmartList<PsiElement>)toRemove, builder);
        builder.append(oldText);
        OCPostFormatVisitor.collectSiblings(false, statementToWrap, (SmartList<PsiElement>)toRemove, builder);
        builder.append("}");
        String text = builder.toString();
        StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        PsiElement context = statementToWrap.getContext();
        if (context == null) {
            return;
        }
        OCStatement replacement = OCElementFactory.statementFromText(text, context);
        if (replacement == null) {
            return;
        }
        OCElementFactory.initIndentFromContext(context, replacement);
        int oldParentTextLength = parent.getTextLength();
        try {
            ASTNode parentNode = SourceTreeToPsiMap.psiElementToTree(parent);
            for (PsiElement each : toRemove) {
                parentNode.removeChild(SourceTreeToPsiMap.psiElementToTree(each));
            }
            CodeEditUtil.replaceChild(parentNode, SourceTreeToPsiMap.psiElementToTree(statementToWrap), SourceTreeToPsiMap.psiElementToTree(replacement));
            this.myReformat = true;
        }
        finally {
            this.myHelper.updateResultRange(oldParentTextLength, parent.getTextLength());
        }
    }

    private static void collectSiblings(boolean before, PsiElement statement, SmartList<PsiElement> toRemove, StringBuilder builder) {
        PsiElement sibling;
        ArrayList<String> strings = new ArrayList<String>();
        PsiElement psiElement = sibling = before ? statement.getPrevSibling() : statement.getNextSibling();
        while (sibling != null && OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(sibling))) {
            strings.add(sibling.getText());
            toRemove.add((Object)sibling);
            sibling = before ? sibling.getPrevSibling() : sibling.getNextSibling();
        }
        for (String string : before ? ContainerUtil.iterateBackward(strings) : strings) {
            builder.append(string);
        }
    }
}

