/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.formatting.OCFormatterInfo;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.formatting.OCGlobalFormatterData;
import com.jetbrains.cidr.lang.formatting.OCIndentChanger;
import com.jetbrains.cidr.lang.formatting.OCLocalFormatterData;
import com.jetbrains.cidr.lang.formatting.OCMacroBlock;
import com.jetbrains.cidr.lang.formatting.OCMultilineNodeFormatter;
import com.jetbrains.cidr.lang.formatting.OCNormalIndentBlock;
import com.jetbrains.cidr.lang.formatting.OCPreprocessorFormatterData;
import com.jetbrains.cidr.lang.formatting.OCRecursiveBlockTransformer;
import com.jetbrains.cidr.lang.formatting.OCSimpleBlock;
import com.jetbrains.cidr.lang.formatting.OCSpacingProcessor;
import com.jetbrains.cidr.lang.formatting.OCWrappingProcessor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCParsing;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCodeBlock
extends AbstractBlock
implements OCIndentChanger {
    @NotNull
    protected final CommonCodeStyleSettings mySettings;
    @NotNull
    protected final OCCodeStyleSettings myOCSettings;
    @NotNull
    protected final Project myProject;
    @NotNull
    private final OCGlobalFormatterData myGlobalFormatterData;
    @NotNull
    private final OCLocalFormatterData myLocalFormatterData;
    protected Indent myIndent;
    protected Indent myBracesIndent;
    protected Indent myChildIndent;
    protected Indent myChildIndentEx;
    private final boolean myInDirective;
    private final boolean myIsRecursive;
    protected TextRange myTextRange;
    private static final TokenSet COMMA_OR_EXPRESSION = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.COMMA}), OCElementTypes.EXPRESSIONS});

    public OCCodeBlock(@NotNull PsiFile file2, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "<init>"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "<init>"));
        }
        this(null, settings.getCommonSettings((Language)OCLanguage.getInstance()), (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class), file2.getProject(), (ASTNode)file2.getNode(), new OCGlobalFormatterData(file2, mode), Indent.getAbsoluteNoneIndent(), Indent.getNoneIndent(), null, null);
    }

    public OCCodeBlock(@Nullable OCCodeBlock parent, @NotNull CommonCodeStyleSettings settings, @NotNull OCCodeStyleSettings ocSettings, @NotNull Project project, @NotNull ASTNode node, @NotNull OCGlobalFormatterData globalFormatterData, @Nullable Indent indent, @Nullable Indent childIndent, @Nullable Wrap wrap, @Nullable Alignment alignment) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "<init>"));
        }
        if (ocSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ocSettings", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "<init>"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "<init>"));
        }
        if (globalFormatterData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalFormatterData", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "<init>"));
        }
        super(node, wrap, alignment);
        final IElementType nodeType = this.myNode.getElementType();
        this.myInDirective = parent != null && parent.myInDirective || OCElementTypes.DIRECTIVES.contains(nodeType);
        this.myTextRange = null;
        this.mySettings = settings;
        this.myOCSettings = ocSettings;
        this.myProject = project;
        this.myIndent = indent;
        this.myBracesIndent = Indent.getNoneIndent();
        this.myChildIndentEx = this.myChildIndent = childIndent;
        if (OCElementTypes.CLASSES.contains(nodeType)) {
            this.myChildIndentEx = OCCodeBlock.getSpaceIndentEnforcedToChildren(this.myOCSettings.INDENT_VISIBILITY_KEYWORDS);
        }
        this.myGlobalFormatterData = globalFormatterData;
        this.myLocalFormatterData = OCFormatterInfo.createData(parent == null ? null : parent.myLocalFormatterData, nodeType);
        OCFormatterUtil.processBraced(this.myNode.getTreeParent(), nodeType, false, new OCFormatterUtil.LeftBracesProcessor<Object>(){

            @Override
            public Object processNamespace() {
                switch (OCCodeBlock.this.myOCSettings.NAMESPACE_BRACE_PLACEMENT) {
                    case 3: {
                        OCCodeBlock.this.myBracesIndent = Indent.getNormalIndent();
                        OCCodeBlock.this.myChildIndent = OCCodeBlock.getSpaceIndentEnforcedToChildren(OCCodeBlock.this.mySettings.getIndentOptions().INDENT_SIZE + OCCodeBlock.this.myOCSettings.INDENT_NAMESPACE_MEMBERS);
                        break;
                    }
                    case 4: {
                        OCCodeBlock.this.myBracesIndent = Indent.getNormalIndent();
                        OCCodeBlock.this.myChildIndent = OCCodeBlock.getSpaceIndentEnforcedToChildren(OCCodeBlock.this.mySettings.getIndentOptions().INDENT_SIZE * 2 + OCCodeBlock.this.myOCSettings.INDENT_NAMESPACE_MEMBERS);
                        break;
                    }
                    default: {
                        OCCodeBlock.this.myChildIndent = OCCodeBlock.getSpaceIndentEnforcedToChildren(OCCodeBlock.this.myOCSettings.INDENT_NAMESPACE_MEMBERS);
                    }
                }
                return null;
            }

            @Override
            public Object processInterfaceOrStructure() {
                return OCFormatterUtil.isStructure(nodeType) ? this.calcIndentsInClass(this.isPlainStruct(OCCodeBlock.this.myNode) ? OCCodeBlock.this.myOCSettings.INDENT_C_STRUCT_MEMBERS : OCCodeBlock.this.myOCSettings.INDENT_CLASS_MEMBERS) : this.calcIndents(OCCodeBlock.this.mySettings.CLASS_BRACE_STYLE);
            }

            private boolean isPlainStruct(@NotNull ASTNode struct) {
                if (struct == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "struct", "com/jetbrains/cidr/lang/formatting/OCCodeBlock$1", "isPlainStruct"));
                }
                return struct.findChildByType((IElementType)OCTokenTypes.CLASS_KEYWORD) == null && struct.findChildByType(OCTokenTypes.CPP_VISIBILITY_KEYWORDS) == null;
            }

            @Override
            public Object processMethod() {
                return this.calcIndents(OCCodeBlock.this.myOCSettings.METHOD_BRACE_PLACEMENT);
            }

            @Override
            public Object processFunction() {
                return this.calcIndents(OCCodeBlock.this.myOCSettings.FUNCTION_BRACE_PLACEMENT);
            }

            @Override
            public Object processBlock() {
                switch (OCCodeBlock.this.myOCSettings.BLOCK_BRACE_PLACEMENT) {
                    case 3: {
                        OCCodeBlock.this.myBracesIndent = Indent.getNormalIndent();
                        OCCodeBlock.this.myChildIndent = Indent.getSpaceIndent((int)OCCodeBlock.this.myOCSettings.INDENT_INSIDE_CODE_BLOCK);
                        break;
                    }
                    case 4: {
                        OCCodeBlock.this.myBracesIndent = Indent.getNormalIndent();
                        OCCodeBlock.this.myChildIndent = Indent.getSpaceIndent((int)(OCCodeBlock.this.mySettings.getIndentOptions().INDENT_SIZE + OCCodeBlock.this.myOCSettings.INDENT_INSIDE_CODE_BLOCK));
                        break;
                    }
                    default: {
                        OCCodeBlock.this.myChildIndent = Indent.getSpaceIndent((int)OCCodeBlock.this.myOCSettings.INDENT_INSIDE_CODE_BLOCK);
                    }
                }
                return null;
            }

            @Override
            public Object processGeneral() {
                return this.calcIndents(OCCodeBlock.this.mySettings.BRACE_STYLE);
            }

            private Object calcIndents(int placement) {
                switch (placement) {
                    case 3: {
                        OCCodeBlock.this.myBracesIndent = OCCodeBlock.this.myChildIndent = Indent.getNormalIndent();
                        OCCodeBlock.this.myChildIndentEx = OCCodeBlock.getSpaceIndentEnforcedToChildren(OCCodeBlock.this.myOCSettings.INDENT_VISIBILITY_KEYWORDS);
                        break;
                    }
                    case 4: {
                        OCCodeBlock.this.myBracesIndent = Indent.getNormalIndent();
                        OCCodeBlock.this.myChildIndent = OCCodeBlock.getDoubleIndent(OCCodeBlock.this.mySettings);
                        OCCodeBlock.this.myChildIndentEx = OCCodeBlock.getSpaceIndentEnforcedToChildren(OCCodeBlock.this.mySettings.getIndentOptions().INDENT_SIZE + OCCodeBlock.this.myOCSettings.INDENT_VISIBILITY_KEYWORDS);
                        break;
                    }
                    default: {
                        OCCodeBlock.this.myChildIndentEx = OCCodeBlock.getSpaceIndentEnforcedToChildren(OCCodeBlock.this.myOCSettings.INDENT_VISIBILITY_KEYWORDS);
                    }
                }
                return null;
            }

            private Object calcIndentsInClass(int baseIndent) {
                switch (OCCodeBlock.this.mySettings.CLASS_BRACE_STYLE) {
                    case 3: {
                        OCCodeBlock.this.myBracesIndent = OCCodeBlock.this.myChildIndent = OCCodeBlock.getSpaceIndentEnforcedToChildren(baseIndent);
                        OCCodeBlock.this.myChildIndentEx = OCCodeBlock.getSpaceIndentEnforcedToChildren(OCCodeBlock.this.myOCSettings.INDENT_VISIBILITY_KEYWORDS);
                        break;
                    }
                    case 4: {
                        OCCodeBlock.this.myBracesIndent = OCCodeBlock.getSpaceIndentEnforcedToChildren(baseIndent);
                        OCCodeBlock.this.myChildIndent = OCCodeBlock.getSpaceIndentEnforcedToChildren(baseIndent * 2);
                        OCCodeBlock.this.myChildIndentEx = OCCodeBlock.getSpaceIndentEnforcedToChildren(baseIndent + OCCodeBlock.this.myOCSettings.INDENT_VISIBILITY_KEYWORDS);
                        break;
                    }
                    default: {
                        OCCodeBlock.this.myChildIndent = OCCodeBlock.getSpaceIndentEnforcedToChildren(baseIndent);
                        OCCodeBlock.this.myChildIndentEx = OCCodeBlock.getSpaceIndentEnforcedToChildren(OCCodeBlock.this.myOCSettings.INDENT_VISIBILITY_KEYWORDS);
                    }
                }
                return null;
            }
        });
        this.myIsRecursive = this.needBuildSubBlocks();
        if (this.myIsRecursive) {
            this.getSubBlocks();
        }
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        if (this.myTextRange == null) {
            this.myTextRange = this.myNode instanceof LeafElement || this.myNode instanceof FileASTNode || !this.myIsRecursive ? super.getTextRange() : OCSimpleBlock.getRangeFromSubBlocks((Block)this);
        }
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "getTextRange"));
        }
        return textRange;
    }

    @Override
    public String toString() {
        return OCSimpleBlock.getTextFromRange(this.getNode(), this.getTextRange());
    }

    @Override
    protected List<Block> buildChildren() {
        if (this.isLeaf()) {
            return EMPTY;
        }
        OCWrappingProcessor wrappingCalculator = new OCWrappingProcessor(this.mySettings, this.myOCSettings, this.myNode, this.myLocalFormatterData);
        SmartList ownerBlocks = new SmartList();
        this.checkMacroNode((List<Block>)ownerBlocks, wrappingCalculator);
        for (ASTNode each = this.myNode.getFirstChildNode(); each != null && !this.myGlobalFormatterData.skipNodeSet.contains((Object)each); each = each.getTreeNext()) {
            if (OCCodeBlock.needCoverByBlock(each)) {
                this.extendBlockCollectionByNode((List<Block>)ownerBlocks, each, wrappingCalculator);
                this.checkMacroNode((List<Block>)ownerBlocks, wrappingCalculator);
            }
            if (!OCParsing.isEOFError(each) || this.myGlobalFormatterData.isEOF) continue;
            this.myGlobalFormatterData.isEOF = true;
            this.collectTailComments((List<Block>)ownerBlocks, each, wrappingCalculator);
        }
        return this.postProcessBlockCollection((List<Block>)ownerBlocks, wrappingCalculator);
    }

    private static boolean needCoverByBlock(ASTNode node) {
        return !(node instanceof PsiWhiteSpace) && !(node instanceof OCMacroForeignLeafElement);
    }

    private void collectTailComments(@NotNull List<Block> ownerBlocks, @NotNull ASTNode eofError, @NotNull OCWrappingProcessor ownerWrappingCalculator) {
        if (ownerBlocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerBlocks", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "collectTailComments"));
        }
        if (eofError == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eofError", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "collectTailComments"));
        }
        if (ownerWrappingCalculator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerWrappingCalculator", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "collectTailComments"));
        }
        ASTNode eofErrorTopOwner = eofError.getTreeParent();
        while (eofErrorTopOwner.getTreeParent().getTreeParent() != null) {
            eofErrorTopOwner = eofErrorTopOwner.getTreeParent();
        }
        for (ASTNode tailNode = eofErrorTopOwner.getTreeNext(); tailNode != null; tailNode = tailNode.getTreeNext()) {
            this.myGlobalFormatterData.skipNodeSet.add((Object)tailNode);
            if (!OCCodeBlock.needCoverByBlock(tailNode)) continue;
            this.extendBlockCollectionByNode(ownerBlocks, tailNode, ownerWrappingCalculator);
        }
    }

    private void checkMacroNode(final List<Block> ownerBlocks, final OCWrappingProcessor wrappingCalculator) {
        this.myGlobalFormatterData.movedBlockMap.processForKey((Object)this.myNode, (Processor)new Processor<OCCodeBlock>(){

            public boolean process(OCCodeBlock movedBlock) {
                ownerBlocks.add(OCCodeBlock.this.wrapBlock(wrappingCalculator, movedBlock));
                return true;
            }
        });
        this.myGlobalFormatterData.movedBlockMap.removeAllValues((Object)this.myNode);
    }

    private Block wrapBlock(OCWrappingProcessor wrappingCalculator, OCCodeBlock macroBlock) {
        ASTNode macroCall = macroBlock.getNode();
        ASTNode startNode = OCFormatterUtil.lastLeaf(macroCall);
        if (startNode == null) {
            startNode = macroCall;
        }
        ASTNode injectedChild = macroCall;
        ASTNode firstMacroInjection = macroCall;
        ASTNode lastMacroInjection = macroCall;
        ASTNode lastChildNode = this.myNode.getLastChildNode();
        ASTNode firstChildNode = this.myNode.getFirstChildNode();
        ASTNode leaf = TreeUtil.nextLeaf(startNode);
        while (leaf instanceof OCMacroForeignLeafElement) {
            boolean skipLeaf = false;
            for (ASTNode leafParent = leaf; leafParent != null; leafParent = leafParent.getTreeParent()) {
                if (leafParent.getElementType() == OCElementTypes.MACRO_CALL && leafParent != macroCall) {
                    skipLeaf = true;
                    break;
                }
                if (leafParent.getTreeParent() != this.myNode || injectedChild != macroCall && (lastChildNode != leafParent || injectedChild == firstChildNode)) continue;
                injectedChild = leafParent;
                break;
            }
            if (!skipLeaf) {
                if (firstMacroInjection == macroCall) {
                    firstMacroInjection = leaf;
                }
                lastMacroInjection = leaf;
            }
            leaf = TreeUtil.nextLeaf(leaf);
        }
        IElementType substType = injectedChild.getElementType();
        OCFormatterInfo substBlockAttr = wrappingCalculator.calculate(injectedChild, substType);
        Indent childBlockIndent = this.calcChildIndent(this.myNode.getElementType(), injectedChild, substType);
        return new OCMacroBlock(substBlockAttr.wrap, substBlockAttr.alignment, childBlockIndent, this, (List<Block>)new SmartList((Object)macroBlock), macroCall, firstMacroInjection, lastMacroInjection, injectedChild);
    }

    @NotNull
    private ASTNode getMacroOwner(@NotNull ASTNode macroCall) {
        if (macroCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macroCall", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "getMacroOwner"));
        }
        ASTNode startNode = OCFormatterUtil.lastLeaf(macroCall);
        if (startNode == null) {
            startNode = macroCall;
        }
        ASTNode firstVirtualLeaf = null;
        ASTNode lastVirtualLeaf = null;
        ASTNode leaf = TreeUtil.nextLeaf(startNode);
        while (leaf != null && leaf instanceof OCMacroForeignLeafElement) {
            boolean skipLeaf = false;
            if (leaf.getElementType() == OCTokenTypes.IDENTIFIER && OCElementUtil.getElementType(leaf.getTreeParent()) == OCElementTypes.MACRO_REF) {
                assert (leaf.getTreeParent() != null);
                leaf = OCFormatterUtil.lastLeaf(leaf.getTreeParent().getTreeParent());
                assert (leaf != null);
                skipLeaf = true;
            }
            if (!skipLeaf) {
                if (firstVirtualLeaf == null) {
                    firstVirtualLeaf = leaf;
                }
                lastVirtualLeaf = leaf;
            }
            leaf = TreeUtil.nextLeaf(leaf);
        }
        if (firstVirtualLeaf == null) {
            ASTNode aSTNode = this.myNode;
            if (aSTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "getMacroOwner"));
            }
            return aSTNode;
        }
        ASTNode candidate = OCFormatterUtil.getBestCommonOwner(this.myNode, firstVirtualLeaf, lastVirtualLeaf);
        while (firstVirtualLeaf != lastVirtualLeaf && !OCElementTypes.EXPRESSIONS.contains(candidate.getElementType()) && OCFormatterUtil.firstLeaf(candidate) == firstVirtualLeaf && OCFormatterUtil.lastLeaf(candidate) == lastVirtualLeaf && candidate.getTreeParent() != null) {
            candidate = candidate.getTreeParent();
        }
        ASTNode aSTNode = candidate;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "getMacroOwner"));
        }
        return aSTNode;
    }

    private void extendBlockCollectionByNode(@NotNull List<Block> ownerBlocks, @NotNull ASTNode node, @NotNull OCWrappingProcessor ownerWrappingCalculator) {
        OCCodeBlock childBlock;
        if (ownerBlocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerBlocks", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "extendBlockCollectionByNode"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "extendBlockCollectionByNode"));
        }
        if (ownerWrappingCalculator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerWrappingCalculator", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "extendBlockCollectionByNode"));
        }
        OCIndentChanger addBlock = childBlock = this.createChildBlock(node, ownerWrappingCalculator);
        IElementType nodeElementType = node.getElementType();
        if (node.getTextLength() != 0) {
            OCFormatterInfo indentWrapperInfo;
            if (nodeElementType == OCElementTypes.MACRO_CALL) {
                ASTNode macroOwner = this.getMacroOwner(node);
                if (macroOwner != this.myNode) {
                    this.myGlobalFormatterData.movedBlockMap.add((Object)macroOwner, (Object)childBlock);
                    return;
                }
                addBlock = this.wrapBlock(ownerWrappingCalculator, childBlock);
            } else if (OCFormatterUtil.FORMAT_DIRECTIVES_AND_NON_COMPILED.contains(nodeElementType) && (indentWrapperInfo = this.myLocalFormatterData.get(node)) != null) {
                addBlock = new OCSimpleBlock(Wrap.createWrap((int)2, (boolean)true), null, indentWrapperInfo.indent, this, Collections.singletonList(childBlock));
            }
        }
        if (!OCRecursiveBlockTransformer.CALL_CHAIN_TRANSFORMER.isTransformed(ownerWrappingCalculator, this, ownerBlocks, childBlock, node) && !OCRecursiveBlockTransformer.BINARY_CHAIN_TRANSFORMER.isTransformed(ownerWrappingCalculator, this, ownerBlocks, childBlock, node)) {
            if (nodeElementType == OCElementTypes.ARGUMENT_LIST) {
                OCFormatterUtil.applyIndentCorrection(childBlock.getSubBlocks(), ownerWrappingCalculator.getOCSettings().FUNCTION_CALL_ARGUMENTS_WRAP, ownerWrappingCalculator.getSettings().KEEP_LINE_BREAKS, new Condition<ASTNode>(){

                    public boolean value(ASTNode node) {
                        return COMMA_OR_EXPRESSION.contains(OCElementUtil.getElementType(node));
                    }
                });
            } else if (nodeElementType == OCElementTypes.MESSAGE_EXPRESSION) {
                OCFormatterUtil.applyIndentCorrection(childBlock.getSubBlocks(), 1, ownerWrappingCalculator.getSettings().KEEP_LINE_BREAKS, new Condition<ASTNode>(){

                    public boolean value(ASTNode node) {
                        if (OCElementUtil.getElementType(node) != OCElementTypes.MESSAGE_ARGUMENT) {
                            return false;
                        }
                        ASTNode selector = node.findChildByType((IElementType)OCElementTypes.ARGUMENT_SELECTOR);
                        return selector != null && !StringUtil.isEmptyOrSpaces((String)selector.getText());
                    }
                });
            }
            if (!childBlock.getTextRange().isEmpty()) {
                ownerBlocks.add((Block)addBlock);
            }
        }
    }

    private boolean needBuildSubBlocks() {
        return !this.myGlobalFormatterData.movedBlockMap.isEmpty() || this.myNode.getElementType() == OCElementTypes.MACRO_CALL || OCCodeBlock.hasProblemTailNode(this.myNode);
    }

    private static boolean hasProblemTailNode(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "hasProblemTailNode"));
        }
        ASTNode lastChild = node.getLastChildNode();
        if (lastChild == null || lastChild instanceof LeafElement) {
            return lastChild instanceof OCMacroForeignLeafElement;
        }
        if (lastChild.getTextRange().isEmpty() || lastChild.getElementType() == OCElementTypes.MACRO_CALL) {
            return true;
        }
        return OCCodeBlock.hasProblemTailNode(lastChild);
    }

    @NotNull
    private List<Block> postProcessBlockCollection(@NotNull List<Block> ownerBlocks, @NotNull OCWrappingProcessor wrappingCalculator) {
        SmartList result2;
        if (ownerBlocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerBlocks", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "postProcessBlockCollection"));
        }
        if (wrappingCalculator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappingCalculator", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "postProcessBlockCollection"));
        }
        IElementType thisType = this.myNode.getElementType();
        boolean isStruct = OCElementTypes.STRUCTURE_TYPES.contains(thisType);
        boolean isFunction = thisType == OCElementTypes.FUNCTION_DEFINITION || thisType == OCElementTypes.FUNCTION_DECLARATION;
        boolean isFunctionSignature = false;
        SmartList blocks = result2 = new SmartList();
        Indent tailIndent = null;
        for (Block subBlock : ownerBlocks) {
            ASTNode subNode = OCSimpleBlock.extractFirstNode(subBlock);
            IElementType subNodeType = OCElementUtil.getElementType(subNode);
            if (subNodeType == null) {
                blocks.add(subBlock);
                continue;
            }
            boolean skipBlock = false;
            if (blocks == result2 && subNodeType == OCTokenTypes.TEMPLATE_CPP_KEYWORD) {
                blocks = new SmartList();
            } else if (blocks == result2 && isStruct && (subNodeType == OCTokenTypes.LBRACE || subNode == this.myNode.getLastChildNode())) {
                if (subNodeType != OCTokenTypes.LBRACE) {
                    blocks.add(subBlock);
                    skipBlock = true;
                }
                if (!blocks.isEmpty()) {
                    result2 = new SmartList();
                    result2.add(new OCSimpleBlock(wrappingCalculator.getTemplateWrap(OCElementTypes.DECLARATION), null, Indent.getNoneIndent(), this, (List<Block>)blocks));
                    blocks = result2;
                }
            } else if (blocks != result2 && isFunctionSignature && (OCElementTypes.BLOCK_STATEMENTS.contains(subNodeType) || subNodeType == OCTokenTypes.SEMICOLON)) {
                SmartList acc;
                isFunctionSignature = false;
                if (subNodeType == OCTokenTypes.SEMICOLON) {
                    blocks.add(subBlock);
                    skipBlock = true;
                }
                SmartList smartList = acc = tailIndent == null ? result2 : new SmartList();
                if (!blocks.isEmpty()) {
                    acc.add(new OCSimpleBlock(wrappingCalculator.getTemplateWrap(null), null, Indent.getNoneIndent(), this, (List<Block>)blocks));
                }
                blocks = acc;
            }
            if (!skipBlock) {
                blocks.add(subBlock);
            }
            if (blocks == result2 || subNodeType != OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) continue;
            if (!blocks.isEmpty()) {
                result2.add(new OCSimpleBlock(wrappingCalculator.getTemplateWrap(null), null, Indent.getNoneIndent(), this, (List<Block>)blocks));
            }
            blocks = result2;
            if (isFunction) {
                blocks = new SmartList();
                isFunctionSignature = true;
                if (!this.myOCSettings.TEMPLATE_DECLARATION_FUNCTION_BODY_INDENT) continue;
                tailIndent = Indent.getNormalIndent();
                continue;
            }
            if (!this.myOCSettings.TEMPLATE_DECLARATION_STRUCT_BODY_INDENT) continue;
            blocks = new SmartList();
            tailIndent = Indent.getNormalIndent();
        }
        if (!blocks.isEmpty() && blocks != result2) {
            if (isFunctionSignature) {
                result2.add(new OCSimpleBlock(wrappingCalculator.getTemplateWrap(null), null, tailIndent != null ? tailIndent : Indent.getNoneIndent(), this, (List<Block>)blocks));
            } else if (tailIndent != null) {
                result2.add(new OCSimpleBlock(null, null, tailIndent, this, (List<Block>)blocks));
            } else {
                result2.addAll(blocks);
            }
        }
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "postProcessBlockCollection"));
        }
        return smartList;
    }

    public boolean isInDirective() {
        return this.myInDirective;
    }

    @Nullable
    public static ASTNode getBlockNode(@Nullable Block block) {
        return block instanceof ASTBlock ? ((ASTBlock)block).getNode() : null;
    }

    @Nullable
    public static IElementType getBlockType(@Nullable Block block) {
        return OCElementUtil.getElementType(OCCodeBlock.getBlockNode(block));
    }

    protected OCCodeBlock createChildBlock(ASTNode child, OCWrappingProcessor wrappingCalculator) {
        IElementType childType = child.getElementType();
        if (this.myInDirective || childType == OCElementTypes.MACRO_CALL) {
            OCFormatterInfo joinAttr = wrappingCalculator.getJoinFormatting();
            return new OCCodeBlock(this, this.mySettings, this.myOCSettings, this.myProject, child, this.myGlobalFormatterData, Indent.getNoneIndent(), Indent.getNoneIndent(), joinAttr.wrap, joinAttr.alignment);
        }
        OCFormatterInfo childBlockAttr = wrappingCalculator.calculate(child, childType);
        Indent childBlockIndent = OCFormatterUtil.isNestedInlineBlock(this.getSettings(), this.getOCSettings(), child) ? Indent.getNoneIndent() : this.calcChildIndent(this.myNode.getElementType(), child, childType);
        return OCElementTypes.STATEMENTS.contains(childType) || OCFormatterUtil.isVariablesListOrStructure(childType) || OCFormatterUtil.isNamespace(childType) ? new OCNormalIndentBlock(this, this.mySettings, this.myOCSettings, this.myProject, child, this.myGlobalFormatterData, childBlockIndent, Indent.getIndent((Indent.Type)Indent.Type.NORMAL, (boolean)false, (boolean)true), childBlockAttr.wrap, childBlockAttr.alignment) : new OCCodeBlock(this, this.mySettings, this.myOCSettings, this.myProject, child, this.myGlobalFormatterData, childBlockIndent, Indent.getNoneIndent(), childBlockAttr.wrap, childBlockAttr.alignment);
    }

    @Nullable
    protected Indent calcChildIndentAhead(@NotNull IElementType thisType, @NotNull ASTNode child, @NotNull IElementType childType) {
        if (thisType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisType", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "calcChildIndentAhead"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "calcChildIndentAhead"));
        }
        if (childType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childType", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "calcChildIndentAhead"));
        }
        if (this.mySettings.KEEP_FIRST_COLUMN_COMMENT && (childType == OCTokenTypes.BLOCK_COMMENT || childType == OCTokenTypes.EOL_COMMENT) && IndentHelper.getInstance().getIndent(this.myProject, (FileType)OCFileType.INSTANCE, child, true) == 0) {
            return Indent.getAbsoluteNoneIndent();
        }
        if (childType == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT) {
            if (OCMultilineNodeFormatter.isMultiline(child)) {
                OCPreprocessorFormatterData.OCIndentInfo level = null;
                if (this.myGlobalFormatterData.preprocessorData.directiveNestLevel > 0) {
                    --this.myGlobalFormatterData.preprocessorData.directiveNestLevel;
                    level = this.myGlobalFormatterData.preprocessorData.getIndentAtLevel();
                    ++this.myGlobalFormatterData.preprocessorData.directiveNestLevel;
                }
                boolean atFirstCol = true;
                Boolean oldAtFirstCol = (Boolean)OCMultilineNodeFormatter.AT_FIRST_COL_HINT.get((UserDataHolder)child);
                if (oldAtFirstCol != null) {
                    atFirstCol = oldAtFirstCol;
                    OCMultilineNodeFormatter.AT_FIRST_COL_HINT.set((UserDataHolder)child, null);
                } else {
                    ASTNode prev = child.getTreePrev();
                    if (OCElementUtil.getElementType(prev) == TokenType.WHITE_SPACE) {
                        atFirstCol = prev.getText().endsWith("\n");
                    }
                }
                OCMultilineNodeFormatter.PREPROCESSOR_INFO.set((UserDataHolder)child, (Object)Pair.create((Object)atFirstCol, (Object)level));
                if (this.myGlobalFormatterData.formattingMode == FormattingMode.ADJUST_INDENT) {
                    return this.myChildIndent;
                }
                this.myLocalFormatterData.put(child, OCFormatterInfo.createInfo(this.myChildIndent));
                return OCCodeBlock.getSpaceIndentEnforcedToChildren(120);
            }
            if (child.getChars().charAt(0) == '#') {
                childType = OCTokenTypes.HASH;
            }
        }
        if (OCFormatterUtil.FORMAT_DIRECTIVES.contains(childType) && child.getPsi() != this.myGlobalFormatterData.guardIfndef) {
            boolean indentIsAbsolute;
            PsiElement childPsi;
            IElementType directiveType = childType;
            if (OCElementTypes.DIRECTIVES.contains(childType) && (childPsi = child.getPsi()) instanceof OCDirective) {
                directiveType = OCElementUtil.getElementType(((OCDirective)childPsi).getHeaderToken());
            }
            Pair<OCPreprocessorFormatterData.OffsetType, Integer> indents = this.myGlobalFormatterData.preprocessorData.getIndents(directiveType, this.myOCSettings, IndentHelper.getInstance().getIndent(this.myProject, (FileType)OCFileType.INSTANCE, child, true) == 0);
            boolean bl = indentIsAbsolute = indents.first == OCPreprocessorFormatterData.OffsetType.DIRECTIVE_ABSOLUTE && (Integer)indents.second == 0;
            if (indentIsAbsolute) {
                return Indent.getAbsoluteNoneIndent();
            }
            this.myLocalFormatterData.put(child, OCFormatterInfo.createInfo(indents.first == OCPreprocessorFormatterData.OffsetType.DIRECTIVE_ABSOLUTE ? Indent.getAbsoluteNoneIndent() : this.myChildIndent));
            return OCCodeBlock.getSpaceIndentEnforcedToChildren((Integer)indents.second);
        }
        if (childType == OCTokenTypes.COLON) {
            if (thisType == OCElementTypes.CPP_BASE_CLAUSE_LIST) {
                return Indent.getNoneIndent();
            }
            if (thisType == OCElementTypes.DECLARATOR) {
                return Indent.getContinuationIndent();
            }
        }
        if (OCElementUtil.isOCVisibilityKeyword(child) || OCElementUtil.isCPPVisibilityKeyword(child) && OCFormatterUtil.isStructure(thisType)) {
            return this.myChildIndentEx;
        }
        if (childType == OCTokenTypes.LBRACE || childType == OCTokenTypes.RBRACE) {
            return this.myBracesIndent;
        }
        return null;
    }

    @Nullable
    protected Indent calcChildIndent(@NotNull IElementType thisType, @NotNull ASTNode child, @NotNull IElementType childType) {
        boolean isBinaryNode;
        if (thisType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisType", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "calcChildIndent"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "calcChildIndent"));
        }
        if (childType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childType", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "calcChildIndent"));
        }
        Indent childIndent = this.calcChildIndentAhead(thisType, child, childType);
        if (childIndent != null) {
            return childIndent;
        }
        if (OCElementTypes.NS_COLLECTION_LITERALS.contains(thisType) && childType == OCTokenTypes.AT) {
            return Indent.getNoneIndent();
        }
        if (childType == OCTokenTypes.LBRACKET || childType == OCTokenTypes.RBRACKET) {
            return Indent.getNoneIndent();
        }
        if (!(thisType != OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST && thisType != OCElementTypes.TEMPLATE_ARGUMENT_LIST || childType != OCTokenTypes.LT && childType != OCTokenTypes.GT && childType != OCTokenTypes.GTGT)) {
            return Indent.getNoneIndent();
        }
        if (childType == OCTokenTypes.LPAR && !FormatterUtil.isFollowedBy(child, OCElementTypes.TYPE_ELEMENT) || childType == OCTokenTypes.RPAR) {
            return Indent.getNoneIndent();
        }
        if (OCElementTypes.CLASSES.contains(thisType) && (OCFormatterUtil.isClassMember(child) || childType == OCElementTypes.INSTANCE_VARIABLES_LIST && !this.myOCSettings.INDENT_INTERFACE_MEMBERS_EXCEPT_IVARS_BLOCK)) {
            int spaces = thisType == OCElementTypes.IMPLEMENTATION ? this.myOCSettings.INDENT_IMPLEMENTATION_MEMBERS : this.myOCSettings.INDENT_INTERFACE_MEMBERS;
            return Indent.getIndent((Indent.Type)Indent.Type.SPACES, (int)spaces, (boolean)false, (boolean)true);
        }
        if (thisType == OCElementTypes.BLOCK_EXPRESSION) {
            return Indent.getNoneIndent();
        }
        boolean isListNode = childType == OCElementTypes.PARAMETER_LIST || childType == OCElementTypes.ARGUMENT_LIST || thisType == OCElementTypes.ARGUMENT_LIST || thisType == OCElementTypes.PARAMETER_LIST || childType == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST || childType == OCElementTypes.TEMPLATE_ARGUMENT_LIST;
        boolean bl = isBinaryNode = thisType == OCElementTypes.BINARY_EXPRESSION || thisType == OCElementTypes.EXPRESSION_STATEMENT || thisType == OCElementTypes.CALL_EXPRESSION || thisType == OCElementTypes.QUALIFIED_EXPRESSION;
        if (isListNode || isBinaryNode) {
            return Indent.getContinuationWithoutFirstIndent();
        }
        if (thisType == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST || thisType == OCElementTypes.TEMPLATE_ARGUMENT_LIST || OCCodeBlock.isContinuationIndent(this.myNode, thisType, child, childType)) {
            return Indent.getContinuationIndent();
        }
        return this.myChildIndent;
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (newChildIndex == 0) {
            ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        Block prev = null;
        for (Block each : ContainerUtil.iterateBackward(this.getSubBlocks())) {
            if (OCElementUtil.getElementType(OCSimpleBlock.extractLastNode(each)) instanceof OCPunctuatorElementType) continue;
            prev = each;
            break;
        }
        if (prev == null) {
            prev = this.getSubBlocks().get(newChildIndex - 1);
        }
        Indent indent = prev.getIndent();
        IElementType et = OCElementUtil.getElementType(OCSimpleBlock.extractLastNode(prev));
        if (OCFormatterUtil.isAnyLBrace(et)) {
            indent = Indent.getContinuationIndent();
        } else if (et == OCTokenTypes.LT) {
            IElementType blockType = OCElementUtil.getElementType(this.getNode());
            if (blockType == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST || blockType == OCElementTypes.TEMPLATE_ARGUMENT_LIST) {
                indent = Indent.getContinuationIndent();
            }
        } else if (et == OCElementTypes.METHOD_SELECTOR_PART) {
            indent = Indent.getContinuationIndent();
        }
        ChildAttributes childAttributes = new ChildAttributes(indent, prev.getAlignment());
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "getSpacing"));
        }
        return OCSpacingProcessor.getSpacing(this, child1, child2);
    }

    @Override
    public Indent getIndent() {
        return this.myIndent;
    }

    @Override
    public void putIndent(Indent indent) {
        this.myIndent = indent;
    }

    @Override
    protected Indent getChildIndent() {
        return this.myChildIndent;
    }

    public boolean isLeaf() {
        return this.myNode instanceof LeafElement;
    }

    @NotNull
    OCLocalFormatterData getLocalFormatterData() {
        OCLocalFormatterData oCLocalFormatterData = this.myLocalFormatterData;
        if (oCLocalFormatterData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "getLocalFormatterData"));
        }
        return oCLocalFormatterData;
    }

    @NotNull
    public CommonCodeStyleSettings getSettings() {
        CommonCodeStyleSettings commonCodeStyleSettings = this.mySettings;
        if (commonCodeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "getSettings"));
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    public OCCodeStyleSettings getOCSettings() {
        OCCodeStyleSettings oCCodeStyleSettings = this.myOCSettings;
        if (oCCodeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCCodeBlock", "getOCSettings"));
        }
        return oCCodeStyleSettings;
    }

    private static boolean isContinuationIndent(ASTNode thisNode, IElementType thisType, ASTNode child, IElementType childType) {
        if (childType == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST || thisType == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) {
            return true;
        }
        if (childType == OCElementTypes.TEMPLATE_ARGUMENT_LIST || thisType == OCElementTypes.TEMPLATE_ARGUMENT_LIST) {
            return true;
        }
        if (thisType == OCElementTypes.CPP_CONSTRUCTOR_INITIALIZATION_LIST) {
            return true;
        }
        if (thisType == OCElementTypes.CPP_BASE_CLAUSE_LIST) {
            return true;
        }
        if (thisType == OCElementTypes.MACRO_ARGUMENT) {
            return true;
        }
        if (childType == OCElementTypes.COMPOUND_INITIALIZER) {
            return true;
        }
        if (OCElementTypes.EXPRESSIONS.contains(thisType) && child.getTreePrev() != null && (!OCElementTypes.BLOCK_STATEMENTS.contains(childType) || thisType != OCElementTypes.CPP_LAMBDA_EXPRESSION)) {
            return true;
        }
        if (thisType == OCElementTypes.SUPER_CLASS_REF || thisType == OCElementTypes.PROTOCOL_LIST) {
            return true;
        }
        if (OCFormatterUtil.isCollectionOrStructureInitializer(thisType)) {
            return true;
        }
        IElementType parentType = OCElementUtil.getElementType(thisNode.getTreeParent());
        if (!(parentType != OCElementTypes.DECLARATION && parentType != OCElementTypes.FUNCTION_DECLARATION || thisType != OCElementTypes.DECLARATOR || thisNode.getTreePrev() == null || thisNode.getTreePrev().getText().isEmpty())) {
            return true;
        }
        if (OCFormatterUtil.isMessageArgumentValue(child)) {
            return true;
        }
        if (childType == OCElementTypes.METHOD_SELECTOR_PART && OCFormatterUtil.isPrecededBy(child, OCElementTypes.METHOD_SELECTOR_PART)) {
            return true;
        }
        return thisType == OCElementTypes.METHOD_SELECTOR_PART && child.getTreePrev() != null;
    }

    protected static Indent getDoubleIndent(CommonCodeStyleSettings settings) {
        return Indent.getSpaceIndent((int)(settings.getIndentOptions().INDENT_SIZE * 2));
    }

    protected static Indent getSpaceIndentEnforcedToChildren(int spaceCount) {
        return Indent.getIndent((Indent.Type)Indent.Type.SPACES, (int)spaceCount, (boolean)false, (boolean)true);
    }
}

