/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.typing;

import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardStructureDetector;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;

public class OCHighlightingTokenIterator
implements OCBackwardStructureDetector.TokenIterator {
    @NotNull
    private final HighlighterIterator myIterator;

    public OCHighlightingTokenIterator(@NotNull HighlighterIterator iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/jetbrains/cidr/lang/editor/typing/OCHighlightingTokenIterator", "<init>"));
        }
        this.myIterator = iterator;
    }

    @Override
    public IElementType getTokenType() {
        return this.myIterator.getTokenType();
    }

    @Override
    public boolean atEnd() {
        return this.myIterator.atEnd();
    }

    @Override
    public void retreat() {
        this.myIterator.retreat();
    }

    @Override
    public void skipWhitespaces() {
        while (!this.myIterator.atEnd() && OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(this.myIterator.getTokenType())) {
            this.myIterator.retreat();
        }
    }

    @Override
    public OCBackwardStructureDetector.TokenIterator.Marker mark() {
        return new MyMarker(this.myIterator.getStart());
    }

    private class MyMarker
    implements OCBackwardStructureDetector.TokenIterator.Marker {
        private final int myStart;

        public MyMarker(int start) {
            this.myStart = start;
        }

        @Override
        public void rollback() {
            if (OCHighlightingTokenIterator.this.myIterator.atEnd()) {
                OCHighlightingTokenIterator.this.myIterator.advance();
                if (OCHighlightingTokenIterator.this.myIterator.atEnd()) {
                    OCHighlightingTokenIterator.this.myIterator.retreat();
                    OCHighlightingTokenIterator.this.myIterator.retreat();
                }
            }
            while (this.myStart > OCHighlightingTokenIterator.this.myIterator.getStart()) {
                OCHighlightingTokenIterator.this.myIterator.advance();
            }
            while (this.myStart < OCHighlightingTokenIterator.this.myIterator.getStart()) {
                OCHighlightingTokenIterator.this.myIterator.retreat();
            }
        }
    }
}

