/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.typing;

import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardBlockDetector;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardOrDetector;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardRepeatDetector;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardSequenceDetector;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardTokenDetector;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public abstract class OCBackwardStructureDetector {
    public boolean tryNext(@NotNull TokenIterator tokenIterator) {
        if (tokenIterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenIterator", "com/jetbrains/cidr/lang/editor/typing/OCBackwardStructureDetector", "tryNext"));
        }
        if (tokenIterator.atEnd()) {
            return false;
        }
        TokenIterator.Marker mark = tokenIterator.mark();
        if (!this.next(tokenIterator)) {
            mark.rollback();
            return false;
        }
        return true;
    }

    public abstract boolean next(@NotNull TokenIterator var1);

    public static OCBackwardStructureDetector token(IElementType ... types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/jetbrains/cidr/lang/editor/typing/OCBackwardStructureDetector", "token"));
        }
        return new OCBackwardTokenDetector(true, TokenSet.create((IElementType[])types));
    }

    public static OCBackwardStructureDetector tokenExcept(IElementType ... types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/jetbrains/cidr/lang/editor/typing/OCBackwardStructureDetector", "tokenExcept"));
        }
        return new OCBackwardTokenDetector(false, TokenSet.create((IElementType[])types));
    }

    public static OCBackwardStructureDetector block(@NotNull IElementType leftBorder, @NotNull IElementType rightBorder) {
        if (leftBorder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftBorder", "com/jetbrains/cidr/lang/editor/typing/OCBackwardStructureDetector", "block"));
        }
        if (rightBorder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightBorder", "com/jetbrains/cidr/lang/editor/typing/OCBackwardStructureDetector", "block"));
        }
        return new OCBackwardBlockDetector(leftBorder, rightBorder);
    }

    public static OCBackwardStructureDetector sequence(OCBackwardStructureDetector ... sequence) {
        return new OCBackwardSequenceDetector(Arrays.asList(sequence));
    }

    public static OCBackwardStructureDetector or(OCBackwardStructureDetector ... variants) {
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/jetbrains/cidr/lang/editor/typing/OCBackwardStructureDetector", "or"));
        }
        return new OCBackwardOrDetector(Arrays.asList(variants));
    }

    public static OCBackwardStructureDetector repeat(@NotNull Cardinality cardinality, @NotNull OCBackwardStructureDetector detector) {
        if (cardinality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cardinality", "com/jetbrains/cidr/lang/editor/typing/OCBackwardStructureDetector", "repeat"));
        }
        if (detector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detector", "com/jetbrains/cidr/lang/editor/typing/OCBackwardStructureDetector", "repeat"));
        }
        return new OCBackwardRepeatDetector(cardinality, detector);
    }

    public static interface TokenIterator {
        public Marker mark();

        public IElementType getTokenType();

        public boolean atEnd();

        public void retreat();

        public void skipWhitespaces();

        public static interface Marker {
            public void rollback();
        }
    }

    public static enum Cardinality {
        ONE_OR_MORE,
        ZERO_OR_MORE,
        MAYBE_ONE;

    }
}

