/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.typing;

import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardStructureDetector;
import org.jetbrains.annotations.NotNull;

public class OCBackwardBlockDetector
extends OCBackwardStructureDetector {
    @NotNull
    private final IElementType myRight;
    @NotNull
    private final IElementType myLeft;

    public OCBackwardBlockDetector(@NotNull IElementType left, @NotNull IElementType right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/jetbrains/cidr/lang/editor/typing/OCBackwardBlockDetector", "<init>"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/jetbrains/cidr/lang/editor/typing/OCBackwardBlockDetector", "<init>"));
        }
        this.myRight = right;
        this.myLeft = left;
    }

    @Override
    public boolean next(@NotNull OCBackwardStructureDetector.TokenIterator it) {
        block4: {
            if (it == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it", "com/jetbrains/cidr/lang/editor/typing/OCBackwardBlockDetector", "next"));
            }
            it.skipWhitespaces();
            if (it.atEnd() || it.getTokenType() != this.myRight) {
                return false;
            }
            int balance = 1;
            while (true) {
                it.retreat();
                it.skipWhitespaces();
                if (it.atEnd()) break block4;
                IElementType tt = it.getTokenType();
                if (tt == this.myRight) {
                    ++balance;
                    continue;
                }
                if (tt == this.myLeft && --balance == 0) break;
            }
            it.retreat();
            return true;
        }
        return false;
    }
}

