/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OCSurroundUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.editor.surround.OCSurroundUtil");

    static PsiElement[] moveDeclarationsOut(PsiElement block, PsiElement[] statements, boolean generateInitializers) {
        try {
            PsiManager psiManager = block.getManager();
            Project project = psiManager.getProject();
            ArrayList<PsiElement> array = new ArrayList<PsiElement>();
            for (PsiElement statement : statements) {
                OCDeclarationStatement declaration;
                if (statement instanceof OCDeclarationStatement && OCSurroundUtil.needToDeclareOut(block, statements, declaration = (OCDeclarationStatement)statement)) {
                    OCDeclarationStatement newDeclaration;
                    List<OCDeclarator> elements = declaration.getDeclaration().getDeclarators();
                    for (PsiElement psiElement : elements) {
                        OCDeclarator var = (OCDeclarator)psiElement;
                        OCExpression oCExpression = var.getInitializer();
                        if (oCExpression == null) continue;
                        String name = var.getName();
                        OCExpressionStatement assignment = (OCExpressionStatement)OCElementFactory.statementFromText(name + "=x;", psiElement);
                        assignment = (OCExpressionStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)assignment);
                        OCAssignmentExpression expr = (OCAssignmentExpression)assignment.getExpression();
                        OCChangeUtil.replaceHandlingMacros(expr.getSourceExpression(), oCExpression);
                        assignment = (OCExpressionStatement)block.addAfter((PsiElement)assignment, (PsiElement)declaration);
                        array.add(assignment);
                    }
                    if (!array.isEmpty()) {
                        PsiElement psiElement = (PsiElement)array.get(0);
                        newDeclaration = (OCDeclarationStatement)block.addBefore((PsiElement)declaration, psiElement);
                        OCChangeUtil.delete(declaration);
                    } else {
                        newDeclaration = declaration;
                    }
                    OCDeclaration oCDeclaration = newDeclaration.getDeclaration();
                    elements = oCDeclaration.getDeclarators();
                    for (PsiElement psiElement : elements) {
                        OCDeclarator var = (OCDeclarator)psiElement;
                        OCExpression initializer = var.getInitializer();
                        if (initializer == null) continue;
                        if (!generateInitializers) {
                            OCChangeUtil.delete(initializer);
                            continue;
                        }
                        String newText = OCElementFactory.declarationText(Collections.<String>emptyList(), var.getName(), var.getType(), var.getResolvedType().getDefaultValue(psiElement), psiElement, null, false);
                        OCDeclarationStatement newStmt = (OCDeclarationStatement)OCElementFactory.statementFromText(newText, block);
                        OCChangeUtil.replaceHandlingMacros(var, newStmt.getDeclaration().getDeclarators().get(0));
                    }
                    continue;
                }
                array.add(statement);
            }
            return PsiUtilCore.toPsiElementArray(array);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return statements;
        }
    }

    private static boolean needToDeclareOut(PsiElement block, PsiElement[] statements, OCDeclarationStatement statement) {
        List<OCDeclarator> elements = statement.getDeclaration().getDeclarators();
        PsiElement lastStatement = statements[statements.length - 1];
        int endOffset = lastStatement.getTextRange().getEndOffset();
        for (PsiElement psiElement : elements) {
            PsiReference lastRef;
            GlobalSearchScope projectScope;
            PsiReference[] refs;
            if (!(psiElement instanceof OCDeclarator) || (refs = (PsiReference[])ReferencesSearch.search((PsiElement)psiElement, (SearchScope)(projectScope = OCSearchScope.getProjectSourcesScope(psiElement.getProject())), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY)).length <= 0 || (lastRef = refs[refs.length - 1]).getElement().getTextOffset() <= endOffset) continue;
            return true;
        }
        return false;
    }
}

