/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.editor.smartEnter.AfterSemicolonEnterProcessor;
import com.jetbrains.cidr.lang.editor.smartEnter.BlockBraceFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.CommentBreakerEnterProcessor;
import com.jetbrains.cidr.lang.editor.smartEnter.DoWhileConditionFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.EnterProcessor;
import com.jetbrains.cidr.lang.editor.smartEnter.Fixer;
import com.jetbrains.cidr.lang.editor.smartEnter.IfConditionFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.LiteralFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.MissingCatchBodyFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.MissingForBodyFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.MissingForeachBodyFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.MissingFunctionBodyFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.MissingIfBranchesFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.MissingMethodBodyFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.MissingSwitchBodyFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.MissingSynchronizedBodyFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.MissingWhileBodyFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.ParameterListFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.ParenthesizedFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.PlainEnterProcessor;
import com.jetbrains.cidr.lang.editor.smartEnter.SemicolonFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.SwitchExpressionFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.WhileConditionFixer;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCStatement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSmartEnterProcessor
extends SmartEnterProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor");
    private static final Fixer[] ourFixers;
    private static final EnterProcessor[] ourEnterProcessors;
    private int myFirstErrorOffset = Integer.MAX_VALUE;
    private static final int MAX_ATTEMPTS = 20;
    private static final Key<Long> SMART_ENTER_TIMESTAMP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/editor/smartEnter/OCSmartEnterProcessor", "process"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/editor/smartEnter/OCSmartEnterProcessor", "process"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/cidr/lang/editor/smartEnter/OCSmartEnterProcessor", "process"));
        }
        Document document = editor.getDocument();
        String textForRollback = document.getText();
        try {
            editor.putUserData(SMART_ENTER_TIMESTAMP, (Object)editor.getDocument().getModificationStamp());
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            this.process(project, editor, psiFile, 0);
        }
        catch (TooManyAttemptsException e) {
            document.replaceString(0, document.getTextLength(), (CharSequence)textForRollback);
        }
        finally {
            editor.putUserData(SMART_ENTER_TIMESTAMP, null);
        }
        return true;
    }

    private void process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, int attempt) throws TooManyAttemptsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/editor/smartEnter/OCSmartEnterProcessor", "process"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/editor/smartEnter/OCSmartEnterProcessor", "process"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/editor/smartEnter/OCSmartEnterProcessor", "process"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.complete.statement");
        if (attempt > 20) {
            throw new TooManyAttemptsException();
        }
        try {
            PsiElement atCaret;
            this.commit(editor);
            if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
                editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            }
            if ((atCaret = this.getStatementAtCaret(editor, file2)) == null) {
                if (!new CommentBreakerEnterProcessor().doEnter(editor, (PsiElement)file2, false)) {
                    OCSmartEnterProcessor.plainEnter(editor);
                }
                return;
            }
            ArrayList<PsiElement> queue = new ArrayList<PsiElement>();
            OCSmartEnterProcessor.collectAllElements(atCaret, queue, true);
            queue.add(atCaret);
            for (PsiElement psiElement : queue) {
                for (Fixer fixer : ourFixers) {
                    fixer.apply(editor, this, psiElement);
                    if (LookupManager.getInstance(project).getActiveLookup() != null) {
                        return;
                    }
                    if (!OCSmartEnterProcessor.isUncommited((Project)project) && psiElement.isValid()) continue;
                    this.moveCaretInsideBracesIfAny(editor, file2);
                    this.process(project, editor, file2, attempt + 1);
                    return;
                }
            }
            this.doEnter(atCaret, editor);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void reformat(PsiElement atCaret) throws IncorrectOperationException {
        if (atCaret == null) {
            return;
        }
        PsiElement parent = atCaret.getParent();
        if (parent instanceof OCBlockStatement) {
            OCBlockStatement block = (OCBlockStatement)parent;
            if (block.getStatements().size() > 0 && block.getStatements().get(0) == atCaret) {
                atCaret = block;
            }
        } else if (parent instanceof OCForStatement) {
            atCaret = parent;
        }
        super.reformat(atCaret);
    }

    private void doEnter(PsiElement atCaret, Editor editor) throws IncorrectOperationException {
        PsiFile psiFile = atCaret.getContainingFile();
        RangeMarker rangeMarker = this.createRangeMarker((PsiElement)atCaret);
        if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
            editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            this.reformat((PsiElement)atCaret);
            return;
        }
        this.reformat((PsiElement)atCaret);
        this.commit(editor);
        atCaret = CodeInsightUtilCore.findElementInRange(psiFile, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), atCaret.getClass(), OCLanguage.getInstance());
        for (EnterProcessor processor2 : ourEnterProcessors) {
            if (atCaret == null) break;
            if (!processor2.doEnter(editor, (PsiElement)atCaret, OCSmartEnterProcessor.isModified(editor))) continue;
            return;
        }
        if (!OCSmartEnterProcessor.isModified(editor)) {
            OCSmartEnterProcessor.plainEnter(editor);
        } else if (this.myFirstErrorOffset == Integer.MAX_VALUE) {
            editor.getCaretModel().moveToOffset(rangeMarker.getEndOffset());
        } else {
            editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
        }
    }

    private static void collectAllElements(PsiElement atCaret, List<PsiElement> res, boolean recurse) {
        PsiElement[] children2;
        res.add(0, atCaret);
        if (atCaret instanceof OCMacroCall) {
            return;
        }
        if (OCSmartEnterProcessor.doNotStepInto(atCaret)) {
            if (!recurse) {
                return;
            }
            recurse = false;
        }
        for (PsiElement child : children2 = atCaret.getChildren()) {
            if (atCaret instanceof OCStatement && child instanceof OCStatement) continue;
            OCSmartEnterProcessor.collectAllElements(child, res, recurse);
        }
    }

    private static boolean doNotStepInto(PsiElement element) {
        return element instanceof OCClassDeclaration || element instanceof OCStatement || element instanceof OCMethod;
    }

    @Nullable
    protected PsiElement getStatementAtCaret(Editor editor, PsiFile psiFile) {
        return OCSmartEnterProcessor.getStatementParentOf(super.getStatementAtCaret(editor, psiFile));
    }

    @Nullable
    private static PsiElement getStatementParentOf(PsiElement atCaret) {
        PsiElement statementAtCaret;
        if (atCaret instanceof PsiWhiteSpace) {
            return null;
        }
        OCMacroCall macroCallAtCaret = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)atCaret, OCMacroCall.class);
        if (macroCallAtCaret != null) {
            atCaret = macroCallAtCaret;
        }
        if ((statementAtCaret = PsiTreeUtil.getParentOfType((PsiElement)atCaret, (Class[])new Class[]{OCStatement.class, OCMethod.class, OCDeclaration.class, OCProperty.class, PsiComment.class})) instanceof OCBlockStatement) {
            PsiElement lastExpansionLeaf;
            if (macroCallAtCaret != null && (lastExpansionLeaf = macroCallAtCaret.getLastExpansionLeaf()) != null) {
                return OCSmartEnterProcessor.getStatementParentOf(lastExpansionLeaf);
            }
            return null;
        }
        if (statementAtCaret != null && statementAtCaret.getParent() instanceof OCForStatement && !PsiTreeUtil.hasErrorElements((PsiElement)statementAtCaret)) {
            statementAtCaret = statementAtCaret.getParent();
        }
        return statementAtCaret instanceof OCStatement || statementAtCaret instanceof OCProperty || statementAtCaret instanceof OCDeclaration || statementAtCaret instanceof OCMethod ? statementAtCaret : null;
    }

    protected void moveCaretInsideBracesIfAny(@NotNull Editor editor, @NotNull PsiFile file2) throws IncorrectOperationException {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/editor/smartEnter/OCSmartEnterProcessor", "moveCaretInsideBracesIfAny"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/editor/smartEnter/OCSmartEnterProcessor", "moveCaretInsideBracesIfAny"));
        }
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{}")) {
            caretOffset += 2;
        } else if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{\n}")) {
            caretOffset += 3;
        }
        caretOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(caretOffset - 1), (String)" \t") + 1;
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{}".length()), (CharSequence)"{}") || CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{\n}".length()), (CharSequence)"{\n}")) {
            this.commit(editor);
            CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)file2.getProject());
            boolean old = settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = false;
            PsiElement elt = PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(caretOffset - 1), OCBlockStatement.class);
            this.reformat(elt);
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = old;
            editor.getCaretModel().moveToOffset(caretOffset - 1);
        }
    }

    public void registerUnresolvedError(int offset) {
        if (this.myFirstErrorOffset > offset) {
            this.myFirstErrorOffset = offset;
        }
    }

    protected static void plainEnter(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/editor/smartEnter/OCSmartEnterProcessor", "plainEnter"));
        }
        OCSmartEnterProcessor.getEnterHandler().execute(editor, ((EditorEx)editor).getDataContext());
    }

    protected static EditorActionHandler getEnterHandler() {
        return EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
    }

    protected static boolean isModified(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/editor/smartEnter/OCSmartEnterProcessor", "isModified"));
        }
        Long timestamp = (Long)editor.getUserData(SMART_ENTER_TIMESTAMP);
        return editor.getDocument().getModificationStamp() != timestamp.longValue();
    }

    static {
        ArrayList<Fixer> fixers = new ArrayList<Fixer>();
        fixers.add(new LiteralFixer());
        fixers.add(new IfConditionFixer());
        fixers.add(new WhileConditionFixer());
        fixers.add(new SwitchExpressionFixer());
        fixers.add(new DoWhileConditionFixer());
        fixers.add(new BlockBraceFixer());
        fixers.add(new MissingIfBranchesFixer());
        fixers.add(new MissingWhileBodyFixer());
        fixers.add(new MissingSwitchBodyFixer());
        fixers.add(new MissingCatchBodyFixer());
        fixers.add(new MissingSynchronizedBodyFixer());
        fixers.add(new MissingForBodyFixer());
        fixers.add(new MissingForeachBodyFixer());
        fixers.add(new ParameterListFixer());
        fixers.add(new MissingMethodBodyFixer());
        fixers.add(new MissingFunctionBodyFixer());
        fixers.add(new ParenthesizedFixer());
        fixers.add(new SemicolonFixer());
        ourFixers = fixers.toArray(new Fixer[fixers.size()]);
        ArrayList<EnterProcessor> processors = new ArrayList<EnterProcessor>();
        processors.add(new CommentBreakerEnterProcessor());
        processors.add(new AfterSemicolonEnterProcessor());
        processors.add(new PlainEnterProcessor());
        ourEnterProcessors = processors.toArray(new EnterProcessor[processors.size()]);
        SMART_ENTER_TIMESTAMP = Key.create((String)"smartEnterOriginalTimestamp");
    }

    public static class TooManyAttemptsException
    extends Exception {
    }
}

