/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.Fixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;

public class MissingIfBranchesFixer
implements Fixer {
    @Override
    public void apply(Editor editor, OCSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (!(psiElement instanceof OCIfStatement)) {
            return;
        }
        OCIfStatement ifStatement = (OCIfStatement)psiElement;
        Document doc = editor.getDocument();
        OCStatement elseBranch = ifStatement.getElseBranch();
        ASTNode elseElement = ifStatement.getElseKeyword();
        if (elseElement != null && (elseBranch == null || !(elseBranch instanceof OCBlockStatement) && MissingIfBranchesFixer.startLine(doc, elseBranch) > MissingIfBranchesFixer.startLine(doc, elseElement.getPsi()))) {
            doc.insertString(elseElement.getTextRange().getEndOffset(), (CharSequence)"{\n}");
            return;
        }
        OCStatement thenBranch = ifStatement.getThenBranch();
        if (thenBranch instanceof OCBlockStatement) {
            return;
        }
        boolean transformingOneLiner = false;
        if (thenBranch != null && MissingIfBranchesFixer.startLine(doc, thenBranch) == MissingIfBranchesFixer.startLine(doc, ifStatement)) {
            if (ifStatement.getCondition() != null) {
                return;
            }
            transformingOneLiner = true;
        }
        ASTNode rParenth = ifStatement.getRParenth();
        assert (rParenth != null);
        if (elseBranch == null && !transformingOneLiner || thenBranch == null) {
            doc.insertString(rParenth.getTextRange().getEndOffset(), (CharSequence)"{\n}");
        } else {
            doc.insertString(rParenth.getTextRange().getEndOffset(), (CharSequence)"{");
            doc.insertString(thenBranch.getTextRange().getEndOffset() + 1, (CharSequence)"}");
        }
    }

    private static int startLine(Document doc, PsiElement psiElement) {
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

