/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.parameterInfo;

import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionParameterInfo {
    @NotNull
    private final OCFunctionType myType;
    @Nullable
    private final List<String> myDefaultParameterValues;

    public OCFunctionParameterInfo(@NotNull OCFunctionType type, @Nullable List<String> defaultParameterValues) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/editor/parameterInfo/OCFunctionParameterInfo", "<init>"));
        }
        this.myType = type;
        OCLog.LOG.assertTrue(defaultParameterValues == null || this.myType.getParameterTypes().size() == defaultParameterValues.size());
        this.myDefaultParameterValues = defaultParameterValues;
    }

    @NotNull
    public OCFunctionType getType() {
        OCFunctionType oCFunctionType = this.myType;
        if (oCFunctionType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/parameterInfo/OCFunctionParameterInfo", "getType"));
        }
        return oCFunctionType;
    }

    @Nullable
    public List<String> getDefaultParameterValues() {
        return this.myDefaultParameterValues;
    }
}

