/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.parameterInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallOption;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionParameterInfo;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCFunctionCallPlace<T extends PsiElement> {
    @NotNull
    private final T myElement;
    private static final Pattern LINE_BREAKS = Pattern.compile("\\s*\n+\\s*");

    public OCFunctionCallPlace(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/editor/parameterInfo/OCFunctionCallPlace", "<init>"));
        }
        this.myElement = element;
    }

    protected static void collectInitializationOptions(@NotNull OCType type, @NotNull OCElement place, @NotNull Collection<OCFunctionCallOption> result2) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/editor/parameterInfo/OCFunctionCallPlace", "collectInitializationOptions"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/jetbrains/cidr/lang/editor/parameterInfo/OCFunctionCallPlace", "collectInitializationOptions"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/editor/parameterInfo/OCFunctionCallPlace", "collectInitializationOptions"));
        }
        if (!place.getContainingOCFile().getKind().isCpp() || !type.isInstanceable()) {
            return;
        }
        if (type instanceof OCStructType) {
            OCFunctionCallPlace.collectConstructorCallOptions(type, place, result2);
        } else {
            if (!(type instanceof OCCppReferenceType)) {
                OCFunctionType t = new OCFunctionType(OCVoidType.instance(), Collections.emptyList());
                result2.add(new OCFunctionCallOption(new OCFunctionParameterInfo(t, null), -2));
            }
            OCFunctionType init = new OCFunctionType(OCVoidType.instance(), Collections.singletonList(type), Collections.singletonList("<unnamed>"));
            result2.add(new OCFunctionCallOption(new OCFunctionParameterInfo(init, null), -1));
        }
    }

    protected static void collectConstructorCallOptions(@NotNull OCType rt, @NotNull PsiElement place, @NotNull Collection<OCFunctionCallOption> result2) {
        Collection functionSymbols;
        if (rt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rt", "com/jetbrains/cidr/lang/editor/parameterInfo/OCFunctionCallPlace", "collectConstructorCallOptions"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/jetbrains/cidr/lang/editor/parameterInfo/OCFunctionCallPlace", "collectConstructorCallOptions"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/editor/parameterInfo/OCFunctionCallPlace", "collectConstructorCallOptions"));
        }
        if (rt instanceof OCStructType) {
            CommonProcessors.CollectProcessor constructors = new CommonProcessors.CollectProcessor();
            ((OCStructType)rt).getSymbol().processConstructors((Processor<? super OCFunctionSymbol>)constructors);
            functionSymbols = constructors.getResults();
        } else {
            functionSymbols = null;
        }
        OCFunctionCallPlace.collectCallOptions(result2, place, functionSymbols, null);
    }

    protected static void collectCallOptions(@NotNull Collection<OCFunctionCallOption> result2, @NotNull PsiElement place, @Nullable Collection<OCSymbol> functionSymbols, @Nullable OCType qualifierType) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/editor/parameterInfo/OCFunctionCallPlace", "collectCallOptions"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/jetbrains/cidr/lang/editor/parameterInfo/OCFunctionCallPlace", "collectCallOptions"));
        }
        if (functionSymbols != null) {
            for (OCSymbol symbol : functionSymbols) {
                OCType type;
                OCFunctionSymbol s;
                OCFunctionDefinition funcDef;
                if (symbol == null || (funcDef = (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)place, OCFunctionDefinition.class)) != null && (s = funcDef.getSymbol()) != null && s.getKind() == OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION && symbol.isSameSymbol(s) || !OCVisibility.isVisible(symbol, place, qualifierType) || !((type = symbol.getType().resolve(place.getContainingFile()).getTerminalType()) instanceof OCFunctionType)) continue;
                OCFunctionType funType = (OCFunctionType)type;
                List defaultValues = null;
                if (symbol instanceof OCFunctionSymbol && !funType.hasNoParameters()) {
                    List<OCDeclaratorSymbol> params = ((OCFunctionSymbol)symbol).getParameterSymbols();
                    defaultValues = ContainerUtil.map(params, (Function)new Function<OCDeclaratorSymbol, String>(){

                        public String fun(OCDeclaratorSymbol symbol) {
                            OCExpressionSymbol initializer = symbol.getInitializer();
                            if (initializer == null) {
                                return null;
                            }
                            return LINE_BREAKS.matcher(initializer.getPresentableName()).replaceAll(" ");
                        }
                    });
                }
                OCFunctionParameterInfo info = new OCFunctionParameterInfo(funType, defaultValues);
                result2.add(new OCFunctionCallOption(info, symbol.getOffset()));
            }
        }
    }

    @NotNull
    public T getElement() {
        T t = this.myElement;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/parameterInfo/OCFunctionCallPlace", "getElement"));
        }
        return t;
    }

    public abstract void collectCallOptions(@NotNull Collection<OCFunctionCallOption> var1);

    @NotNull
    public abstract List<OCExpression> getArgumentExpressions();
}

