/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.editor.completion.OCCodeContextType;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCElementResult;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCVariableOfTypeMacro
extends Macro {
    public String getName() {
        return "variableOfType";
    }

    public String getPresentableName() {
        return "variableOfType()";
    }

    @NotNull
    public String getDefaultValue() {
        if ("a" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/liveTemplates/OCVariableOfTypeMacro", "getDefaultValue"));
        }
        return "a";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/cidr/lang/editor/liveTemplates/OCVariableOfTypeMacro", "calculateResult"));
        }
        PsiElement[] variables = OCVariableOfTypeMacro.getVariables(params, context);
        if (variables == null || variables.length == 0) {
            return null;
        }
        return new OCElementResult((OCElement)variables[0]);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/cidr/lang/editor/liveTemplates/OCVariableOfTypeMacro", "calculateLookupItems"));
        }
        PsiElement[] variables = OCVariableOfTypeMacro.getVariables(params, context);
        if (variables == null || variables.length < 2) {
            return null;
        }
        LookupElement[] items = new LookupElement[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            PsiElement var = variables[i];
            items[i] = var instanceof PsiNamedElement ? LookupElementBuilder.create((PsiNamedElement)((PsiNamedElement)var)).withIcon(var.getIcon(0)) : LookupElementBuilder.create((String)var.getText()).withIcon(OCIcons.CodeAssistantMember);
        }
        return items;
    }

    @Nullable
    protected static PsiElement[] getVariables(Expression[] params, ExpressionContext context) {
        OCType type;
        String typeText;
        if (params.length != 1) {
            return null;
        }
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        PsiFile file2 = place.getContainingFile();
        assert (file2 != null);
        Result param = params[0].calculateResult(context);
        String string = typeText = param != null ? param.toString() : "";
        if (typeText.isEmpty()) {
            type = null;
        } else {
            OCDeclaration dcl = OCElementFactory.declarationFromText(typeText + "x;", (PsiElement)file2);
            List<OCDeclarator> declarators = dcl.getDeclarators();
            if (declarators.size() == 1) {
                OCType unresolved = declarators.get(0).getType();
                type = unresolved.resolve(file2);
            } else {
                type = null;
            }
        }
        ArrayList<PsiNameIdentifierOwner> result2 = new ArrayList<PsiNameIdentifierOwner>();
        List<OCDeclaratorSymbol> variables = OCTemplatesUtil.getVariablesVisibleAt(place, false);
        for (OCDeclaratorSymbol var : variables) {
            PsiElement parent;
            PsiNameIdentifierOwner def;
            OCType varResolvedType = var.getType().resolve(file2);
            if (type != null && !type.isCompatible(varResolvedType, (PsiElement)file2) || (def = (PsiNameIdentifierOwner)var.locateDefinition()) == null || (parent = def.getContext().getContext()) instanceof OCForeachStatement) continue;
            result2.add(def);
        }
        return PsiUtilCore.toPsiElementArray(result2);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof OCCodeContextType;
    }
}

