/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.editor.completion.OCCodeContextType;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class OCSuggestVariableNameMacro
extends Macro {
    public String getName() {
        return "suggestVariableName";
    }

    public String getPresentableName() {
        return "suggestVariableName()";
    }

    @NotNull
    public String getDefaultValue() {
        if ("a" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/liveTemplates/OCSuggestVariableNameMacro", "getDefaultValue"));
        }
        return "a";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/cidr/lang/editor/liveTemplates/OCSuggestVariableNameMacro", "calculateResult"));
        }
        Collection<String> names = OCSuggestVariableNameMacro.getNames(context);
        return names.isEmpty() ? null : new TextResult(names.iterator().next());
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/cidr/lang/editor/liveTemplates/OCSuggestVariableNameMacro", "calculateLookupItems"));
        }
        Collection<String> names = OCSuggestVariableNameMacro.getNames(context);
        if (names.size() < 2) {
            return null;
        }
        LookupElement[] items = new LookupElement[names.size()];
        int i = 0;
        for (String name : names) {
            items[i++] = LookupElementBuilder.create((Object)name, (String)name);
        }
        return items;
    }

    private static Collection<String> getNames(ExpressionContext context) {
        Collection<String> names = OCTemplatesUtil.getNames(context);
        if (names == null || names.isEmpty()) {
            return Collections.emptyList();
        }
        names = new LinkedHashSet<String>(names);
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        String safeName = place.getText();
        Iterator<String> it = names.iterator();
        String firstNotUnique = null;
        while (it.hasNext()) {
            String name = it.next();
            if (name.equals(safeName) || OCCodeInsightUtil.isUniqueInScope(null, name, place, context.getProject())) continue;
            it.remove();
            if (firstNotUnique != null) continue;
            firstNotUnique = name;
        }
        if (names.isEmpty()) {
            return Collections.singleton(OCNameSuggester.suggestUniqueName(null, firstNotUnique, place));
        }
        return names;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof OCCodeContextType;
    }
}

