/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.editor.completion.OCCodeContextType;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSuggestIndexNameMacro
extends Macro {
    public String getName() {
        return "suggestIndexName";
    }

    public String getPresentableName() {
        return "suggestIndexName()";
    }

    @NotNull
    public String getDefaultValue() {
        if ("i" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/liveTemplates/OCSuggestIndexNameMacro", "getDefaultValue"));
        }
        return "i";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/cidr/lang/editor/liveTemplates/OCSuggestIndexNameMacro", "calculateResult"));
        }
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        PsiFile file2 = place.getContainingFile();
        assert (file2 != null);
        String[] candidates = new String[]{"i", "j", "k", "l", "m", "n"};
        int attempt = 0;
        while (true) {
            for (String candidate : candidates) {
                if (attempt > 0) {
                    candidate = candidate + attempt;
                }
                if (!OCSuggestIndexNameMacro.isNameAvailable(candidate, file2, place)) continue;
                return new TextResult(candidate);
            }
            ++attempt;
        }
    }

    private static boolean isNameAvailable(@NotNull String candidate, @NotNull PsiFile file2, @Nullable PsiElement context) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/jetbrains/cidr/lang/editor/liveTemplates/OCSuggestIndexNameMacro", "isNameAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/editor/liveTemplates/OCSuggestIndexNameMacro", "isNameAvailable"));
        }
        OCSymbol symbol = OCCodeInsightUtil.resolveNameInScope(OCSymbolKind.LOCAL_VARIABLE, candidate, null, context, file2.getProject());
        if (symbol == null) {
            return true;
        }
        if (context == null) {
            return false;
        }
        PsiElement parent = context.getParent();
        return parent instanceof OCDeclarator && parent.equals(symbol.locateDefinition());
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof OCCodeContextType;
    }
}

