/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.editor.completion.OCCodeContextType;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;

public class OCExpressionFormatCodeMacro
extends Macro {
    public String getName() {
        return "expressionFormatCode";
    }

    public String getPresentableName() {
        return "expressionFormatCode()";
    }

    @NotNull
    public String getDefaultValue() {
        if ("%@" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/liveTemplates/OCExpressionFormatCodeMacro", "getDefaultValue"));
        }
        return "%@";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        PsiElement place;
        OCExpression expr;
        String exprText;
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/cidr/lang/editor/liveTemplates/OCExpressionFormatCodeMacro", "calculateResult"));
        }
        if (params.length != 1) {
            return null;
        }
        Result result2 = params[0].calculateResult(context);
        if (result2 != null && (exprText = result2.toString()).length() > 0 && (expr = OCElementFactory.expressionFromText(exprText, place = OCTemplatesUtil.getInsertionPlace(context))) != null) {
            String format = expr.getResolvedType().getFormatString();
            return format != null ? new TextResult(format) : null;
        }
        return null;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof OCCodeContextType;
    }
}

