/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCClassNameMacro
extends Macro {
    public String getName() {
        return "className";
    }

    public String getPresentableName() {
        return "className()";
    }

    public String getDefaultValue() {
        return "NSObject";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/cidr/lang/editor/liveTemplates/OCClassNameMacro", "calculateResult"));
        }
        OCClassSymbol symbol = OCClassNameMacro.getExpectedSymbol(context);
        return symbol != null ? new TextResult(symbol.getName()) : null;
    }

    @Nullable
    private static OCClassSymbol getExpectedSymbol(ExpressionContext context) {
        OCType type;
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        PsiFile file2 = place.getContainingFile();
        assert (file2 != null);
        OCSendMessageExpression expression = (OCSendMessageExpression)PsiTreeUtil.getParentOfType((PsiElement)place, OCSendMessageExpression.class);
        expression = expression != null && expression.getParent() instanceof OCSendMessageExpression ? (OCSendMessageExpression)expression.getParent() : null;
        OCType oCType = type = expression != null ? OCExpectedTypeUtil.getExpectedType(expression).resolve(file2) : null;
        if (type instanceof OCPointerType && type.isPointerToObject()) {
            return ((OCObjectType)type.getTerminalType()).getClassSymbol();
        }
        return null;
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/cidr/lang/editor/liveTemplates/OCClassNameMacro", "calculateLookupItems"));
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)context.getProject()).getPsiFile(context.getEditor().getDocument());
        final HashSet names = new HashSet();
        final ArrayList<LookupElementBuilder> answer = new ArrayList<LookupElementBuilder>();
        if (file2 instanceof OCFile) {
            final OCClassSymbol expectedSymbol = OCClassNameMacro.getExpectedSymbol(context);
            if (expectedSymbol != null) {
                answer.add(SymbolLookupBuilderUtil.lookup(expectedSymbol));
            }
            OCGlobalProjectSymbolsCache.processTopLevelSymbols(file2.getProject(), new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    if (symbol instanceof OCInterfaceSymbol && !symbol.isPredeclaration() && symbol != expectedSymbol && ((OCInterfaceSymbol)symbol).getCategoryName() == null && names.add(symbol.getName())) {
                        answer.add(SymbolLookupBuilderUtil.lookup(symbol));
                    }
                    return true;
                }
            }, null);
            return answer.toArray(new LookupElement[answer.size()]);
        }
        return null;
    }
}

