/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.resolve.OCSelectorAdHocResolver;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SelectorExpressionCompletionContributor
extends OCCompletionContributorBase {
    public SelectorExpressionCompletionContributor() {
        OCCompletionProvider provider = new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result2) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/cidr/lang/editor/completion/SelectorExpressionCompletionContributor$1", "addCompletions"));
                }
                MethodsProcessor processor2 = new MethodsProcessor(result2);
                OCSelectorExpression selectorExpr = (OCSelectorExpression)parameters.getPosition().getParent();
                OCObjectTypeContext typeContext = OCSelectorAdHocResolver.getActionTargetContext(selectorExpr);
                if (typeContext != null && parameters.getInvocationCount() < 2) {
                    typeContext.getType().getClassSymbol().processMembersInAllCategories(null, OCMethodSymbol.class, processor2, false);
                    result2.addLookupAdvertisement("Press " + SelectorExpressionCompletionContributor.getActionShortcut((String)"CodeCompletion") + " again for all method selectors");
                } else {
                    processor2.myCheckInterfaces = true;
                    OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(selectorExpr.getProject(), processor2, null);
                    processor2.myCheckInterfaces = false;
                    OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(selectorExpr.getProject(), processor2, null);
                }
            }
        };
        PsiElementPattern.Capture place = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(OCSelectorExpression.class);
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)place, provider);
        this.register(CompletionType.SMART, (ElementPattern<? extends PsiElement>)place, provider);
    }

    private static class MethodsProcessor
    implements Processor<OCSymbol> {
        private final Set<String> myNames = new HashSet<String>();
        private boolean myCheckInterfaces;
        private CompletionResultSet myResult;

        private MethodsProcessor(CompletionResultSet result2) {
            this.myResult = result2;
        }

        public boolean process(OCSymbol symbol) {
            if (!(symbol instanceof OCMethodSymbol) || this.myCheckInterfaces != ((OCMethodSymbol)symbol).getParent() instanceof OCInterfaceSymbol) {
                return true;
            }
            if (!this.myNames.contains(symbol.getName())) {
                Icon icon = symbol.getBaseIcon();
                this.myResult.addElement((LookupElement)SymbolLookupBuilderUtil.lookup(symbol.getName(), symbol, false, null, null, null, null, icon).withInsertHandler(null));
                this.myNames.add(symbol.getName());
            }
            return true;
        }
    }
}

